/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.search.model;

import com.jaspersoft.jasperserver.api.engine.common.service.ActionModelSupport;
import com.jaspersoft.jasperserver.api.engine.common.service.impl.ActionModel;
import com.jaspersoft.jasperserver.api.engine.common.service.impl.ActionModelServiceImpl;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.RoleImpl;
import com.jaspersoft.jasperserver.search.common.SearchMode;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchActionModelSupport
implements ActionModelSupport,
InitializingBean {
    private static final Log log = LogFactory.getLog(SearchActionModelSupport.class);
    private static final String ACTION_MODEL_CONTEXT = "search";
    private static final String ARGUMENT_DELIMITER_REGEXP = "@@";
    private static final String ROLE_DELIMITER_REGEXP = ",";
    private static final String MODE_DELIMITER_REGEXP = ",";
    private static final String TENANT_DELIMITER_REGEXP = "\\|";
    private static SearchActionModelSupport instance;
    private MessageSource messages;
    private SearchMode searchMode;
    private static final String LICENSE_MANAGER = "com.jaspersoft.ji.license.LicenseManager";

    public void setSearchMode(SearchMode searchMode) {
        this.searchMode = searchMode;
    }

    public String getClientActionModelDocument() {
        String data;
        Document document = ActionModelServiceImpl.getInstance().getActionModelMenu(ACTION_MODEL_CONTEXT);
        try {
            data = ActionModel.getInstance().generateClientActionModel((ActionModelSupport)this, document);
        }
        catch (Exception e) {
            log.error((Object)"Unable to create navigation menu");
            e.printStackTrace();
            data = "";
        }
        return data;
    }

    public boolean checkAuthenticationRoles(String allowedRoleNames) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        User principal = (User)authentication.getPrincipal();
        Set userRoles = principal.getRoles();
        Set<Role> allowedRoles = this.toRoles(allowedRoleNames.split(","));
        for (Role role : allowedRoles) {
            if (!userRoles.contains(role)) continue;
            return true;
        }
        return false;
    }

    public boolean checkMode(String allowedSearchModes) {
        HashSet<SearchMode> modes = new HashSet<SearchMode>();
        for (String name : allowedSearchModes.split(",")) {
            modes.add(SearchMode.valueOf(name.toUpperCase()));
        }
        return modes.contains((Object)this.searchMode);
    }

    private Set<Role> toRoles(String[] roleNames) {
        HashSet<Role> roles = new HashSet<Role>();
        for (String name : roleNames) {
            String[] parts = name.trim().split(TENANT_DELIMITER_REGEXP);
            RoleImpl role = new RoleImpl();
            role.setRoleName(parts[0]);
            role.setTenantId(parts.length > 1 ? parts[0] : null);
            roles.add((Role)role);
        }
        return roles;
    }

    public boolean isProVersion() {
        boolean isPro;
        block3: {
            isPro = false;
            try {
                Class<?> clazz = Class.forName(LICENSE_MANAGER);
                if (clazz != null) {
                    isPro = true;
                }
            }
            catch (ClassNotFoundException e) {
                if (!log.isDebugEnabled()) break block3;
                log.info((Object)"This is not a pro version. Access is denied");
            }
        }
        return isPro;
    }

    public static synchronized SearchActionModelSupport getInstance(String searchMode) {
        instance.setSearchMode(SearchMode.valueOf(searchMode.toUpperCase()));
        return instance;
    }

    public void afterPropertiesSet() throws Exception {
        instance = this;
    }

    public String getMessage(String label) {
        return this.messages.getMessage(label, null, LocaleContextHolder.getLocale());
    }

    public void setDefaultMessageSource(MessageSource messages) {
        this.messages = messages;
    }
}

