/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.quartz;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.Output;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.ReportOutput;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataContainer;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import net.sf.jasperreports.engine.export.oasis.JROdtExporter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionException;

public class OdtReportOutput
implements Output {
    private static final Log log = LogFactory.getLog(OdtReportOutput.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReportOutput getOutput(EngineService engineService, ExecutionContext executionContext, String reportUnitURI, DataContainer odtData, JRHyperlinkProducerFactory hyperlinkProducerFactory, RepositoryService repositoryService, JasperPrint jasperPrint, String baseFilename, Locale locale, String characterEncoding) throws JobExecutionException {
        try {
            JROdtExporter exporter = new JROdtExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            boolean close = false;
            OutputStream odtDataOut = odtData.getOutputStream();
            try {
                exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)characterEncoding);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)odtDataOut);
                exporter.exportReport();
                close = false;
                odtDataOut.close();
                String fileName = baseFilename + ".odt";
                ReportOutput reportOutput = new ReportOutput(odtData, "odt", fileName);
                return reportOutput;
            }
            catch (IOException e) {
                throw new JSExceptionWrapper((Exception)e);
            }
            finally {
                if (close) {
                    try {
                        odtDataOut.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error closing stream", (Throwable)e);
                    }
                }
            }
        }
        catch (JRException e) {
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }
}

