/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.directwebremoting.ScriptSession;
import org.directwebremoting.ServerContext;
import org.directwebremoting.ServerContextFactory;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.guice.ApplicationScoped;
import org.directwebremoting.guice.DwrGuiceUtil;
import org.directwebremoting.guice.DwrScopes;
import org.directwebremoting.guice.GlobalApplicationScoped;
import org.directwebremoting.guice.RequestParameters;
import org.directwebremoting.guice.RequestScoped;
import org.directwebremoting.guice.ScriptSessionScoped;
import org.directwebremoting.guice.SessionScoped;

class DwrGuiceServletModule
extends AbstractModule {
    private final boolean bindPotentiallyConflictingTypes;

    public DwrGuiceServletModule() {
        this.bindPotentiallyConflictingTypes = true;
    }

    public DwrGuiceServletModule(boolean bindPotentiallyConflictingTypes) {
        this.bindPotentiallyConflictingTypes = bindPotentiallyConflictingTypes;
    }

    protected void configure() {
        this.bindScope(RequestScoped.class, DwrScopes.REQUEST);
        this.bindScope(SessionScoped.class, DwrScopes.SESSION);
        this.bindScope(ScriptSessionScoped.class, DwrScopes.SCRIPT);
        this.bindScope(ApplicationScoped.class, DwrScopes.APPLICATION);
        this.bindScope(GlobalApplicationScoped.class, DwrScopes.GLOBAL);
        if (this.bindPotentiallyConflictingTypes) {
            Provider<HttpServletRequest> requestProvider = new Provider<HttpServletRequest>(){

                public HttpServletRequest get() {
                    WebContext webcx = WebContextFactory.get();
                    return webcx.getHttpServletRequest();
                }

                public String toString() {
                    return "RequestProvider";
                }
            };
            this.bind(HttpServletRequest.class).toProvider((Provider)requestProvider);
            this.bind(ServletRequest.class).toProvider((Provider)requestProvider);
            Provider<HttpServletResponse> responseProvider = new Provider<HttpServletResponse>(){

                public HttpServletResponse get() {
                    WebContext webcx = WebContextFactory.get();
                    return webcx.getHttpServletResponse();
                }

                public String toString() {
                    return "ResponseProvider";
                }
            };
            this.bind(HttpServletResponse.class).toProvider((Provider)responseProvider);
            this.bind(ServletResponse.class).toProvider((Provider)responseProvider);
            Provider<HttpSession> sessionProvider = new Provider<HttpSession>(){

                public HttpSession get() {
                    WebContext webcx = WebContextFactory.get();
                    return webcx.getSession();
                }

                public String toString() {
                    return "SessionProvider";
                }
            };
            this.bind(HttpSession.class).toProvider((Provider)sessionProvider);
        }
        Provider<Map<String, String[]>> requestParametersProvider = new Provider<Map<String, String[]>>(){

            public Map<String, String[]> get() {
                WebContext webcx = WebContextFactory.get();
                return webcx.getHttpServletRequest().getParameterMap();
            }

            public String toString() {
                return "RequestParametersProvider";
            }
        };
        this.bind((TypeLiteral)new TypeLiteral<Map<String, String[]>>(){}).annotatedWith(RequestParameters.class).toProvider((Provider)requestParametersProvider);
        Provider<ScriptSession> scriptSessionProvider = new Provider<ScriptSession>(){

            public ScriptSession get() {
                WebContext webcx = WebContextFactory.get();
                return webcx.getScriptSession();
            }

            public String toString() {
                return "ScriptSessionProvider";
            }
        };
        this.bind(ScriptSession.class).toProvider((Provider)scriptSessionProvider);
        Provider<ServletContext> servletContextProvider = new Provider<ServletContext>(){

            public ServletContext get() {
                return DwrGuiceUtil.getServletContext();
            }

            public String toString() {
                return "ServletContextProvider";
            }
        };
        this.bind(ServletContext.class).toProvider((Provider)servletContextProvider);
        Provider<WebContext> webContextProvider = new Provider<WebContext>(){

            public WebContext get() {
                return WebContextFactory.get();
            }

            public String toString() {
                return "WebContextProvider";
            }
        };
        this.bind(WebContext.class).toProvider((Provider)webContextProvider);
        Provider<ServerContext> serverContextProvider = new Provider<ServerContext>(){

            public ServerContext get() {
                return ServerContextFactory.get(DwrGuiceUtil.getServletContext());
            }

            public String toString() {
                return "ServerContextProvider";
            }
        };
        this.bind(ServerContext.class).toProvider((Provider)serverContextProvider);
    }
}

