/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import java.beans.PropertyEditor;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.validation.AbstractBindingResult;

public abstract class AbstractPropertyBindingResult
extends AbstractBindingResult {
    protected AbstractPropertyBindingResult(String objectName) {
        super(objectName);
    }

    public PropertyEditorRegistry getPropertyEditorRegistry() {
        return this.getPropertyAccessor();
    }

    protected String canonicalFieldName(String field) {
        return PropertyAccessorUtils.canonicalPropertyName(field);
    }

    public Class getFieldType(String field) {
        return this.getPropertyAccessor().getPropertyType(this.fixedField(field));
    }

    protected Object getActualFieldValue(String field) {
        return this.getPropertyAccessor().getPropertyValue(field);
    }

    protected Object formatFieldValue(String field, Object value) {
        PropertyEditor customEditor = this.getCustomEditor(field);
        if (customEditor != null) {
            customEditor.setValue(value);
            String textValue = customEditor.getAsText();
            if (textValue != null) {
                return textValue;
            }
        }
        return value;
    }

    protected PropertyEditor getCustomEditor(String field) {
        String fixedField = this.fixedField(field);
        Class targetType = this.getPropertyAccessor().getPropertyType(fixedField);
        PropertyEditor editor = this.getPropertyAccessor().findCustomEditor(targetType, fixedField);
        if (editor == null) {
            editor = BeanUtils.findEditorByConvention(targetType);
        }
        return editor;
    }

    public abstract ConfigurablePropertyAccessor getPropertyAccessor();
}

