/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.tools.generic.DateTool;
import org.apache.velocity.tools.generic.NumberTool;
import org.hibernate.tool.hbm2x.ExporterException;
import org.hibernate.tool.hbm2x.HibernateUberspect;
import org.hibernate.tool.hbm2x.RenderTool;
import org.hibernate.tool.hbm2x.Version;

public class TemplateHelper {
    static final Log log = LogFactory.getLog((Class)TemplateHelper.class);
    private VelocityContext context;
    private VelocityEngine engine;
    private String templatePrefix;
    private File outputDirectory;

    public void init(File outputDirectory, String templatePrefix, String[] templatePaths) {
        this.outputDirectory = outputDirectory;
        this.context = new VelocityContext();
        this.engine = new VelocityEngine();
        this.templatePrefix = templatePrefix;
        Properties p = new Properties();
        p.setProperty("runtime.log.logsystem.class", "org.apache.velocity.tools.generic.log.CommonsLogLogSystem");
        p.setProperty("runtime.log.logsystem.commons.logging.name", "org.hibernate.tool.hbm2x.template");
        p.setProperty("runtime.introspector.uberspect", HibernateUberspect.class.getName());
        p.setProperty("velocimacro.library", "");
        p.setProperty("resource.loader", "file, class");
        p.setProperty("class.resource.loader.class", ClasspathResourceLoader.class.getName());
        if (templatePaths != null && templatePaths.length > 0) {
            StringBuffer cvspath = new StringBuffer();
            for (int i = 0; i < templatePaths.length; ++i) {
                String path = templatePaths[i];
                if (i > 0) {
                    cvspath.append(",");
                }
                cvspath.append(path);
            }
            p.setProperty("file.resource.loader.path", cvspath.toString());
        }
        try {
            this.engine.init(p);
        }
        catch (Exception e) {
            throw new ExporterException("Velocity engine could not be initialized", e);
        }
    }

    public void setupContext() {
        this.getContext().put("render", (Object)new RenderTool(this.getEngine()));
        this.getContext().put("version", (Object)Version.getDefault());
        this.getContext().put("ctx", (Object)this.getContext());
        this.getContext().put("templates", (Object)new Templates());
        this.getContext().put("date", (Object)new DateTool());
        this.getContext().put("math", (Object)new DateTool());
        this.getContext().put("number", (Object)new NumberTool());
    }

    public void processTemplate(String templateName, Writer output) {
        try {
            this.getEngine().mergeTemplate(this.getTemplateName(templateName), this.getContext(), output);
        }
        catch (IOException e) {
            throw new ExporterException("Error while processing template " + templateName, e);
        }
        catch (ResourceNotFoundException e) {
            throw new ExporterException("Resource not found while processing template " + templateName + ". " + e.getMessage(), e);
        }
        catch (ParseErrorException e) {
            throw new ExporterException("Parse error while processing template " + templateName + ". " + e.getMessage(), e);
        }
        catch (MethodInvocationException e) {
            throw new ExporterException("MethodInvocationException while processing template " + templateName + ". " + e.getMessage(), e.getWrappedThrowable() == null ? e : e.getWrappedThrowable());
        }
        catch (Exception e) {
            throw new ExporterException("Error while processing template " + templateName, e);
        }
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    String getTemplateName(String name) {
        if (!name.endsWith(".vm")) {
            name = name + ".vm";
        }
        if (this.templatePrefix != null && this.getEngine().templateExists(this.templatePrefix + name)) {
            return this.templatePrefix + name;
        }
        if (this.getEngine().templateExists(name)) {
            return name;
        }
        throw new ExporterException("Could not find template with name: " + name);
    }

    public void processString(String template, Writer output) {
        try {
            this.getEngine().evaluate(this.getContext(), output, "TemplateHelper", template);
        }
        catch (IOException e) {
            throw new ExporterException("Error while processing template string", e);
        }
        catch (ResourceNotFoundException e) {
            throw new ExporterException("Error while processing template string", e);
        }
        catch (ParseErrorException e) {
            throw new ExporterException("Error while processing template string", e);
        }
        catch (MethodInvocationException e) {
            throw new ExporterException("Error while processing template string", e);
        }
        catch (Exception e) {
            throw new ExporterException("Error while processing template string", e);
        }
    }

    protected Context getContext() {
        return this.context;
    }

    protected VelocityEngine getEngine() {
        return this.engine;
    }

    public void putInContext(String key, Object value) {
        log.trace((Object)("putInContext " + key + "=" + value));
        if (value == null) {
            throw new IllegalStateException("value must not be null for " + key);
        }
        Object replaced = this.getContext().put(key, value);
        if (replaced != null) {
            throw new IllegalStateException(replaced + " found when setting " + key);
        }
    }

    public void removeFromContext(String key, Object expected) {
        log.trace((Object)("removeFromContext " + key + "=" + expected));
        Object replaced = this.getContext().remove((Object)key);
        if (replaced == null) {
            throw new IllegalStateException(key + " did not exist in template context.");
        }
        if (replaced != expected) {
            throw new IllegalStateException("expected " + key + " to be bound to " + expected + " but was to " + replaced);
        }
    }

    public boolean templateExists(String templateName) {
        return this.getEngine().templateExists(templateName);
    }

    public void ensureExistence(File destination) {
        File dir = destination.getAbsoluteFile().getParentFile();
        if (dir.exists() && !dir.isDirectory()) {
            throw new ExporterException("The path: " + dir.getAbsolutePath() + " exists, but is not a directory");
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new ExporterException("unable to create directory: " + dir.getAbsolutePath());
        }
    }

    public class Templates {
        public String get(String name) {
            StringWriter sw = new StringWriter();
            String usedName = TemplateHelper.this.getTemplateName(name);
            TemplateHelper.this.processTemplate(usedName, sw);
            return sw.toString();
        }

        public void create(String templateName, String fileName) {
            Writer fw = null;
            try {
                fw = new BufferedWriter(new FileWriter(new File(TemplateHelper.this.getOutputDirectory(), fileName)));
                TemplateHelper.this.processTemplate(templateName, fw);
            }
            catch (IOException io) {
                throw new ExporterException("Problem when writing to " + fileName, io);
            }
            finally {
                if (fw != null) {
                    try {
                        fw.flush();
                        fw.close();
                    }
                    catch (IOException io) {}
                }
            }
        }
    }
}

