/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.design;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRPieSeries;
import net.sf.jasperreports.charts.design.JRDesignPieSeries;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.design.JRDesignChartDataset;
import net.sf.jasperreports.engine.design.JRVerifier;

public class JRDesignPieDataset
extends JRDesignChartDataset
implements JRPieDataset {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_MIN_PERCENTAGE = "minPercentage";
    public static final String PROPERTY_MAX_COUNT = "maxCount";
    public static final String PROPERTY_PIE_SERIES = "pieSeries";
    public static final String PROPERTY_KEY_EXPRESSION = "keyExpression";
    public static final String PROPERTY_VALUE_EXPRESSION = "valueExpression";
    public static final String PROPERTY_LABEL_EXPRESSION = "labelExpression";
    public static final String PROPERTY_SECTION_HYPERLINK = "sectionHyperlink";
    public static final String PROPERTY_OTHER_KEY_EXPRESSION = "otherKeyExpression";
    public static final String PROPERTY_OTHER_LABEL_EXPRESSION = "otherLabelExpression";
    public static final String PROPERTY_OTHER_SECTION_HYPERLINK = "otherSectionHyperlink";
    private Float minPercentage;
    private Integer maxCount;
    private List pieSeriesList = new ArrayList();
    protected JRExpression otherKeyExpression;
    protected JRExpression otherLabelExpression;
    private JRHyperlink otherSectionHyperlink;
    private JRExpression keyExpression;
    private JRExpression valueExpression;
    private JRExpression labelExpression;
    private JRHyperlink sectionHyperlink;

    public JRDesignPieDataset(JRChartDataset dataset) {
        super(dataset);
    }

    public Float getMinPercentage() {
        return this.minPercentage;
    }

    public void setMinPercentage(Float minPercentage) {
        Float old = this.minPercentage;
        this.minPercentage = minPercentage;
        this.getEventSupport().firePropertyChange(PROPERTY_MIN_PERCENTAGE, old, this.minPercentage);
    }

    public Integer getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(Integer maxCount) {
        Integer old = this.maxCount;
        this.maxCount = maxCount;
        this.getEventSupport().firePropertyChange(PROPERTY_MAX_COUNT, old, this.maxCount);
    }

    public JRPieSeries[] getSeries() {
        JRPieSeries[] pieSeriesArray = new JRPieSeries[this.pieSeriesList.size()];
        this.pieSeriesList.toArray(pieSeriesArray);
        return pieSeriesArray;
    }

    public List getSeriesList() {
        return this.pieSeriesList;
    }

    public void addPieSeries(JRPieSeries pieSeries) {
        this.pieSeriesList.add(pieSeries);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PIE_SERIES, pieSeries, this.pieSeriesList.size() - 1);
    }

    public void addPieSeries(int index, JRPieSeries pieSeries) {
        this.pieSeriesList.add(index, pieSeries);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PIE_SERIES, pieSeries, index);
    }

    public JRPieSeries removePieSeries(JRPieSeries pieSeries) {
        int idx;
        if (pieSeries != null && (idx = this.pieSeriesList.indexOf(pieSeries)) >= 0) {
            this.pieSeriesList.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_PIE_SERIES, pieSeries, idx);
        }
        return pieSeries;
    }

    public JRExpression getKeyExpression() {
        return this.pieSeriesList.size() > 0 ? ((JRPieSeries)this.pieSeriesList.get(0)).getKeyExpression() : null;
    }

    public void setKeyExpression(JRExpression keyExpression) {
        if (this.pieSeriesList.size() == 0) {
            this.addPieSeries(new JRDesignPieSeries());
        }
        ((JRDesignPieSeries)this.pieSeriesList.get(0)).setKeyExpression(keyExpression);
    }

    public JRExpression getValueExpression() {
        return this.pieSeriesList.size() > 0 ? ((JRPieSeries)this.pieSeriesList.get(0)).getValueExpression() : null;
    }

    public void setValueExpression(JRExpression valueExpression) {
        if (this.pieSeriesList.size() == 0) {
            this.addPieSeries(new JRDesignPieSeries());
        }
        ((JRDesignPieSeries)this.pieSeriesList.get(0)).setValueExpression(valueExpression);
    }

    public JRExpression getLabelExpression() {
        return this.pieSeriesList.size() > 0 ? ((JRPieSeries)this.pieSeriesList.get(0)).getLabelExpression() : null;
    }

    public void setLabelExpression(JRExpression labelExpression) {
        if (this.pieSeriesList.size() == 0) {
            this.addPieSeries(new JRDesignPieSeries());
        }
        ((JRDesignPieSeries)this.pieSeriesList.get(0)).setLabelExpression(labelExpression);
    }

    public JRHyperlink getSectionHyperlink() {
        return this.pieSeriesList.size() > 0 ? ((JRPieSeries)this.pieSeriesList.get(0)).getSectionHyperlink() : null;
    }

    public void setSectionHyperlink(JRHyperlink sectionHyperlink) {
        if (this.pieSeriesList.size() == 0) {
            this.addPieSeries(new JRDesignPieSeries());
        }
        ((JRDesignPieSeries)this.pieSeriesList.get(0)).setSectionHyperlink(sectionHyperlink);
    }

    public JRExpression getOtherKeyExpression() {
        return this.otherKeyExpression;
    }

    public void setOtherKeyExpression(JRExpression otherKeyExpression) {
        JRExpression old = this.otherKeyExpression;
        this.otherKeyExpression = otherKeyExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_OTHER_KEY_EXPRESSION, old, this.otherKeyExpression);
    }

    public JRExpression getOtherLabelExpression() {
        return this.otherLabelExpression;
    }

    public void setOtherLabelExpression(JRExpression otherLabelExpression) {
        JRExpression old = this.otherLabelExpression;
        this.otherLabelExpression = otherLabelExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_OTHER_LABEL_EXPRESSION, old, this.otherLabelExpression);
    }

    public JRHyperlink getOtherSectionHyperlink() {
        return this.otherSectionHyperlink;
    }

    public void setOtherSectionHyperlink(JRHyperlink otherSectionHyperlink) {
        JRHyperlink old = this.otherSectionHyperlink;
        this.otherSectionHyperlink = otherSectionHyperlink;
        this.getEventSupport().firePropertyChange(PROPERTY_OTHER_SECTION_HYPERLINK, old, this.otherSectionHyperlink);
    }

    public byte getDatasetType() {
        return 1;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public void validate(JRVerifier verifier) {
        verifier.verify(this);
    }

    public Object clone() {
        JRDesignPieDataset clone = (JRDesignPieDataset)super.clone();
        if (this.pieSeriesList != null) {
            clone.pieSeriesList = new ArrayList(this.pieSeriesList.size());
            for (int i = 0; i < this.pieSeriesList.size(); ++i) {
                clone.pieSeriesList.add(((JRPieSeries)this.pieSeriesList.get(i)).clone());
            }
        }
        if (this.otherKeyExpression != null) {
            clone.otherKeyExpression = (JRExpression)this.otherKeyExpression.clone();
        }
        if (this.otherLabelExpression != null) {
            clone.otherLabelExpression = (JRExpression)this.otherLabelExpression.clone();
        }
        if (this.otherSectionHyperlink != null) {
            clone.otherSectionHyperlink = (JRHyperlink)this.otherSectionHyperlink.clone();
        }
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.pieSeriesList == null) {
            this.pieSeriesList = new ArrayList();
            JRDesignPieSeries ps = new JRDesignPieSeries();
            ps.setKeyExpression(this.keyExpression);
            ps.setValueExpression(this.valueExpression);
            ps.setLabelExpression(this.labelExpression);
            ps.setSectionHyperlink(this.sectionHyperlink);
            this.pieSeriesList.add(ps);
            this.keyExpression = null;
            this.valueExpression = null;
            this.labelExpression = null;
            this.sectionHyperlink = null;
        }
    }
}

