/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.themes;

import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateBeforeDeleteListener;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateSaveOrUpdateListener;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoResource;
import com.jaspersoft.jasperserver.war.themes.ThemeCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.event.DeleteEvent;
import org.hibernate.event.SaveOrUpdateEvent;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class ThemeHibernateListener
implements HibernateBeforeDeleteListener,
HibernateSaveOrUpdateListener,
BeanFactoryAware {
    private static Log log = LogFactory.getLog(ThemeHibernateListener.class);
    protected BeanFactory beanFactory;
    protected String themeCacheBeanName;
    protected ThemeCache themeCache;

    protected Log getLog() {
        return log;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public ThemeCache getThemeCache() {
        if (this.themeCache == null) {
            this.themeCache = (ThemeCache)this.beanFactory.getBean(this.themeCacheBeanName);
        }
        return this.themeCache;
    }

    protected void preProcessDelete(RepoResource res) {
    }

    protected void preProcessUpdate(RepoResource res) {
    }

    public void beforeDelete(DeleteEvent event) {
        Object obj = event.getObject();
        if (obj instanceof RepoResource) {
            RepoResource res = (RepoResource)obj;
            String uri = res.getResourceURI();
            if (this.getThemeCache().isThemeResource(uri)) {
                this.getLog().trace((Object)("onDelete: Resource :" + uri));
                this.preProcessDelete(res);
                this.getThemeCache().onThemeResourceChanged(uri);
            }
        }
    }

    public void beforeSaveOrUpdate(SaveOrUpdateEvent event) {
    }

    public void afterSaveOrUpdate(SaveOrUpdateEvent event) {
        Object obj = event.getObject();
        if (obj instanceof RepoResource) {
            RepoResource res = (RepoResource)obj;
            String uri = res.getResourceURI();
            if (this.getThemeCache().isThemeResource(uri)) {
                this.getLog().trace((Object)("onSaveOrUpdate: Resource :" + uri));
                this.preProcessUpdate(res);
                this.getThemeCache().onThemeResourceChanged(uri);
            }
        }
    }

    public String getThemeCacheBeanName() {
        return this.themeCacheBeanName;
    }

    public void setThemeCacheBeanName(String themeCacheBeanName) {
        this.themeCacheBeanName = themeCacheBeanName;
    }
}

