/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.dto;

import com.jaspersoft.jasperserver.api.common.util.MapEntry;
import com.jaspersoft.jasperserver.api.engine.common.service.ReportInputControlInformation;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValues;
import java.io.Serializable;
import java.text.Format;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeInputControlWrapper
implements Serializable {
    private InputControl inputControl;
    private Object value;
    private String errorMessage;
    private Format format;
    private Map queryResults;
    private ReportInputControlInformation controlInfo;
    private String resourceUriPrefix;
    private transient Map multiValueIndicator;
    private String displayLabel;
    private Map<String, String> listOfValuesDisplayLabels = new HashMap<String, String>();

    public RuntimeInputControlWrapper(InputControl inputControl) {
        this.inputControl = inputControl;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
        this.multiValueIndicator = null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public InputControl getInputControl() {
        return this.inputControl;
    }

    public void setInputControl(InputControl inputControl) {
        this.inputControl = inputControl;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public String getFormattedValue() {
        try {
            return this.format.format(this.value);
        }
        catch (Exception e) {
            return this.value != null ? this.value.toString() : null;
        }
    }

    public Map getQueryResults() {
        return this.queryResults;
    }

    public void setQueryResults(Map queryResults) {
        this.queryResults = queryResults;
    }

    public boolean isMulti() {
        if (this.inputControl == null) {
            return false;
        }
        byte type = this.inputControl.getType();
        return type == 5 || type == 6 || type == 10 || type == 7 || type == 11;
    }

    public boolean isMultiDistinctValues() {
        if (this.inputControl == null) {
            return false;
        }
        byte type = this.inputControl.getType();
        return type == 6 || type == 10 || type == 7 || type == 11;
    }

    public boolean isListOfValues() {
        byte type = this.inputControl.getType();
        return type == 3 || type == 8 || type == 6 || type == 10;
    }

    public boolean isQuery() {
        byte type = this.inputControl.getType();
        return type == 4 || type == 9 || type == 7 || type == 11;
    }

    public int getCollectionSize() {
        int size;
        if (this.isListOfValues()) {
            size = ((ListOfValues)this.getInputControl().getListOfValues().getLocalResource()).getValues().length;
        } else if (this.isQuery()) {
            size = this.getQueryResults().size();
        } else {
            throw new UnsupportedOperationException("getCollectionSize can only be called for LOV or query input controls");
        }
        return size;
    }

    public Map getCollectionValueIndicator() {
        if (this.multiValueIndicator == null && (this.isListOfValues() || this.isQuery())) {
            this.multiValueIndicator = new IndicatorMap((Collection)this.getValue());
        }
        return this.multiValueIndicator;
    }

    public ReportInputControlInformation getControlInfo() {
        return this.controlInfo;
    }

    public void setControlInfo(ReportInputControlInformation controlInfo) {
        this.controlInfo = controlInfo;
    }

    public String getResourceUriPrefix() {
        return this.resourceUriPrefix;
    }

    public void setResourceUriPrefix(String resourceUriPrefix) {
        this.resourceUriPrefix = resourceUriPrefix;
    }

    public String getDisplayLabel() {
        return this.displayLabel;
    }

    public void setDisplayLabel(String displayLabel) {
        this.displayLabel = displayLabel;
    }

    public Map<String, String> getListOfValuesDisplayLabels() {
        return this.listOfValuesDisplayLabels;
    }

    public void setListOfValuesDisplayLabels(Map<String, String> listOfValuesDisplayLabels) {
        this.listOfValuesDisplayLabels = listOfValuesDisplayLabels;
    }

    protected static class IndicatorMap
    extends AbstractMap {
        private final Set entries = new HashSet();

        public IndicatorMap(Collection keys) {
            if (keys != null) {
                for (Object o : keys) {
                    String key = o == null ? "~NULL~" : o;
                    MapEntry entry = new MapEntry((Object)key.toString(), (Object)Boolean.TRUE);
                    this.entries.add(entry);
                }
            }
        }

        public Set entrySet() {
            return this.entries;
        }
    }
}

