/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.common;

import com.jaspersoft.jasperserver.api.JSException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileBufferedOutputStream
extends OutputStream {
    private static final Log log = LogFactory.getLog(FileBufferedOutputStream.class);
    public static final int DEFAULT_MEMORY_THRESHOLD = 262144;
    public static final int INFINIT_MEMORY_THRESHOLD = -1;
    public static final int DEFAULT_INITIAL_MEMORY_BUFFER_SIZE = 65536;
    public static final int DEFAULT_INPUT_BUFFER_LENGTH = 16384;
    private final int memoryThreshold;
    private final int initialMemoryBufferSize;
    private final int inputBufferLenght;
    private final ByteArrayOutputStream memoryOutput;
    private int size;
    private File file;
    private BufferedOutputStream fileOutput;
    private boolean closed;
    private boolean disposed;

    public FileBufferedOutputStream() {
        this(262144, 65536, 16384);
    }

    public FileBufferedOutputStream(int memoryThreshold) {
        this(memoryThreshold, 65536, 16384);
    }

    public FileBufferedOutputStream(int memoryThreshold, int initialMemoryBufferSize) {
        this(memoryThreshold, initialMemoryBufferSize, 16384);
    }

    public FileBufferedOutputStream(int memoryThreshold, int initialMemoryBufferSize, int inputBufferLenght) {
        this.memoryThreshold = memoryThreshold;
        this.initialMemoryBufferSize = initialMemoryBufferSize;
        this.inputBufferLenght = inputBufferLenght;
        this.size = 0;
        this.memoryOutput = this.memoryThreshold != 0 ? new ByteArrayOutputStream(this.initialMemoryBufferSize) : null;
    }

    public void write(int b) throws IOException {
        this.checkClosed();
        if (this.availableMemorySpace() > 0) {
            this.memoryOutput.write(b);
        } else {
            this.ensureFileOutput().write(b);
        }
        ++this.size;
    }

    protected int availableMemorySpace() {
        int availableMemorySpace = this.memoryOutput != null && (this.memoryThreshold < 0 || this.memoryOutput.size() < this.memoryThreshold) ? this.memoryThreshold - this.memoryOutput.size() : 0;
        return availableMemorySpace;
    }

    protected BufferedOutputStream ensureFileOutput() throws IOException, FileNotFoundException {
        if (this.fileOutput == null) {
            this.file = File.createTempFile("exported_report", ".tmp");
            FileOutputStream fileOutputStream = new FileOutputStream(this.file);
            this.fileOutput = new BufferedOutputStream(fileOutputStream);
        }
        return this.fileOutput;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        int memoryLen = this.availableMemorySpace();
        if (len < memoryLen) {
            memoryLen = len;
        }
        if (memoryLen > 0) {
            this.memoryOutput.write(b, off, memoryLen);
        }
        if (memoryLen < len) {
            this.ensureFileOutput().write(b, off + memoryLen, len - memoryLen);
        }
        this.size += len;
    }

    public void checkClosed() {
        if (this.closed) {
            throw new JSException("jsexception.output.stream.already.closed");
        }
    }

    public void close() throws IOException {
        if (!this.closed && this.fileOutput != null) {
            this.fileOutput.flush();
            this.fileOutput.close();
        }
        this.closed = true;
    }

    public void flush() throws IOException {
        if (this.fileOutput != null) {
            this.fileOutput.flush();
        }
    }

    public int size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeData(OutputStream out) throws IOException {
        if (!this.closed) {
            this.close();
        }
        if (this.memoryOutput != null) {
            this.memoryOutput.writeTo(out);
        }
        if (this.file != null) {
            FileInputStream fileInput = new FileInputStream(this.file);
            boolean inputClosed = false;
            try {
                int read;
                byte[] buffer = new byte[this.inputBufferLenght];
                while ((read = fileInput.read(buffer)) > 0) {
                    out.write(buffer, 0, read);
                }
                fileInput.close();
                inputClosed = true;
            }
            finally {
                if (!inputClosed) {
                    try {
                        fileInput.close();
                    }
                    catch (IOException e) {
                        log.warn((Object)"Could not close file input stream", (Throwable)e);
                    }
                }
            }
        }
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        boolean success = true;
        if (!this.closed && this.fileOutput != null) {
            try {
                this.fileOutput.close();
            }
            catch (IOException e) {
                log.warn((Object)"Error while closing the temporary file output stream", (Throwable)e);
                success = false;
            }
        }
        if (this.file != null && !this.file.delete()) {
            log.warn((Object)"Error while deleting the temporary file");
            success = false;
        }
        this.disposed = success;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

