/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action.repositoryExplorer;

import com.jaspersoft.jasperserver.api.JSDuplicateResourceException;
import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.common.service.SecurityContextProvider;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportSchedulingService;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.ResourceLookupImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.JSResourceNotFoundException;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.RepositorySecurityChecker;
import com.jaspersoft.jasperserver.api.metadata.common.util.RepositoryLabelIDHelper;
import com.jaspersoft.jasperserver.api.metadata.user.service.ObjectPermissionService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.war.action.reportManager.ResourceListModel;
import com.jaspersoft.jasperserver.war.action.reportManager.ResourceRowModel;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.exception.ConstraintViolationException;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ResourceAction
extends FormAction {
    public static final String AJAX_REPORT_MODEL = "ajaxResponseModel";
    private RepositoryService repositoryService;
    private RepositorySecurityChecker repositoryServiceSecurityChecker;
    protected ObjectPermissionService objectPermissionService;
    private MessageSource messageSource;
    private ReportSchedulingService schedulingService;
    private int pagination;
    private String showMoveCopyConfirmation;
    private SecurityContextProvider securityContextProvider;
    private ConfigurationBean configuration;
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public SecurityContextProvider getSecurityContextProvider() {
        return this.securityContextProvider;
    }

    public void setSecurityContextProvider(SecurityContextProvider securityContextProvider) {
        this.securityContextProvider = securityContextProvider;
    }

    public ConfigurationBean getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ConfigurationBean configuration) {
        this.configuration = configuration;
    }

    public Event initEvent(RequestContext context) {
        String tenantId = this.securityContextProvider.getContextUser().getTenantId();
        context.getRequestScope().put("organizationId", (Object)tenantId);
        context.getRequestScope().put("publicFolderUri", (Object)this.configuration.getPublicFolderUri());
        return this.success();
    }

    public Event createFolder(RequestContext context) {
        try {
            String parentFolderUri = context.getRequestParameters().get("FolderUri");
            String folderName = URLDecoder.decode(context.getRequestParameters().get("FolderName"), "UTF-8");
            String folderDescription = URLDecoder.decode(context.getRequestParameters().get("FolderDescription"), "UTF-8");
            FolderImpl folder = new FolderImpl();
            folder.setParentFolder(parentFolderUri);
            String generatedId = RepositoryLabelIDHelper.generateIdBasedOnLabel((RepositoryService)this.repositoryService, (String)parentFolderUri, (String)folderName);
            folder.setName(generatedId);
            folder.setLabel(folderName);
            folder.setDescription(folderDescription);
            try {
                this.repositoryService.saveFolder(null, (Folder)folder);
            }
            catch (JSDuplicateResourceException e) {
                context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)e.toString());
                return this.error();
            }
            catch (JSResourceNotFoundException f) {
                context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)f.toString());
                return this.error();
            }
            context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)generatedId);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this.success();
    }

    public Event doesFolderExist(RequestContext context) {
        try {
            String parentFolderUri = URLDecoder.decode(context.getRequestParameters().get("FolderUri"), "UTF-8");
            String folderName = URLDecoder.decode(context.getRequestParameters().get("FolderName"), "UTF-8");
            if (folderName == null) {
                folderName = "";
            }
            try {
                List repoFolderList = this.repositoryService.getSubFolders(null, parentFolderUri);
                FilterCriteria criteria = FilterCriteria.createFilter();
                criteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)parentFolderUri));
                List resources = this.repositoryService.loadResourcesList(this.exContext(context), criteria);
                repoFolderList.addAll(resources);
                for (int i = 0; i < repoFolderList.size(); ++i) {
                    ResourceLookupImpl res;
                    if (repoFolderList.get(i) instanceof FolderImpl) {
                        FolderImpl repoFolder = (FolderImpl)repoFolderList.get(i);
                        if (!folderName.equalsIgnoreCase(repoFolder.getLabel())) continue;
                        context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)"DUPLICATE_DISPLAY_NAME");
                        return this.success();
                    }
                    if (!(repoFolderList.get(i) instanceof ResourceLookupImpl) || !folderName.equalsIgnoreCase((res = (ResourceLookupImpl)repoFolderList.get(i)).getLabel())) continue;
                    context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)"DUPLICATE_DISPLAY_NAME");
                    return this.success();
                }
            }
            catch (Exception e) {
                context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)e.toString());
                return this.success();
            }
            context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)"OK");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this.success();
    }

    public Event deleteFolder(RequestContext context) {
        try {
            String parentFolderUri = URLDecoder.decode(context.getRequestParameters().get("FolderUri"), "UTF-8");
            try {
                this.repositoryService.deleteFolder(null, parentFolderUri);
            }
            catch (Exception e) {
                context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)"ERROR:MISSING_RESOURCE");
                return this.success();
            }
            context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)"OK");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this.success();
    }

    public Event deleteResources(RequestContext context) {
        String errorUri = "";
        try {
            String parentFolderUri = URLDecoder.decode(context.getRequestParameters().get("ResourceList"), "UTF-8");
            StringTokenizer str = new StringTokenizer(parentFolderUri, ",");
            String currentResource = "";
            while (str.hasMoreTokens()) {
                try {
                    currentResource = str.nextToken();
                    this.repositoryService.deleteResource(null, currentResource);
                }
                catch (ConstraintViolationException f) {
                    if (!errorUri.equals("")) {
                        errorUri = errorUri + "," + currentResource;
                        continue;
                    }
                    errorUri = currentResource;
                }
                catch (JSResourceNotFoundException g) {
                }
                catch (Exception e) {
                    if (!errorUri.equals("")) {
                        errorUri = errorUri + "," + currentResource;
                        continue;
                    }
                    errorUri = currentResource;
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (errorUri.equals("")) {
            context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)"OK");
            return this.success();
        }
        context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)("ERROR," + errorUri));
        return this.success();
    }

    public Event getResources(RequestContext context) {
        try {
            String folderUri = URLDecoder.decode(context.getRequestParameters().get("FolderUri"), "UTF-8");
            String pageNumberString = context.getRequestParameters().get("PageNumber");
            int pageNumber = 0;
            if (pageNumberString != null) {
                try {
                    pageNumber = Integer.parseInt(pageNumberString);
                }
                catch (NumberFormatException e) {
                    pageNumber = 0;
                }
            }
            if (pageNumber < 0) {
                pageNumber = 0;
            }
            FilterCriteria criteria = FilterCriteria.createFilter();
            criteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)folderUri));
            List resources = this.repositoryService.loadResourcesList(this.exContext(context), criteria);
            ResourceListModel model = this.returnModel(resources, context, pageNumber);
            model.setParentUri(folderUri);
            context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)model);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this.success();
    }

    public ResourceListModel returnModel(List resources, RequestContext context, int pageNumber) {
        ResourceListModel listModel = new ResourceListModel();
        ArrayList<ResourceRowModel> listOfRows = new ArrayList<ResourceRowModel>();
        listModel.setSize(resources.size());
        int nResources = resources.size();
        listModel.setTotalPages((nResources - 1) / this.pagination + 1);
        listModel.setCurrentPageNumber(pageNumber + 1);
        int upperLimit = this.pagination * pageNumber + this.pagination > nResources ? nResources : this.pagination * pageNumber + this.pagination;
        for (int i = this.pagination * pageNumber; i < upperLimit; ++i) {
            ResourceLookupImpl res = (ResourceLookupImpl)resources.get(i);
            ResourceRowModel row = new ResourceRowModel();
            row.setName(res.getLabel());
            row.setHiddenName(res.getLabel().replaceAll("'", "\\\\'"));
            row.setId(res.getURIString());
            row.setResourceUrl("");
            String description = res.getDescription();
            if (description == null || "".equals(description)) {
                description = "&nbsp;";
            }
            row.setDescription(description == null ? "" : description);
            row.setType(this.messageSource.getMessage("resource." + res.getResourceType() + ".label", null, LocaleContextHolder.getLocale()));
            row.setResourceType(res.getResourceType());
            row.setCreationDate(res.getCreationDate());
            row.setUpdateDate(res.getUpdateDate());
            row.setScheduled(false);
            row.setSelected(false);
            row.setHasSavedOptions(false);
            row.setWritable(this.repositoryServiceSecurityChecker.isEditable((Resource)res));
            row.setDeletable(this.repositoryServiceSecurityChecker.isRemovable((Resource)res));
            row.setAdministrable(this.objectPermissionService.isObjectAdministrable(null, (Object)res));
            List jobs = this.schedulingService.getScheduledJobs(this.exContext(context), res.getURIString());
            if (jobs.size() > 0) {
                row.setScheduled(true);
            } else {
                row.setScheduled(false);
            }
            String resourceType = res.getResourceType();
            if (resourceType.endsWith("AdhocReportUnit") || resourceType.endsWith("ReportUnit")) {
                row.setResourceUrl("flow.html?_flowId=viewReportFlow&reportUnit=" + res.getURIString() + "&standAlone=true&ParentFolderUri=" + res.getParentURI().substring(5));
            } else if (resourceType.endsWith("OlapUnit")) {
                row.setResourceUrl("olap/viewOlap.html?name=" + res.getURIString() + "&new=true&parentFlow=repositoryExplorerFlow" + "&ParentFolderUri=" + res.getParentURI().substring(5));
            } else if (resourceType.endsWith("ContentResource")) {
                row.setResourceUrl("fileview/fileview" + res.getURIString());
                row.setContentType(true);
            } else if (resourceType.endsWith("DashboardResource")) {
                row.setResourceUrl("flow.html?_flowId=dashboardRuntimeFlow&dashboardResource=" + res.getURIString());
            } else if (resourceType.endsWith("ReportOptions")) {
                row.setResourceUrl("flow.html?_flowId=viewReportFlow&reportOptionsURI=" + res.getURIString() + "&standAlone=true&ParentFolderUri=" + res.getParentURI().substring(5));
            }
            listOfRows.add(row);
        }
        listModel.setRows(listOfRows);
        listModel.setFirst(pageNumber > 0);
        listModel.setPrevious(pageNumber > 0);
        listModel.setNext(this.pagination * pageNumber + this.pagination < nResources);
        listModel.setLast(this.pagination * pageNumber + this.pagination < nResources);
        return listModel;
    }

    public Event updateResourceProperties(RequestContext context) {
        try {
            String labelProperty = URLDecoder.decode(context.getRequestParameters().get("label"), "UTF-8");
            String descProperty = URLDecoder.decode(context.getRequestParameters().get("desc"), "UTF-8");
            String idProperty = URLDecoder.decode(context.getRequestParameters().get("id"), "UTF-8");
            String folderUri = URLDecoder.decode(context.getRequestParameters().get("folderUri"), "UTF-8");
            String returnStatus = "OK";
            FilterCriteria criteria = FilterCriteria.createFilter();
            criteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)folderUri));
            List resources = this.repositoryService.loadClientResources(criteria);
            List folders = this.repositoryService.getSubFolders(this.exContext(context), folderUri);
            resources.addAll(folders);
            Resource matchingResource = null;
            for (int i = 0; i < resources.size(); ++i) {
                String label = ((Resource)resources.get(i)).getLabel();
                String id = ((Resource)resources.get(i)).getName();
                if (label.equalsIgnoreCase(labelProperty) && !id.equalsIgnoreCase(idProperty)) {
                    returnStatus = "DUPLICATE_LABEL_ERROR";
                    context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)returnStatus);
                    return this.success();
                }
                if (!id.equalsIgnoreCase(idProperty)) continue;
                matchingResource = (Resource)resources.get(i);
            }
            if (matchingResource == null) {
                context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)"ERROR:MISSING_RESOURCE");
                return this.success();
            }
            if (!labelProperty.equalsIgnoreCase(matchingResource.getLabel()) || !descProperty.equalsIgnoreCase(matchingResource.getDescription())) {
                matchingResource.setLabel(labelProperty);
                matchingResource.setDescription(descProperty);
                if (matchingResource.getResourceType().toLowerCase().contains("folder")) {
                    this.repositoryService.saveFolder(this.exContext(context), (Folder)matchingResource);
                } else {
                    this.repositoryService.saveResource(this.exContext(context), matchingResource);
                }
            }
            context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)returnStatus);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this.success();
    }

    public Event getResourceProperties(RequestContext context) {
        try {
            boolean isFolder = false;
            String resourceUri = URLDecoder.decode(context.getRequestParameters().get("resourceUri"), "UTF-8");
            Resource resource = null;
            try {
                resource = this.repositoryService.getResource(this.exContext(context), resourceUri);
            }
            catch (JSException e) {
                context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)"ERROR:PATH_NOT_VISIBLE_IN_ORGANIZATION_CONTEXT");
                return this.success();
            }
            if (resource == null) {
                resource = this.repositoryService.getFolder(this.exContext(context), resourceUri);
                isFolder = true;
            }
            if (resource == null) {
                context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)"ERROR:MISSING_RESOURCE");
                return this.success();
            }
            boolean isWritable = this.repositoryServiceSecurityChecker.isEditable(resource);
            boolean isDeletable = this.repositoryServiceSecurityChecker.isRemovable(resource);
            boolean isAdministrable = this.objectPermissionService.isObjectAdministrable(null, (Object)resource);
            StringBuffer sb = new StringBuffer();
            sb.append('{');
            if (resource.getDescription() == null) {
                resource.setDescription("");
            }
            SimpleDateFormat df = new SimpleDateFormat("MM-dd-yyyy HH:mm");
            sb.append("\"name\":\"").append(resource.getName()).append("\",").append("\"label\":\"").append(this.escape(resource.getLabel())).append("\",").append("\"date\":\"").append(df.format(resource.getCreationDate())).append("\",").append("\"updateDate\":\"").append(df.format(resource.getUpdateDate())).append("\",").append("\"writable\":\"").append(isWritable ? "true" : "false").append("\",").append("\"deletable\":\"").append(isDeletable ? "true" : "false").append("\",").append("\"administrable\":\"").append(isAdministrable ? "true" : "false").append("\",").append("\"description\":\"").append(this.escape(resource.getDescription().replace("\r", " ").replace("\n", " "))).append("\",");
            if (!isFolder) {
                sb.append("\"type\":\"").append(this.messageSource.getMessage("resource." + resource.getResourceType() + ".label", null, LocaleContextHolder.getLocale())).append("\"");
            } else {
                sb.append("\"type\":\"").append(this.messageSource.getMessage("label.folder", null, LocaleContextHolder.getLocale())).append("\"");
            }
            sb.append('}');
            context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)sb.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this.success();
    }

    public Event getBreadCrumb(RequestContext context) {
        try {
            String folderUri = URLDecoder.decode(context.getRequestParameters().get("FolderUri"), "UTF-8");
            int fromIndex = 1;
            StringBuffer sb = new StringBuffer();
            sb.append('{');
            Folder rootFolder = this.repositoryService.getFolder(null, "/");
            sb.append("\"/\":").append("\"" + rootFolder.getLabel() + "\"");
            if (folderUri.length() > 1) {
                while ((fromIndex = folderUri.indexOf(47, fromIndex)) != -1) {
                    String currentUri = folderUri.substring(0, folderUri.indexOf(47, fromIndex));
                    Folder folder = this.repositoryService.getFolder(this.exContext(context), currentUri);
                    if (folder == null) break;
                    String displayLabel = folder.getLabel();
                    ++fromIndex;
                    sb.append(",\"" + this.escape(currentUri) + "\":\"").append(this.escape(displayLabel)).append("\"");
                }
            }
            Folder res = null;
            try {
                res = this.repositoryService.getFolder(this.exContext(context), folderUri);
            }
            catch (Exception e) {
                // empty catch block
            }
            String displayLabel = res != null ? res.getLabel() : "";
            sb.append(",\"" + this.escape(folderUri) + "\":\"").append(this.escape(displayLabel)).append("\"");
            sb.append('}');
            context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)sb.toString());
        }
        catch (Exception e) {
            this.log.error((Object)"ERROR: getting folder failed", (Throwable)e);
        }
        return this.success();
    }

    public Event getUriDisplayLabelList(RequestContext context) {
        try {
            String uriList = URLDecoder.decode(context.getRequestParameters().get("uriList"), "UTF-8");
            String type = context.getRequestParameters().get("type");
            StringTokenizer str = new StringTokenizer(uriList, ",");
            StringBuffer sb = new StringBuffer();
            sb.append('{');
            int counter = 0;
            int fromIndex = 1;
            Folder rootFolder = this.repositoryService.getFolder(null, "/");
            while (str.hasMoreElements()) {
                String currentString = (String)str.nextElement();
                StringBuffer currentDisplayLabel = new StringBuffer("");
                if (currentString.equals("/")) {
                    sb.append("\"" + counter + "\":\"" + "/" + rootFolder.getLabel().replaceAll("<", "&lt;") + "\"");
                    ++counter;
                    continue;
                }
                currentDisplayLabel.append("/" + rootFolder.getLabel().replaceAll("<", "&lt;"));
                if (currentString.length() > 1) {
                    int lastIndex = currentString.lastIndexOf("/");
                    while ((fromIndex = currentString.indexOf(47, fromIndex)) != -1) {
                        String currentUri = currentString.substring(0, currentString.indexOf(47, fromIndex));
                        try {
                            currentDisplayLabel.append("/").append(this.repositoryService.getFolder(this.exContext(context), currentUri).getLabel().replaceAll("<", "&lt;"));
                        }
                        catch (Exception e) {
                            currentDisplayLabel.append("/").append(this.repositoryService.getResource(this.exContext(context), currentUri).getLabel().replaceAll("<", "&lt;"));
                        }
                        if (lastIndex == fromIndex) break;
                        ++fromIndex;
                    }
                    if (type.equals("resource") && counter > 0) {
                        currentDisplayLabel.append("/").append(this.repositoryService.getResource(this.exContext(context), currentString).getLabel().replaceAll("<", "&lt;"));
                    } else if (type.equals("folder") || type.equals("resource") && counter == 0) {
                        currentDisplayLabel.append("/").append(this.repositoryService.getFolder(this.exContext(context), currentString).getLabel().replaceAll("<", "&lt;"));
                    }
                    if (counter == 0) {
                        sb.append("\"" + counter + "\":\"" + currentDisplayLabel.toString() + "\"");
                    } else {
                        sb.append(",\"" + counter + "\":\"" + currentDisplayLabel.toString() + "\"");
                    }
                }
                ++counter;
                fromIndex = 1;
            }
            sb.append('}');
            context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)sb.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this.success();
    }

    public Event getNewFolderName(RequestContext context) {
        try {
            String folderUri = URLDecoder.decode(context.getRequestParameters().get("FolderUri"), "UTF-8");
            int largestNumber = 1;
            boolean newFolderExist = false;
            String sb = this.messageSource.getMessage("RM_CREATE_FOLDER_POP_UP_HEADER", null, LocaleContextHolder.getLocale());
            List repoFolderList = this.repositoryService.getSubFolders(null, folderUri);
            for (int i = 0; i < repoFolderList.size(); ++i) {
                String curFolderName = ((Folder)repoFolderList.get(i)).getLabel();
                if (curFolderName.equals(sb)) {
                    newFolderExist = true;
                    if (largestNumber != true) continue;
                    ++largestNumber;
                    continue;
                }
                if (!curFolderName.startsWith(sb)) continue;
                int startParenthsisIndex = curFolderName.indexOf(40);
                int endParenthsisIndex = curFolderName.indexOf(41);
                if (startParenthsisIndex == -1 || endParenthsisIndex == -1 || startParenthsisIndex >= endParenthsisIndex || startParenthsisIndex != sb.length() + 1) continue;
                int curNumber = -1;
                try {
                    curNumber = Integer.parseInt(curFolderName.substring(startParenthsisIndex + 1, endParenthsisIndex));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (curNumber == -1 || curNumber < largestNumber) continue;
                largestNumber = curNumber + 1;
            }
            if (largestNumber == 1 || !newFolderExist) {
                context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)sb);
            } else {
                context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)(sb + " (" + largestNumber + ")"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this.success();
    }

    public Event copyFolder(RequestContext context) {
        try {
            String sourceUri = URLDecoder.decode(context.getRequestParameters().get("sourceUri"), "UTF-8");
            String destUri = URLDecoder.decode(context.getRequestParameters().get("destUri"), "UTF-8");
            Folder destinationFolder = null;
            int lastIndex = sourceUri.lastIndexOf("/");
            if (lastIndex != -1) {
                destUri = destUri + "/" + sourceUri.substring(lastIndex + 1);
            }
            StringBuffer sb = new StringBuffer();
            sb.append('{');
            String sourceLabel = this.repositoryService.getFolder(null, sourceUri).getLabel();
            String trimDestUri = destUri.substring(0, destUri.lastIndexOf(47));
            if (this.doesObjectLabelExist(trimDestUri, sourceLabel)) {
                sb.append("\"status\":\"FAILED\"");
                sb.append('}');
                context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)sb.toString());
                return this.no();
            }
            try {
                destinationFolder = this.repositoryService.copyFolder(null, sourceUri, destUri);
            }
            catch (Exception e) {
                e.printStackTrace();
                sb.append("\"status\":\"FAILED\"");
                sb.append('}');
                context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)sb.toString());
                return this.no();
            }
            sb.append("\"status\":\"SUCCESS\",");
            sb.append("\"id\":\"" + destinationFolder.getURIString() + "\"");
            sb.append('}');
            context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)sb.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this.success();
    }

    public Event moveFolder(RequestContext context) {
        try {
            String sourceUri = URLDecoder.decode(context.getRequestParameters().get("sourceUri"), "UTF-8");
            String destUri = URLDecoder.decode(context.getRequestParameters().get("destUri"), "UTF-8");
            StringBuffer sb = new StringBuffer();
            sb.append('{');
            String sourceLabel = this.repositoryService.getFolder(null, sourceUri).getLabel();
            if (this.doesObjectLabelExist(destUri, sourceLabel)) {
                sb.append("\"status\":\"FAILED\"");
                sb.append('}');
                context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)sb.toString());
                return this.no();
            }
            try {
                this.repositoryService.moveFolder(null, sourceUri, destUri);
            }
            catch (Exception e) {
                e.printStackTrace();
                sb.append("\"status\":\"FAILED\"");
                sb.append('}');
                context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)sb.toString());
                return this.no();
            }
            sb.append("\"status\":\"SUCCESS\",");
            if ("/".equals(destUri)) {
                sb.append("\"id\":\"" + sourceUri.substring(sourceUri.lastIndexOf("/")) + "\"");
            } else {
                sb.append("\"id\":\"" + destUri + sourceUri.substring(sourceUri.lastIndexOf("/")) + "\"");
            }
            sb.append('}');
            context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)sb.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this.success();
    }

    public Event copyResource(RequestContext context) {
        try {
            String sourceUri = URLDecoder.decode(context.getRequestParameters().get("sourceUri"), "UTF-8");
            String destUri = URLDecoder.decode(context.getRequestParameters().get("destUri"), "UTF-8");
            StringBuffer sb = new StringBuffer();
            sb.append('{');
            StringTokenizer str = new StringTokenizer(sourceUri, ",");
            ArrayList<String> resourceURIs = new ArrayList<String>();
            while (str.hasMoreElements()) {
                String currentResource = (String)str.nextElement();
                String sourceLabel = this.repositoryService.getResource(null, currentResource).getLabel();
                if (this.doesObjectLabelExist(destUri, sourceLabel)) {
                    sb.append("\"status\":\"FAILED\"");
                    sb.append('}');
                    context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)sb.toString());
                    return this.no();
                }
                resourceURIs.add(currentResource);
            }
            try {
                this.repositoryService.copyResources(null, resourceURIs.toArray(new String[resourceURIs.size()]), destUri);
            }
            catch (Exception e) {
                this.log.error((Object)"Error copying resources", (Throwable)e);
                sb.append("\"status\":\"FAILED\"");
                sb.append('}');
                context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)sb.toString());
                return this.no();
            }
            sb.append("\"status\":\"SUCCESS\"");
            sb.append('}');
            context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)sb.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this.success();
    }

    public Event moveResource(RequestContext context) {
        try {
            String currentResource;
            String sourceUri = URLDecoder.decode(context.getRequestParameters().get("sourceUri"), "UTF-8");
            String destUri = URLDecoder.decode(context.getRequestParameters().get("destUri"), "UTF-8");
            StringTokenizer str = new StringTokenizer(sourceUri, ",");
            StringBuffer sb = new StringBuffer();
            sb.append('{');
            while (str.hasMoreElements()) {
                currentResource = (String)str.nextElement();
                String sourceLabel = this.repositoryService.getResource(null, currentResource).getLabel();
                if (!this.doesObjectLabelExist(destUri, sourceLabel)) continue;
                sb.append("\"status\":\"FAILED\"");
                sb.append('}');
                context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)sb.toString());
                return this.no();
            }
            str = new StringTokenizer(sourceUri, ",");
            while (str.hasMoreElements()) {
                currentResource = (String)str.nextElement();
                try {
                    this.repositoryService.moveResource(null, currentResource, destUri);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    sb.append("\"status\":\"FAILED\"");
                    sb.append('}');
                    context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)sb.toString());
                    return this.no();
                }
            }
            sb.append("\"status\":\"SUCCESS\"");
            sb.append('}');
            context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)sb.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this.success();
    }

    private boolean doesObjectLabelExist(String parentFolderUri, String objectLabel) {
        if (objectLabel == null) {
            objectLabel = "";
        }
        try {
            List repoFolderList = this.repositoryService.getSubFolders(null, parentFolderUri);
            FilterCriteria criteria = FilterCriteria.createFilter();
            criteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)parentFolderUri));
            List resources = this.repositoryService.loadResourcesList(null, criteria);
            repoFolderList.addAll(resources);
            for (int i = 0; i < repoFolderList.size(); ++i) {
                ResourceLookupImpl res;
                FolderImpl repoFolder;
                if (!(repoFolderList.get(i) instanceof FolderImpl ? objectLabel.equalsIgnoreCase((repoFolder = (FolderImpl)repoFolderList.get(i)).getLabel()) : repoFolderList.get(i) instanceof ResourceLookupImpl && objectLabel.equalsIgnoreCase((res = (ResourceLookupImpl)repoFolderList.get(i)).getLabel()))) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    protected String escape(String str) {
        return str == null ? null : str.replace("\"", "\\\"").replace("<", "&lt;").replace(">", "&gt;").replace("&", "&amp;");
    }

    public ExecutionContext exContext(RequestContext rContext) {
        return JasperServerUtil.getExecutionContext(rContext);
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public RepositorySecurityChecker getRepositoryServiceSecurityChecker() {
        return this.repositoryServiceSecurityChecker;
    }

    public void setRepositoryServiceSecurityChecker(RepositorySecurityChecker repositoryServiceSecurityChecker) {
        this.repositoryServiceSecurityChecker = repositoryServiceSecurityChecker;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public ReportSchedulingService getSchedulingService() {
        return this.schedulingService;
    }

    public void setSchedulingService(ReportSchedulingService schedulingService) {
        this.schedulingService = schedulingService;
    }

    public int getPagination() {
        return this.pagination;
    }

    public void setPagination(int pagination) {
        this.pagination = pagination;
    }

    public String getShowMoveCopyConfirmation() {
        return this.showMoveCopyConfirmation;
    }

    public void setShowMoveCopyConfirmation(String showMoveCopyConfirmation) {
        this.showMoveCopyConfirmation = showMoveCopyConfirmation;
    }

    public Event getConfirmationOption(RequestContext context) {
        context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)this.getShowMoveCopyConfirmation());
        return this.success();
    }

    public ObjectPermissionService getObjectPermissionService() {
        return this.objectPermissionService;
    }

    public void setObjectPermissionService(ObjectPermissionService objectPermissionService) {
        this.objectPermissionService = objectPermissionService;
    }

    public Event generateResourceName(RequestContext context) {
        ParameterMap parameters = context.getRequestParameters();
        String parentFolderUri = parameters.get("ParentFolderUri");
        String newId = parameters.get("resourceLabel").replaceAll(this.configuration.getResourceIdNotSupportedSymbols(), "_").toLowerCase();
        Resource resource = this.repositoryService.getResource(null, parentFolderUri + "/" + newId);
        if (resource != null) {
            int counter = 1;
            while (this.repositoryService.getResource(null, parentFolderUri + "/" + newId + "_" + counter) != null) {
                ++counter;
            }
            newId = newId + "_" + counter;
        }
        context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)("{\"newId\":\"" + newId + "\"}"));
        return this.success();
    }
}

