/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSDuplicateResourceException;
import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.CustomReportDataSourceServiceFactory;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.CustomDataSourceDefinition;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Query;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.BeanReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.CustomReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import com.jaspersoft.jasperserver.war.common.JasperServerConstImpl;
import com.jaspersoft.jasperserver.war.dto.QueryWrapper;
import com.jaspersoft.jasperserver.war.dto.ReportDataSourceWrapper;
import com.jaspersoft.jasperserver.war.model.impl.TypedTreeDataProvider;
import java.beans.PropertyEditor;
import java.util.List;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.DataBinder;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.web.multipart.support.ByteArrayMultipartFileEditor;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ScopeType;

public class EditQueryAction
extends FormAction {
    private static final String ATTRIBUTE_RESOURCE_ID_NOT_SUPPORTED_SYMBOLS = "resourceIdNotSupportedSymbols";
    private static final String DATA_SOURCE_PARENT_TYPE = "query";
    private static final String FORM_OBJECT_KEY = "query";
    private static final String PARENT_FOLDER_ATTR = "parentFolder";
    private static final String CURRENT_QUERY_ATTR = "currentQuery";
    private static final String IS_EDIT = "isEdit";
    private static final String DATASOURCE_OBJECT_KEY = "dataResource";
    private static final String DATASOURCE_TREE_DATA_PROVIDER = "dsTreeDataProvider";
    private RepositoryService repository;
    private JasperServerConstImpl constants = new JasperServerConstImpl();
    private TypedTreeDataProvider typedTreeDataProvider;
    private CustomReportDataSourceServiceFactory customDataSourceFactory;
    private String queryLanguagesRequestAttrName;
    private String[] queryLanguages;
    protected MessageSource messages;
    private ConfigurationBean configuration;

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public void setDataSourceTreeDataProvider(TypedTreeDataProvider typedTreeDataProvider) {
        this.typedTreeDataProvider = typedTreeDataProvider;
    }

    public void setCustomDataSourceFactory(CustomReportDataSourceServiceFactory customDataSourceFactory) {
        this.customDataSourceFactory = customDataSourceFactory;
    }

    protected void initBinder(RequestContext context, DataBinder binder) {
        binder.registerCustomEditor(byte[].class, (PropertyEditor)new ByteArrayMultipartFileEditor());
    }

    public EditQueryAction() {
        this.setFormObjectClass(QueryWrapper.class);
        this.setFormObjectName("query");
        this.setFormObjectScope(ScopeType.FLOW);
    }

    public void setMessages(MessageSource messages) {
        this.messages = messages;
    }

    public Object createFormObject(RequestContext context) {
        QueryWrapper wrapper;
        ExecutionContextImpl executionContext = new ExecutionContextImpl();
        String isEdit = (String)context.getFlowScope().get(IS_EDIT);
        if (isEdit == null) {
            isEdit = context.getRequestParameters().get(IS_EDIT);
            context.getFlowScope().put(IS_EDIT, (Object)isEdit);
        }
        if (isEdit != null) {
            Query query;
            String currentQuery = (String)context.getFlowScope().get(CURRENT_QUERY_ATTR);
            if (currentQuery == null) {
                currentQuery = context.getRequestParameters().get(CURRENT_QUERY_ATTR);
                context.getFlowScope().put(CURRENT_QUERY_ATTR, (Object)currentQuery);
            }
            if ((query = (Query)this.repository.getResource((ExecutionContext)executionContext, currentQuery)) == null) {
                throw new JSException("jsexception.could.not.find.resource.with.uri", new Object[]{currentQuery});
            }
            wrapper = new QueryWrapper(query);
            wrapper.setMode((byte)2);
        } else {
            Query query = (Query)this.repository.newResource((ExecutionContext)executionContext, Query.class);
            String parentFolder = (String)context.getFlowScope().get(PARENT_FOLDER_ATTR);
            if (parentFolder == null) {
                parentFolder = context.getRequestParameters().get("ParentFolderUri");
                context.getFlowScope().put(PARENT_FOLDER_ATTR, (Object)parentFolder);
            }
            if (parentFolder == null || parentFolder.trim().length() == 0) {
                parentFolder = "/";
            }
            query.setParentFolder(parentFolder);
            query.setLanguage(this.getQueryLanguages()[0]);
            wrapper = new QueryWrapper(query);
            wrapper.setMode((byte)1);
        }
        return wrapper;
    }

    public Event initAction(RequestContext context) throws Exception {
        MutableAttributeMap rs = context.getRequestScope();
        rs.put("query", this.getFormObject(context));
        context.getExternalContext().getSessionMap().put(DATASOURCE_TREE_DATA_PROVIDER, (Object)this.typedTreeDataProvider);
        context.getFlowScope().put(ATTRIBUTE_RESOURCE_ID_NOT_SUPPORTED_SYMBOLS, (Object)this.configuration.getResourceIdNotSupportedSymbols());
        return this.success();
    }

    public Event saveQuery(RequestContext context) throws Exception {
        QueryWrapper wrapper = (QueryWrapper)this.getFormObject(context);
        if (wrapper.isStandAloneMode()) {
            try {
                this.repository.saveResource(null, (Resource)wrapper.getQuery());
                if (!wrapper.isEditMode()) {
                    context.getExternalContext().getSessionMap().put("repositorySystemConfirm", (Object)this.messages.getMessage("resource.query.queryAdded", (Object[])new String[]{wrapper.getQuery().getName(), wrapper.getQuery().getParentFolder()}, LocaleContextHolder.getLocale()));
                }
                return this.yes();
            }
            catch (JSDuplicateResourceException e) {
                this.getFormErrors(context).rejectValue("query.name", "QueryValidator.error.duplicate");
                return this.error();
            }
        }
        return this.success();
    }

    public Event locateDataSource(RequestContext context) throws Exception {
        QueryWrapper queryWrapper = (QueryWrapper)this.getFormObject(context);
        ResourceReference dsRef = queryWrapper.getQuery().getDataSource();
        ReportDataSourceWrapper rdWrapper = new ReportDataSourceWrapper();
        rdWrapper.setParentType("query");
        rdWrapper.setMode((byte)3);
        if (dsRef == null) {
            EditQueryAction editQueryAction = this;
            rdWrapper.setSource(editQueryAction.constants.getFieldChoiceNone());
            rdWrapper.setReportDataSource(null);
        } else if (dsRef.isLocal()) {
            EditQueryAction editQueryAction = this;
            rdWrapper.setSource(editQueryAction.constants.getFieldChoiceLocal());
            ReportDataSource ds = (ReportDataSource)dsRef.getLocalResource();
            if (JdbcReportDataSource.class.isAssignableFrom(ds.getClass())) {
                EditQueryAction editQueryAction2 = this;
                rdWrapper.setType(editQueryAction2.constants.getJDBCDatasourceType());
            } else if (JndiJdbcReportDataSource.class.isAssignableFrom(ds.getClass())) {
                EditQueryAction editQueryAction3 = this;
                rdWrapper.setType(editQueryAction3.constants.getJNDIDatasourceType());
            } else if (BeanReportDataSource.class.isAssignableFrom(ds.getClass())) {
                EditQueryAction editQueryAction4 = this;
                rdWrapper.setType(editQueryAction4.constants.getBeanDatasourceType());
            } else if (ds instanceof CustomReportDataSource) {
                CustomReportDataSource cds = (CustomReportDataSource)ds;
                CustomDataSourceDefinition customDef = this.customDataSourceFactory.getDefinitionByServiceClass(cds.getServiceClass());
                rdWrapper.setType(customDef.getName());
            }
            rdWrapper.setMode((byte)4);
            rdWrapper.setReportDataSource(ds);
        } else {
            EditQueryAction editQueryAction = this;
            rdWrapper.setSource(editQueryAction.constants.getFieldChoiceRepo());
            rdWrapper.setSelectedUri(dsRef.getReferenceURI());
        }
        context.getFlowScope().put(DATASOURCE_OBJECT_KEY, (Object)rdWrapper);
        return this.success();
    }

    public Event saveDatasourceFromLocate(RequestContext context) throws Exception {
        ReportDataSourceWrapper resource = (ReportDataSourceWrapper)context.getFlowScope().get(DATASOURCE_OBJECT_KEY);
        QueryWrapper queryWrapper = (QueryWrapper)this.getFormObject(context);
        EditQueryAction editQueryAction = this;
        if (resource.getSource().equals(editQueryAction.constants.getFieldChoiceRepo())) {
            queryWrapper.getQuery().setDataSourceReference(resource.getSelectedUri());
        } else {
            EditQueryAction editQueryAction2 = this;
            if (resource.getSource().equals(editQueryAction2.constants.getFieldChoiceNone())) {
                queryWrapper.getQuery().setDataSource((ResourceReference)null);
            }
        }
        return this.success();
    }

    public Event saveDatasourceFromSubflow(RequestContext context) throws Exception {
        ReportDataSourceWrapper resource = (ReportDataSourceWrapper)context.getFlowScope().get(DATASOURCE_OBJECT_KEY);
        QueryWrapper queryWrapper = (QueryWrapper)this.getFormObject(context);
        queryWrapper.getQuery().setDataSource(resource.getReportDataSource());
        return this.success();
    }

    public Event prepareQueryTextEdit(RequestContext context) {
        context.getRequestScope().put(this.getQueryLanguagesRequestAttrName(), (Object)this.getQueryLanguages());
        return this.success();
    }

    public Event validateQuery(RequestContext context) throws Exception {
        Errors errors = this.getFormErrors(context);
        QueryWrapper wrapper = (QueryWrapper)this.getFormObject(context);
        this.getValidator().validate((Object)wrapper, errors);
        List fieldErrors = errors.getFieldErrors();
        if (fieldErrors != null && !fieldErrors.isEmpty()) {
            FieldError error = (FieldError)fieldErrors.get(0);
            String field = error.getField();
            if ("query.name".equals(field) || "query.label".equals(field) || "query.description".equals(field)) {
                return this.result("editQueryForm");
            }
            if ("query.sql".equals(field)) {
                return this.result("editQueryTextForm");
            }
        }
        return this.success();
    }

    public String[] getQueryLanguages() {
        return this.queryLanguages;
    }

    public void setQueryLanguages(String[] queryLanguages) {
        this.queryLanguages = queryLanguages;
    }

    public String getQueryLanguagesRequestAttrName() {
        return this.queryLanguagesRequestAttrName;
    }

    public void setQueryLanguagesRequestAttrName(String queryLanguagesRequestAttrName) {
        this.queryLanguagesRequestAttrName = queryLanguagesRequestAttrName;
    }

    public void setConfiguration(ConfigurationBean configuration) {
        this.configuration = configuration;
    }
}

