/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.mapping.loader;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Vector;
import org.castor.util.Messages;
import org.exolab.castor.types.Date;
import org.exolab.castor.types.Duration;
import org.exolab.castor.types.Time;

public class Types {
    private static final Vector _enums = new Vector();
    private static final Vector _convertible = new Vector();
    static TypeInfo[] _typeInfos = new TypeInfo[]{new TypeInfo("other", null, class$java$lang$Object == null ? (class$java$lang$Object = Types.class$("java.lang.Object")) : class$java$lang$Object, false, null), new TypeInfo("string", null, class$java$lang$String == null ? (class$java$lang$String = Types.class$("java.lang.String")) : class$java$lang$String, true, null), new TypeInfo("integer", Integer.TYPE, class$java$lang$Integer == null ? (class$java$lang$Integer = Types.class$("java.lang.Integer")) : class$java$lang$Integer, true, new Integer(0)), new TypeInfo("int", Integer.TYPE, Integer.TYPE, true, new Integer(0)), new TypeInfo("long", Long.TYPE, class$java$lang$Long == null ? (class$java$lang$Long = Types.class$("java.lang.Long")) : class$java$lang$Long, true, new Long(0L)), new TypeInfo("big-integer", null, class$java$math$BigInteger == null ? (class$java$math$BigInteger = Types.class$("java.math.BigInteger")) : class$java$math$BigInteger, true, BigInteger.valueOf(0L)), new TypeInfo("boolean", Boolean.TYPE, class$java$lang$Boolean == null ? (class$java$lang$Boolean = Types.class$("java.lang.Boolean")) : class$java$lang$Boolean, true, Boolean.FALSE), new TypeInfo("double", Double.TYPE, class$java$lang$Double == null ? (class$java$lang$Double = Types.class$("java.lang.Double")) : class$java$lang$Double, true, new Double(0.0)), new TypeInfo("float", Float.TYPE, class$java$lang$Float == null ? (class$java$lang$Float = Types.class$("java.lang.Float")) : class$java$lang$Float, true, new Float(0.0f)), new TypeInfo("big-decimal", null, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Types.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, true, new BigDecimal(0.0)), new TypeInfo("byte", Byte.TYPE, class$java$lang$Byte == null ? (class$java$lang$Byte = Types.class$("java.lang.Byte")) : class$java$lang$Byte, true, new Byte(0)), new TypeInfo("date", null, class$java$util$Date == null ? (class$java$util$Date = Types.class$("java.util.Date")) : class$java$util$Date, true, null), new TypeInfo("timestamp", null, class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = Types.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, true, null), new TypeInfo("sqldate", null, class$java$sql$Date == null ? (class$java$sql$Date = Types.class$("java.sql.Date")) : class$java$sql$Date, true, null), new TypeInfo("sqltime", null, class$java$sql$Time == null ? (class$java$sql$Time = Types.class$("java.sql.Time")) : class$java$sql$Time, true, null), new TypeInfo("short", Short.TYPE, class$java$lang$Short == null ? (class$java$lang$Short = Types.class$("java.lang.Short")) : class$java$lang$Short, true, new Short(0)), new TypeInfo("char", Character.TYPE, class$java$lang$Character == null ? (class$java$lang$Character = Types.class$("java.lang.Character")) : class$java$lang$Character, true, new Character('\u0000')), new TypeInfo("bytes", null, array$B == null ? (array$B = Types.class$("[B")) : array$B, false, null), new TypeInfo("chars", null, array$C == null ? (array$C = Types.class$("[C")) : array$C, false, null), new TypeInfo("strings", null, array$Ljava$lang$String == null ? (array$Ljava$lang$String = Types.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, false, null), new TypeInfo("locale", null, class$java$util$Locale == null ? (class$java$util$Locale = Types.class$("java.util.Locale")) : class$java$util$Locale, true, null), new TypeInfo("stream", null, class$java$io$InputStream == null ? (class$java$io$InputStream = Types.class$("java.io.InputStream")) : class$java$io$InputStream, true, null), new TypeInfo("clob", null, Types.getClobClass(), true, null), new TypeInfo("serializable", null, class$java$io$Serializable == null ? (class$java$io$Serializable = Types.class$("java.io.Serializable")) : class$java$io$Serializable, false, null), new TypeInfo("[Lbyte;", null, array$B == null ? (array$B = Types.class$("[B")) : array$B, false, null), new TypeInfo("[Lchar;", null, array$C == null ? (array$C = Types.class$("[C")) : array$C, false, null), new TypeInfo("[Ldouble;", null, array$D == null ? (array$D = Types.class$("[D")) : array$D, false, null), new TypeInfo("[Lfloat;", null, array$F == null ? (array$F = Types.class$("[F")) : array$F, false, null), new TypeInfo("[Lint;", null, array$I == null ? (array$I = Types.class$("[I")) : array$I, false, null), new TypeInfo("[Llong;", null, array$J == null ? (array$J = Types.class$("[J")) : array$J, false, null), new TypeInfo("[Lshort;", null, array$I == null ? (array$I = Types.class$("[I")) : array$I, false, null), new TypeInfo("[Lboolean;", null, array$I == null ? (array$I = Types.class$("[I")) : array$I, false, null), new TypeInfo("duration", null, class$org$exolab$castor$types$Duration == null ? (class$org$exolab$castor$types$Duration = Types.class$("org.exolab.castor.types.Duration")) : class$org$exolab$castor$types$Duration, false, new Duration(0L)), new TypeInfo("xml-date", null, class$org$exolab$castor$types$Date == null ? (class$org$exolab$castor$types$Date = Types.class$("org.exolab.castor.types.Date")) : class$org$exolab$castor$types$Date, false, new Date(0L)), new TypeInfo("xml-time", null, class$org$exolab$castor$types$Time == null ? (class$org$exolab$castor$types$Time = Types.class$("org.exolab.castor.types.Time")) : class$org$exolab$castor$types$Time, false, new Time(0L))};
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$lang$Cloneable;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class array$C;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$util$Locale;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class array$D;
    static /* synthetic */ Class array$F;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$J;
    static /* synthetic */ Class class$org$exolab$castor$types$Duration;
    static /* synthetic */ Class class$org$exolab$castor$types$Date;
    static /* synthetic */ Class class$org$exolab$castor$types$Time;

    public static Class typeFromName(ClassLoader loader, String typeName) throws ClassNotFoundException {
        for (int i = 0; i < _typeInfos.length; ++i) {
            if (!typeName.equals(Types._typeInfos[i].shortName)) continue;
            return Types._typeInfos[i].primitive != null ? Types._typeInfos[i].primitive : Types._typeInfos[i].javaType;
        }
        if (loader != null) {
            Class<?> aClass = loader.loadClass(typeName);
            return aClass;
        }
        return Class.forName(typeName);
    }

    public static Object getDefault(Class type) {
        for (int i = 0; i < _typeInfos.length; ++i) {
            if (Types._typeInfos[i].primitive != type && Types._typeInfos[i].javaType != type) continue;
            return Types._typeInfos[i].defValue;
        }
        return null;
    }

    public static Class typeFromPrimitive(Class type) {
        if (type != null && type.isArray() && !type.getComponentType().isPrimitive()) {
            return Types.typeFromPrimitive(type.getComponentType());
        }
        for (int i = 0; i < _typeInfos.length; ++i) {
            if (Types._typeInfos[i].primitive != type) continue;
            return Types._typeInfos[i].javaType;
        }
        return type;
    }

    public static boolean isSimpleType(Class type) {
        for (int i = 0; i < _typeInfos.length; ++i) {
            if (Types._typeInfos[i].javaType != type && Types._typeInfos[i].primitive != type) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimitiveType(Class type) {
        for (int i = 0; i < _typeInfos.length; ++i) {
            if (Types._typeInfos[i].primitive != type && (Types._typeInfos[i].javaType != type || Types._typeInfos[i].primitive == null)) continue;
            return true;
        }
        return false;
    }

    public static void addEnumType(Class type) {
        _enums.add(type);
    }

    public static boolean isEnumType(Class type) {
        return _enums.contains(type);
    }

    public static void addConvertibleType(Class type) {
        _convertible.add(type);
    }

    public static boolean isConvertibleType(Class type) {
        return _convertible.contains(type);
    }

    public static Object newInstance(Class type) throws IllegalStateException {
        try {
            return type.newInstance();
        }
        catch (IllegalAccessException except) {
            throw new IllegalStateException(Messages.format("mapping.schemaNotConstructable", type.getName(), except.getMessage()));
        }
        catch (InstantiationException except) {
            throw new IllegalStateException(Messages.format("mapping.schemaNotConstructable", type.getName(), except.getMessage()));
        }
    }

    public static Object newInstance(Class type, Object[] args) throws IllegalStateException {
        if (args == null || args.length == 0) {
            return Types.newInstance(type);
        }
        try {
            Constructor cons = Types.findConstructor(type, args);
            return cons.newInstance(args);
        }
        catch (NoSuchMethodException except) {
            throw new IllegalStateException(Messages.format("mapping.constructorNotFound", type.getName(), except.getMessage()));
        }
        catch (InvocationTargetException except) {
            throw new IllegalStateException(Messages.format("mapping.schemaNotConstructable", type.getName(), except.getMessage()));
        }
        catch (IllegalAccessException except) {
            throw new IllegalStateException(Messages.format("mapping.schemaNotConstructable", type.getName(), except.getMessage()));
        }
        catch (InstantiationException except) {
            throw new IllegalStateException(Messages.format("mapping.schemaNotConstructable", type.getName(), except.getMessage()));
        }
    }

    public static boolean isConstructable(Class type) {
        return Types.isConstructable(type, false);
    }

    public static boolean isConstructable(Class type, boolean allowAbstractOrInterface) {
        try {
            if ((type.getModifiers() & 1) == 0) {
                return false;
            }
            if (!allowAbstractOrInterface && (type.getModifiers() & 0x600) != 0) {
                return false;
            }
            if ((type.getConstructor(new Class[0]).getModifiers() & 1) != 0) {
                return true;
            }
        }
        catch (NoSuchMethodException except) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isSerializable(Class type) {
        return (class$java$io$Serializable == null ? (class$java$io$Serializable = Types.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(type);
    }

    public static boolean isImmutable(Class type) {
        for (int i = 0; i < _typeInfos.length; ++i) {
            if (Types._typeInfos[i].javaType != type && Types._typeInfos[i].primitive != type) continue;
            return Types._typeInfos[i].immutable;
        }
        return false;
    }

    public static boolean isCloneable(Class type) {
        return (class$java$lang$Cloneable == null ? (class$java$lang$Cloneable = Types.class$("java.lang.Cloneable")) : class$java$lang$Cloneable).isAssignableFrom(type);
    }

    private static Constructor findConstructor(Class type, Object[] args) throws NoSuchMethodException {
        Constructor<?>[] constructors = type.getConstructors();
        Constructor<?> cons = null;
        int rank = 0;
        for (int c = 0; c < constructors.length; ++c) {
            Class<?>[] paramTypes = constructors[c].getParameterTypes();
            if (paramTypes.length != args.length) continue;
            int tmpRank = 0;
            boolean matches = true;
            for (int p = 0; p < paramTypes.length; ++p) {
                Class pType;
                if (args[p] == null) {
                    if (!paramTypes[p].isPrimitive()) continue;
                    matches = false;
                    break;
                }
                if (paramTypes[p] == args[p].getClass()) {
                    ++tmpRank;
                    continue;
                }
                if (paramTypes[p].isAssignableFrom(args[p].getClass()) || paramTypes[p].isPrimitive() && (pType = Types.typeFromPrimitive(paramTypes[p])).isAssignableFrom(args[p].getClass())) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            if (tmpRank == paramTypes.length) {
                return constructors[c];
            }
            if (cons != null && tmpRank <= rank) continue;
            cons = constructors[c];
            rank = tmpRank;
        }
        if (cons == null) {
            throw new NoSuchMethodException();
        }
        return cons;
    }

    private static final Class getClobClass() {
        Class<?> type = null;
        try {
            type = Class.forName("java.sql.Clob");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return type;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class TypeInfo {
        final String shortName;
        final Class primitive;
        final Class javaType;
        final boolean immutable;
        final Object defValue;

        TypeInfo(String shortName, Class primitive, Class javaType, boolean immutable, Object defValue) {
            this.shortName = shortName;
            this.primitive = primitive;
            this.javaType = javaType;
            this.immutable = immutable;
            this.defValue = defValue;
        }
    }
}

