/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.session;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.session.SessionMappingStorage;

public final class HashMapBackedSessionMappingStorage
implements SessionMappingStorage {
    private final Map MANAGED_SESSIONS = new HashMap();
    private final Map ID_TO_SESSION_KEY_MAPPING = new HashMap();

    public synchronized void addSessionById(String mappingId, HttpSession session) {
        this.ID_TO_SESSION_KEY_MAPPING.put(session.getId(), mappingId);
        this.MANAGED_SESSIONS.put(mappingId, session);
    }

    public synchronized void removeBySessionById(String sessionId) {
        String key = (String)this.ID_TO_SESSION_KEY_MAPPING.get(sessionId);
        this.MANAGED_SESSIONS.remove(key);
        this.ID_TO_SESSION_KEY_MAPPING.remove(sessionId);
    }

    public synchronized HttpSession removeSessionByMappingId(String mappingId) {
        HttpSession session = (HttpSession)this.MANAGED_SESSIONS.get(mappingId);
        if (session != null) {
            this.removeBySessionById(session.getId());
        }
        return session;
    }
}

