/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.search.action;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.search.action.BaseSearchAction;
import com.jaspersoft.jasperserver.search.service.FolderService;
import com.jaspersoft.jasperserver.search.util.JSONConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.Assert;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class FolderAction
extends BaseSearchAction {
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    public static final String AJAX_RESPONSE_MODEL = "ajaxResponseModel";
    private FolderService folderService;

    public Event init(RequestContext context) throws Exception {
        Assert.notNull((Object)this.folderService);
        return this.success();
    }

    public Event create(RequestContext context) throws Exception {
        JSONObject response;
        JSONConverter jsonConverter = this.getConverter(context);
        try {
            String destinationFolderUri = this.getParameter(context, "destFolderUri");
            Folder folder = jsonConverter.jsonToFolder(this.getParameter(context, "folder"));
            Folder newFolder = this.folderService.create(destinationFolderUri, folder.getLabel(), folder.getDescription());
            response = jsonConverter.createJSONResponse(jsonConverter.folderToJson(newFolder));
        }
        catch (Exception e) {
            response = jsonConverter.createErrorJSONResponse(this.getErrorMessage(e));
            this.log.debug((Object)"SEARCH_ERROR: Can't create folder.", (Throwable)e);
        }
        context.getRequestScope().put(AJAX_RESPONSE_MODEL, (Object)response.toString());
        return this.success();
    }

    public Event update(RequestContext context) throws Exception {
        JSONObject response;
        JSONConverter jsonConverter = this.getConverter(context);
        try {
            Folder folder = jsonConverter.jsonToFolder(this.getParameter(context, "folder"));
            Folder newFolder = this.folderService.update(folder.getURIString(), folder.getLabel(), folder.getDescription());
            response = jsonConverter.createJSONResponse(jsonConverter.folderToJson(newFolder));
        }
        catch (Exception e) {
            response = jsonConverter.createErrorJSONResponse(this.getErrorMessage(e));
            this.log.debug((Object)"SEARCH_ERROR: Can't update folder.", (Throwable)e);
        }
        context.getRequestScope().put(AJAX_RESPONSE_MODEL, (Object)response.toString());
        return this.success();
    }

    public Event delete(RequestContext context) throws Exception {
        JSONObject response;
        JSONConverter jsonConverter = this.getConverter(context);
        try {
            String folderUri = this.getParameter(context, "sourceFolderUri");
            this.folderService.delete(folderUri);
            response = jsonConverter.createOKJSONResponse("Folder copied successfully.");
        }
        catch (JSExceptionWrapper e) {
            response = jsonConverter.createErrorJSONResponse(this.messages.getMessage("jsp.flowRemoveError.errorMsg3", null, LocaleContextHolder.getLocale()));
            this.log.debug((Object)"SEARCH_ERROR: Can't delete folder.", (Throwable)e);
        }
        catch (Exception e) {
            response = jsonConverter.createErrorJSONResponse(this.getErrorMessage(e));
            this.log.debug((Object)"SEARCH_ERROR: Can't delete folder.", (Throwable)e);
        }
        context.getRequestScope().put(AJAX_RESPONSE_MODEL, (Object)response.toString());
        return this.success();
    }

    public Event copy(RequestContext context) throws Exception {
        JSONObject response;
        JSONConverter jsonConverter = this.getConverter(context);
        try {
            String folderUri = this.getParameter(context, "sourceFolderUri");
            String destinationFolderUri = this.getParameter(context, "destFolderUri");
            this.folderService.copy(folderUri, destinationFolderUri);
            response = jsonConverter.createOKJSONResponse("Folder copied successfully.");
        }
        catch (Exception e) {
            response = jsonConverter.createErrorJSONResponse(this.getErrorMessage(e));
            this.log.debug((Object)"SEARCH_ERROR: Can't copy folder.", (Throwable)e);
        }
        context.getRequestScope().put(AJAX_RESPONSE_MODEL, (Object)response.toString());
        return this.success();
    }

    public Event move(RequestContext context) throws Exception {
        JSONObject response;
        JSONConverter jsonConverter = this.getConverter(context);
        try {
            String folderUri = this.getParameter(context, "sourceFolderUri");
            String destinationFolderUri = this.getParameter(context, "destFolderUri");
            this.folderService.move(folderUri, destinationFolderUri);
            response = jsonConverter.createOKJSONResponse("Folder moved successfully.");
        }
        catch (Exception e) {
            response = jsonConverter.createErrorJSONResponse(this.getErrorMessage(e));
            this.log.debug((Object)"SEARCH_ERROR: Can't move folder.", (Throwable)e);
        }
        context.getRequestScope().put(AJAX_RESPONSE_MODEL, (Object)response.toString());
        return this.success();
    }

    public void setFolderService(FolderService folderService) {
        this.folderService = folderService;
    }
}

