/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng.dialect;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.hibernate.exception.SQLExceptionConverter;

public abstract class ResultSetIterator
implements Iterator {
    private ResultSet rs;
    protected boolean current = false;
    protected boolean endOfRows = false;
    private SQLExceptionConverter sec;

    protected ResultSetIterator(ResultSet resultset, SQLExceptionConverter sec) {
        this.rs = resultset;
        this.sec = sec;
    }

    public boolean hasNext() {
        try {
            this.advance();
            return !this.endOfRows;
        }
        catch (SQLException e) {
            this.handleSQLException(e);
            return false;
        }
    }

    public Object next() {
        try {
            this.advance();
            if (this.endOfRows) {
                throw new NoSuchElementException();
            }
            this.current = false;
            return this.convertRow(this.rs);
        }
        catch (SQLException e) {
            this.handleSQLException(e);
            throw new NoSuchElementException("excpetion occurred " + e);
        }
    }

    protected abstract Throwable handleSQLException(SQLException var1);

    protected abstract Object convertRow(ResultSet var1) throws SQLException;

    public void remove() {
        throw new UnsupportedOperationException("remove() not possible on ResultSet");
    }

    protected void advance() throws SQLException {
        if (!this.current && !this.endOfRows) {
            if (this.rs.next()) {
                this.current = true;
                this.endOfRows = false;
            } else {
                this.current = false;
                this.endOfRows = true;
            }
        }
    }

    public void close() {
        try {
            this.rs.close();
        }
        catch (SQLException e) {
            this.handleSQLException(e);
        }
    }
}

