/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.client;

import com.jaspersoft.jasperserver.api.common.domain.ValidationResult;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.ResourceImpl;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ReportUnitImpl
extends ResourceImpl
implements ReportUnit {
    private ResourceReference dataSource = null;
    private ResourceReference query = null;
    private List inputControls;
    private ResourceReference mainReport = null;
    private List resources = new ArrayList();
    private String inputControlRenderingView;
    private String reportRenderingView;
    private boolean alwaysPromptControls;
    private byte controlsLayout = 1;

    public ReportUnitImpl() {
        this.inputControls = new ArrayList();
    }

    public ResourceReference getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(ResourceReference dataSource) {
        this.dataSource = dataSource;
    }

    public void setDataSource(ReportDataSource dataSource) {
        this.setDataSource(new ResourceReference(dataSource));
    }

    public void setDataSourceReference(String referenceURI) {
        this.setDataSource(new ResourceReference(referenceURI));
    }

    public ResourceReference getQuery() {
        return this.query;
    }

    public void setQuery(ResourceReference query) {
        this.query = query;
    }

    public List getInputControls() {
        return this.inputControls;
    }

    public ResourceReference getMainReport() {
        return this.mainReport;
    }

    public InputControl getInputControl(String name) {
        ListIterator it = this.inputControlsLocalNameLocator(name).positionBefore();
        InputControl inputControl = it.hasNext() ? (InputControl)((ResourceReference)it.next()).getLocalResource() : null;
        return inputControl;
    }

    public void setMainReport(ResourceReference mainReport) {
        this.mainReport = mainReport;
    }

    public void setMainReport(FileResource report) {
        this.setMainReport(new ResourceReference(report));
    }

    public void setMainReportReference(String referenceURI) {
        this.setMainReport(new ResourceReference(referenceURI));
    }

    public List getResources() {
        return this.resources;
    }

    public FileResource getResource(String name) {
        FileResource resource = null;
        if (this.resources != null && !this.resources.isEmpty()) {
            for (FileResource res : this.resources) {
                if (!res.getName().equals(name)) continue;
                resource = res;
                break;
            }
        }
        return resource;
    }

    public void setResources(List resources) {
        this.resources = resources;
    }

    public String getInputControlRenderingView() {
        return this.inputControlRenderingView;
    }

    public String getReportRenderingView() {
        return this.reportRenderingView;
    }

    public void setInputControlRenderingView(String viewName) {
        this.inputControlRenderingView = viewName;
    }

    public void setReportRenderingView(String viewName) {
        this.reportRenderingView = viewName;
    }

    public boolean isAlwaysPromptControls() {
        return this.alwaysPromptControls;
    }

    public void setAlwaysPromptControls(boolean alwaysPromptControls) {
        this.alwaysPromptControls = alwaysPromptControls;
    }

    public byte getControlsLayout() {
        return this.controlsLayout;
    }

    public void setControlsLayout(byte controlsLayout) {
        this.controlsLayout = controlsLayout;
    }

    public void addResource(ResourceReference resourceReference) {
        this.resources.add(resourceReference);
    }

    public void addResourceReference(String referenceURI) {
        this.addResource(new ResourceReference(referenceURI));
    }

    public void addResource(FileResource resource) {
        this.addResource(new ResourceReference(resource));
    }

    public ResourceReference removeResource(int index) {
        return (ResourceReference)this.resources.remove(index);
    }

    public FileResource removeResourceLocal(String name) {
        FileResource removed = null;
        Iterator it = this.resources.iterator();
        while (it.hasNext()) {
            FileResource resource;
            ResourceReference resourceRef = (ResourceReference)it.next();
            if (!resourceRef.isLocal() || !(resource = (FileResource)resourceRef.getLocalResource()).getName().equals(name)) continue;
            it.remove();
            removed = resource;
            break;
        }
        return removed;
    }

    public boolean removeResourceReference(String referenceURI) {
        boolean removed = false;
        Iterator it = this.resources.iterator();
        while (it.hasNext()) {
            ResourceReference resourceRef = (ResourceReference)it.next();
            if (resourceRef.isLocal() || !resourceRef.getReferenceURI().equals(referenceURI)) continue;
            it.remove();
            removed = true;
            break;
        }
        return removed;
    }

    public ValidationResult validate() {
        return null;
    }

    public void addInputControl(ResourceReference inputControlReference) {
        this.inputControls.add(inputControlReference);
    }

    public void addInputControlReference(String referenceURI) {
        this.addInputControl(new ResourceReference(referenceURI));
    }

    public void setInputControls(List inputControls) {
        this.inputControls = inputControls;
    }

    public void addInputControl(InputControl inputControl) {
        this.addInputControl(new ResourceReference(inputControl));
    }

    public ResourceReference removeInputControl(int index) {
        return (ResourceReference)this.inputControls.remove(index);
    }

    public InputControl removeInputControlLocal(String name) {
        InputControl removed;
        ListIterator it = this.inputControlsLocalNameLocator(name).positionBefore();
        if (it.hasNext()) {
            removed = (InputControl)((ResourceReference)it.next()).getLocalResource();
            it.remove();
        } else {
            removed = null;
        }
        return removed;
    }

    public boolean removeInputControlReference(String referenceURI) {
        ListIterator it = this.inputControlsReferenceLocator(referenceURI).positionBefore();
        boolean remove = it.hasNext();
        if (remove) {
            it.remove();
        }
        return remove;
    }

    protected ResourceListLocalNameLocator inputControlsLocalNameLocator(String name) {
        return new ResourceListLocalNameLocator(this.inputControls, name);
    }

    protected ResourceListReferenceLocator inputControlsReferenceLocator(String referenceURI) {
        return new ResourceListReferenceLocator(this.inputControls, referenceURI);
    }

    public void replaceInputControlLocal(String name, ResourceReference inputControlReference) {
        this.replaceInputControl(this.inputControlsLocalNameLocator(name), inputControlReference);
    }

    public void replaceInputControlReference(String referenceURI, ResourceReference inputControlReference) {
        this.replaceInputControl(this.inputControlsReferenceLocator(referenceURI), inputControlReference);
    }

    public void replaceInputControlLocal(String name, String newReferenceURI) {
        this.replaceInputControl(this.inputControlsLocalNameLocator(name), new ResourceReference(newReferenceURI));
    }

    public void replaceInputControlLocal(String name, InputControl inputControl) {
        this.replaceInputControl(this.inputControlsLocalNameLocator(name), new ResourceReference(inputControl));
    }

    public void replaceInputControlReference(String referenceURI, String newReferenceURI) {
        this.replaceInputControl(this.inputControlsReferenceLocator(referenceURI), new ResourceReference(newReferenceURI));
    }

    public void replaceInputControlReference(String referenceURI, InputControl inputControl) {
        this.replaceInputControl(this.inputControlsReferenceLocator(referenceURI), new ResourceReference(inputControl));
    }

    protected void replaceInputControl(ResourceListLocator locator, ResourceReference inputControlRef) {
        ListIterator it = locator.positionBefore();
        if (it.hasNext()) {
            it.next();
            it.set(inputControlRef);
        } else {
            it.add(inputControlRef);
        }
    }

    public FileResource getResourceLocal(String name) {
        FileResource resource = null;
        if (this.resources != null && !this.resources.isEmpty()) {
            for (ResourceReference resourceRef : this.resources) {
                FileResource res;
                if (!resourceRef.isLocal() || !(res = (FileResource)resourceRef.getLocalResource()).getName().equals(name)) continue;
                resource = res;
                break;
            }
        }
        return resource;
    }

    protected Class getImplementingItf() {
        return ReportUnit.class;
    }

    protected static class ResourceListLocalNameLocator
    extends ResourceListLocator {
        private final String localName;

        public ResourceListLocalNameLocator(List resources, String localName) {
            super(resources);
            this.localName = localName;
        }

        protected boolean matches(ResourceReference ref) {
            return ref.isLocal() && ref.getLocalResource().getName().equals(this.localName);
        }
    }

    protected static class ResourceListReferenceLocator
    extends ResourceListLocator {
        private final String referenceURI;

        public ResourceListReferenceLocator(List resources, String referenceURI) {
            super(resources);
            this.referenceURI = referenceURI;
        }

        protected boolean matches(ResourceReference ref) {
            return !ref.isLocal() && ref.getReferenceURI().equals(this.referenceURI);
        }
    }

    protected static abstract class ResourceListLocator {
        private final List resources;

        public ResourceListLocator(List resources) {
            this.resources = resources;
        }

        public ListIterator positionBefore() {
            ListIterator it = this.resources.listIterator();
            while (it.hasNext()) {
                ResourceReference ref = (ResourceReference)it.next();
                if (!this.matches(ref)) continue;
                it.previous();
                break;
            }
            return it;
        }

        protected abstract boolean matches(ResourceReference var1);
    }
}

