/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.sheet;

import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.chart.MeterInterval;
import it.businesslogic.ireport.gui.JRTextExpressionArea;
import it.businesslogic.ireport.gui.sheet.ColorSelectorPanel;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;

public class MeterIntervalDialog
extends JDialog {
    private MeterInterval meterInterval = null;
    private int dialogResult = 2;
    private ColorSelectorPanel colorSelectorPanel;
    private JButton jButtonCancel;
    private JButton jButtonDefaultColor;
    private JButton jButtonOK;
    private JLabel jLabelAlpha;
    private JLabel jLabelColor;
    private JLabel jLabelLabel;
    private JLabel jLabelRangeHigh;
    private JLabel jLabelRangeLow;
    private JPanel jPanel1;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JRTextExpressionArea jRTextExpressionHigh;
    private JRTextExpressionArea jRTextExpressionLow;
    private JSeparator jSeparator1;
    private JSpinner jSpinnerAlpha;
    private JTextField jTextFieldLabel;
    public static final int COMPONENT_NONE = 0;
    public static final int COMPONENT_LOW_EXPRESSION = 1;
    public static final int COMPONENT_HIGH_EXPRESSION = 2;

    public MeterIntervalDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.applyI18n();
        this.setSize(500, 500);
        Misc.centerFrame(this);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                MeterIntervalDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.jSpinnerAlpha.setModel(new SpinnerNumberModel(1.0, 0.0, 1.0, 0.01));
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    public void setSubDataset(SubDataset sds) {
        this.jRTextExpressionHigh.setSubDataset(sds);
        this.jRTextExpressionLow.setSubDataset(sds);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabelLabel = new JLabel();
        this.jTextFieldLabel = new JTextField();
        this.jLabelColor = new JLabel();
        this.colorSelectorPanel = new ColorSelectorPanel();
        this.jButtonDefaultColor = new JButton();
        this.jLabelAlpha = new JLabel();
        this.jSpinnerAlpha = new JSpinner();
        this.jLabelRangeLow = new JLabel();
        this.jRTextExpressionLow = new JRTextExpressionArea();
        this.jLabelRangeHigh = new JLabel();
        this.jRTextExpressionHigh = new JRTextExpressionArea();
        this.jSeparator1 = new JSeparator();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setTitle("Time series");
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setPreferredSize(new Dimension(400, 250));
        this.jLabelLabel.setText("Label");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 4);
        this.jPanel1.add((Component)this.jLabelLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.jTextFieldLabel, gridBagConstraints);
        this.jLabelColor.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 4);
        this.jPanel1.add((Component)this.jLabelColor, gridBagConstraints);
        this.colorSelectorPanel.setBorder(new LineBorder(new Color(102, 102, 102), 1, true));
        this.colorSelectorPanel.setMinimumSize(new Dimension(50, 10));
        this.colorSelectorPanel.setPreferredSize(new Dimension(130, 22));
        this.colorSelectorPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MeterIntervalDialog.this.colorSelectorPanelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.colorSelectorPanel, gridBagConstraints);
        this.jButtonDefaultColor.setText("Use default color");
        this.jButtonDefaultColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MeterIntervalDialog.this.jButtonDefaultColorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel1.add((Component)this.jButtonDefaultColor, gridBagConstraints);
        this.jLabelAlpha.setText("Alpha");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 4);
        this.jPanel1.add((Component)this.jLabelAlpha, gridBagConstraints);
        this.jSpinnerAlpha.setMinimumSize(new Dimension(100, 18));
        this.jSpinnerAlpha.setPreferredSize(new Dimension(130, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.jSpinnerAlpha, gridBagConstraints);
        this.jLabelRangeLow.setText("Data range low expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabelRangeLow, gridBagConstraints);
        this.jRTextExpressionLow.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionLow.setElectricScroll(0);
        this.jRTextExpressionLow.setMinimumSize(new Dimension(10, 10));
        this.jRTextExpressionLow.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jRTextExpressionLow, gridBagConstraints);
        this.jLabelRangeHigh.setText("Data range high expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabelRangeHigh, gridBagConstraints);
        this.jRTextExpressionHigh.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionHigh.setElectricScroll(0);
        this.jRTextExpressionHigh.setMinimumSize(new Dimension(10, 10));
        this.jRTextExpressionHigh.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jRTextExpressionHigh, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel6.add((Component)this.jPanel7, gridBagConstraints);
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MeterIntervalDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.jButtonOK, gridBagConstraints);
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MeterIntervalDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.jPanel6.add((Component)this.jButtonCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel6, gridBagConstraints);
        this.pack();
    }

    private void jButtonDefaultColorActionPerformed(ActionEvent evt) {
        this.colorSelectorPanel.setValue(null);
    }

    private void colorSelectorPanelActionPerformed(ActionEvent evt) {
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        MeterInterval tmpmi = this.getMeterInterval();
        if (tmpmi == null) {
            tmpmi = new MeterInterval();
        }
        tmpmi.setLabel(this.jTextFieldLabel.getText());
        tmpmi.setColor(ColorSelectorPanel.parseColorString("" + this.colorSelectorPanel.getValue()));
        tmpmi.setAlpha(((SpinnerNumberModel)this.jSpinnerAlpha.getModel()).getNumber().doubleValue());
        tmpmi.getDataRange().setLowExpression(this.jRTextExpressionLow.getText());
        tmpmi.getDataRange().setHighExpression(this.jRTextExpressionHigh.getText());
        this.setMeterInterval(tmpmi);
        this.setDialogResult(0);
        this.setVisible(false);
        this.dispose();
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void applyI18n() {
        this.jButtonDefaultColor.setText(I18n.getString("meterIntervalDialog.buttonDefaultColor", "Use default color"));
        this.jButtonOK.setText(I18n.getString("ok", "Ok"));
        this.jButtonCancel.setText(I18n.getString("cancel", "Cancel"));
        this.jLabelLabel.setText(I18n.getString("meterinterval.label", "Label"));
        this.jLabelColor.setText(I18n.getString("meterinterval.color", "Color"));
        this.jLabelAlpha.setText(I18n.getString("meterinterval.alpha", "Alpha"));
        this.jLabelRangeHigh.setText(I18n.getString("meterinterval.highexp", "Data range high expression"));
        this.jLabelRangeLow.setText(I18n.getString("meterinterval.lowexp", "Data range low expression"));
        this.setTitle(I18n.getString("meterIntervalDialog.title", "Meter interval"));
        this.jButtonCancel.setMnemonic(I18n.getString("meterIntervalDialog.buttonCancelMnemonic", "c").charAt(0));
        this.jButtonOK.setMnemonic(I18n.getString("meterIntervalDialog.buttonOKMnemonic", "o").charAt(0));
        this.getRootPane().updateUI();
    }

    public MeterInterval getMeterInterval() {
        return this.meterInterval;
    }

    public void setMeterInterval(MeterInterval meterInterval) {
        this.meterInterval = meterInterval;
        if (meterInterval != null) {
            this.jTextFieldLabel.setText(meterInterval.getLabel());
            ((SpinnerNumberModel)this.jSpinnerAlpha.getModel()).setValue(new Double(meterInterval.getAlpha()));
            if (meterInterval.getColor() != null) {
                this.colorSelectorPanel.setValue(meterInterval.getColor());
            }
            this.jRTextExpressionLow.setText(meterInterval.getDataRange().getLowExpression());
            this.jRTextExpressionHigh.setText(meterInterval.getDataRange().getHighExpression());
        }
    }

    public void setFocusedExpression(Object[] expressionInfo) {
        if (expressionInfo == null) {
            return;
        }
        int expID = (Integer)expressionInfo[0];
        switch (expID) {
            case 1: {
                Misc.selectTextAndFocusArea(this.jRTextExpressionLow);
                break;
            }
            case 2: {
                Misc.selectTextAndFocusArea(this.jRTextExpressionHigh);
            }
        }
    }
}

