/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.chart;

import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.chart.ChartDatasetPanel;
import it.businesslogic.ireport.chart.ValueDataset;
import it.businesslogic.ireport.gui.JRTextExpressionArea;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ValueDatasetPanel
extends JPanel
implements ChartDatasetPanel {
    private ValueDataset valueDataset = null;
    private JLabel jLabelValueExpression;
    private JPanel jPanel1;
    private JRTextExpressionArea jRTextExpressionValue;
    public static final int COMPONENT_NONE = 0;
    public static final int COMPONENT_VALUE_EXPRESSION = 1;

    public ValueDatasetPanel() {
        this.initComponents();
        this.applyI18n();
        this.jRTextExpressionValue.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                ValueDatasetPanel.this.jRTextExpressionValueTextChanged();
            }

            public void insertUpdate(DocumentEvent evt) {
                ValueDatasetPanel.this.jRTextExpressionValueTextChanged();
            }

            public void removeUpdate(DocumentEvent evt) {
                ValueDatasetPanel.this.jRTextExpressionValueTextChanged();
            }
        });
    }

    public ValueDataset getValueDataset() {
        return this.valueDataset;
    }

    public void setSubDataset(SubDataset sds) {
        this.jRTextExpressionValue.setSubDataset(sds);
    }

    public void setValueDataset(ValueDataset valueDataset) {
        this.valueDataset = valueDataset;
        this.jRTextExpressionValue.setText(valueDataset.getValueExpression());
    }

    public void jRTextExpressionValueTextChanged() {
        this.valueDataset.setValueExpression(this.jRTextExpressionValue.getText());
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabelValueExpression = new JLabel();
        this.jRTextExpressionValue = new JRTextExpressionArea();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabelValueExpression.setText("Value expression");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel1.add((Component)this.jLabelValueExpression, gridBagConstraints);
        this.jRTextExpressionValue.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionValue.setElectricScroll(0);
        this.jRTextExpressionValue.setMinimumSize(new Dimension(10, 10));
        this.jRTextExpressionValue.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel1.add((Component)this.jRTextExpressionValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    public void applyI18n() {
        this.jLabelValueExpression.setText(I18n.getString("valueDatasetPanel.labelValueExpression", "Value expression"));
    }

    public void setFocusedExpression(Object[] expressionInfo) {
        if (expressionInfo == null) {
            return;
        }
        int expID = (Integer)expressionInfo[0];
        switch (expID) {
            case 1: {
                Misc.selectTextAndFocusArea(this.jRTextExpressionValue);
            }
        }
    }

    public void containerWindowOpened() {
    }
}

