/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.toplink;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.internal.databaseaccess.DatabasePlatform;
import oracle.toplink.jndi.JNDIConnector;
import oracle.toplink.sessionbroker.SessionBroker;
import oracle.toplink.sessions.Connector;
import oracle.toplink.sessions.DatabaseLogin;
import oracle.toplink.sessions.DatabaseSession;
import oracle.toplink.sessions.Session;
import oracle.toplink.sessions.SessionLog;
import oracle.toplink.threetier.ServerSession;
import oracle.toplink.tools.sessionconfiguration.XMLLoader;
import oracle.toplink.tools.sessionmanagement.SessionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.orm.toplink.ServerSessionFactory;
import org.springframework.orm.toplink.SessionBrokerSessionFactory;
import org.springframework.orm.toplink.SessionFactory;
import org.springframework.orm.toplink.SingleSessionFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

public class LocalSessionFactory {
    public static final String DEFAULT_SESSIONS_XML = "sessions.xml";
    public static final String DEFAULT_SESSION_NAME = "Session";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String configLocation = "sessions.xml";
    private String sessionName = "Session";
    private ClassLoader sessionClassLoader;
    private DatabaseLogin databaseLogin;
    private final Map loginPropertyMap = new HashMap();
    private DataSource dataSource;
    private DatabasePlatform databasePlatform;
    private SessionLog sessionLog;

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public void setSessionClassLoader(ClassLoader sessionClassLoader) {
        this.sessionClassLoader = sessionClassLoader;
    }

    public void setDatabaseLogin(DatabaseLogin databaseLogin) {
        this.databaseLogin = databaseLogin;
    }

    public void setLoginProperties(Properties loginProperties) {
        CollectionUtils.mergePropertiesIntoMap((Properties)loginProperties, (Map)this.loginPropertyMap);
    }

    public void setLoginPropertyMap(Map loginProperties) {
        if (loginProperties != null) {
            this.loginPropertyMap.putAll(loginProperties);
        }
    }

    public Map getLoginPropertyMap() {
        return this.loginPropertyMap;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDatabasePlatform(DatabasePlatform databasePlatform) {
        this.databasePlatform = databasePlatform;
    }

    public void setSessionLog(SessionLog sessionLog) {
        this.sessionLog = sessionLog;
    }

    public SessionFactory createSessionFactory() throws TopLinkException {
        DatabaseLogin login;
        ClassLoader classLoader;
        DatabaseSession session;
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Initializing TopLink SessionFactory from [" + this.configLocation + "]"));
        }
        if ((session = this.loadDatabaseSession(this.configLocation, this.sessionName, classLoader = this.sessionClassLoader != null ? this.sessionClassLoader : ClassUtils.getDefaultClassLoader())) == null) {
            throw new IllegalStateException("A session named '" + this.sessionName + "' could not be loaded from resource [" + this.configLocation + "] using ClassLoader [" + classLoader + "]. " + "This is most likely a deployment issue: Can the class loader access the resource?");
        }
        DatabaseLogin databaseLogin = login = this.databaseLogin != null ? this.databaseLogin : session.getLogin();
        if (this.loginPropertyMap != null) {
            PropertyAccessorFactory.forBeanPropertyAccess((Object)login).setPropertyValues(this.loginPropertyMap);
        }
        if (this.dataSource != null) {
            login.setConnector((Connector)new JNDIConnector(this.dataSource));
            login.setUsesExternalConnectionPooling(true);
        }
        if (this.databasePlatform != null) {
            login.usePlatform(this.databasePlatform);
        }
        if (this.databaseLogin != null) {
            this.setDatabaseLogin(session, this.databaseLogin);
        }
        if (this.sessionLog != null) {
            session.setSessionLog(this.sessionLog);
            session.logMessages();
        }
        session.login();
        return this.newSessionFactory(session);
    }

    protected void setDatabaseLogin(DatabaseSession session, DatabaseLogin login) {
        Method setLoginMethod = null;
        try {
            Class<?> loginClass = DatabaseSession.class.getClassLoader().loadClass("oracle.toplink.sessions.Login");
            setLoginMethod = DatabaseSession.class.getMethod("setLogin", loginClass);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Using TopLink 10.1.3 setLogin(Login) API");
            }
        }
        catch (Exception ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Using TopLink 9.0.4 setLogin(DatabaseLogin) API");
            }
            session.setLogin(login);
            return;
        }
        ReflectionUtils.invokeMethod((Method)setLoginMethod, (Object)session, (Object[])new Object[]{login});
    }

    protected DatabaseSession loadDatabaseSession(String configLocation, String sessionName, ClassLoader sessionClassLoader) throws TopLinkException {
        SessionManager manager = this.getSessionManager();
        Method getSessionMethod = null;
        Object loader = null;
        try {
            Class<?> loaderClass = SessionManager.class.getClassLoader().loadClass("oracle.toplink.tools.sessionconfiguration.XMLSessionConfigLoader");
            getSessionMethod = SessionManager.class.getMethod("getSession", loaderClass, String.class, ClassLoader.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Using TopLink 10.1.3 XMLSessionConfigLoader");
            }
            Constructor<?> ctor = loaderClass.getConstructor(String.class);
            loader = ctor.newInstance(configLocation);
        }
        catch (Exception ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Using TopLink 9.0.4 XMLLoader");
            }
            XMLLoader xmlLoader = new XMLLoader(configLocation);
            return (DatabaseSession)manager.getSession(xmlLoader, sessionName, sessionClassLoader, false, false);
        }
        return (DatabaseSession)ReflectionUtils.invokeMethod((Method)getSessionMethod, (Object)manager, (Object[])new Object[]{loader, sessionName, sessionClassLoader, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE});
    }

    protected SessionManager getSessionManager() {
        return new SessionManager();
    }

    protected SessionFactory newSessionFactory(DatabaseSession session) {
        if (session instanceof ServerSession) {
            return new ServerSessionFactory((ServerSession)session);
        }
        if (session instanceof SessionBroker) {
            return new SessionBrokerSessionFactory((SessionBroker)session);
        }
        return new SingleSessionFactory((Session)session);
    }
}

