/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.util;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.MockFilterConfig;
import org.springframework.security.util.FilterToBeanProxy;
import org.springframework.security.util.MockFilterChain;

public class FilterToBeanProxyTests
extends TestCase {
    public FilterToBeanProxyTests() {
    }

    public FilterToBeanProxyTests(String arg0) {
        super(arg0);
    }

    private void executeFilterInContainerSimulator(FilterConfig filterConfig, Filter filter, ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        filter.init(filterConfig);
        filter.doFilter(request, response, filterChain);
        filter.destroy();
    }

    public static void main(String[] args) {
        TestRunner.run(FilterToBeanProxyTests.class);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testDetectsClassNotInClassLoader() throws Exception {
        MockFilterConfig config = new MockFilterConfig();
        config.setInitParmeter("targetClass", "net.sf.DOES.NOT.EXIST");
        MockFilterToBeanProxy filter = new MockFilterToBeanProxy("org/springframework/security/util/filtertest-valid.xml");
        try {
            filter.init(config);
            FilterToBeanProxyTests.fail((String)"Should have thrown ServletException");
        }
        catch (ServletException expected) {
            FilterToBeanProxyTests.assertEquals((String)"Class of type net.sf.DOES.NOT.EXIST not found in classloader", (String)expected.getMessage());
        }
    }

    public void testDetectsNeitherPropertyBeingSet() throws Exception {
        MockFilterConfig config = new MockFilterConfig();
        MockFilterToBeanProxy filter = new MockFilterToBeanProxy("org/springframework/security/util/filtertest-valid.xml");
        try {
            filter.init(config);
            FilterToBeanProxyTests.fail((String)"Should have thrown ServletException");
        }
        catch (ServletException expected) {
            FilterToBeanProxyTests.assertEquals((String)"targetClass or targetBean must be specified", (String)expected.getMessage());
        }
    }

    public void testDetectsTargetBeanIsNotAFilter() throws Exception {
        MockFilterConfig config = new MockFilterConfig();
        config.setInitParmeter("targetClass", "org.springframework.security.util.MockNotAFilter");
        MockFilterToBeanProxy filter = new MockFilterToBeanProxy("org/springframework/security/util/filtertest-valid.xml");
        try {
            filter.init(config);
            FilterToBeanProxyTests.fail((String)"Should have thrown ServletException");
        }
        catch (ServletException expected) {
            FilterToBeanProxyTests.assertEquals((String)"Bean 'mockNotAFilter' does not implement javax.servlet.Filter", (String)expected.getMessage());
        }
    }

    public void testDetectsTargetBeanNotInBeanContext() throws Exception {
        MockFilterConfig config = new MockFilterConfig();
        config.setInitParmeter("targetBean", "WRONG_NAME");
        MockFilterToBeanProxy filter = new MockFilterToBeanProxy("org/springframework/security/util/filtertest-valid.xml");
        try {
            filter.init(config);
            FilterToBeanProxyTests.fail((String)"Should have thrown ServletException");
        }
        catch (ServletException expected) {
            FilterToBeanProxyTests.assertEquals((String)"targetBean 'WRONG_NAME' not found in context", (String)expected.getMessage());
        }
    }

    public void testDetectsTargetClassNotInBeanContext() throws Exception {
        MockFilterConfig config = new MockFilterConfig();
        config.setInitParmeter("targetClass", "org.springframework.security.util.FilterToBeanProxyTests");
        MockFilterToBeanProxy filter = new MockFilterToBeanProxy("org/springframework/security/util/filtertest-valid.xml");
        try {
            filter.init(config);
            FilterToBeanProxyTests.fail((String)"Should have thrown ServletException");
        }
        catch (ServletException expected) {
            FilterToBeanProxyTests.assertEquals((String)"Bean context must contain at least one bean of type org.springframework.security.util.FilterToBeanProxyTests", (String)expected.getMessage());
        }
    }

    public void testIgnoresEmptyTargetBean() throws Exception {
        MockFilterConfig config = new MockFilterConfig();
        config.setInitParmeter("targetClass", "org.springframework.security.util.MockFilter");
        config.setInitParmeter("targetBean", "");
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockFilterToBeanProxy filter = new MockFilterToBeanProxy("org/springframework/security/util/filtertest-valid.xml");
        this.executeFilterInContainerSimulator(config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
    }

    public void testNormalOperationWithLazyTrue() throws Exception {
        MockFilterConfig config = new MockFilterConfig();
        config.setInitParmeter("targetBean", "mockFilter");
        config.setInitParmeter("init", "lazy");
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockFilterToBeanProxy filter = new MockFilterToBeanProxy("org/springframework/security/util/filtertest-valid.xml");
        this.executeFilterInContainerSimulator(config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
    }

    public void testNormalOperationWithSpecificBeanName() throws Exception {
        MockFilterConfig config = new MockFilterConfig();
        config.setInitParmeter("targetBean", "mockFilter");
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockFilterToBeanProxy filter = new MockFilterToBeanProxy("org/springframework/security/util/filtertest-valid.xml");
        this.executeFilterInContainerSimulator(config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
    }

    public void testNormalOperationWithTargetClass() throws Exception {
        MockFilterConfig config = new MockFilterConfig();
        config.setInitParmeter("targetClass", "org.springframework.security.util.MockFilter");
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockFilterToBeanProxy filter = new MockFilterToBeanProxy("org/springframework/security/util/filtertest-valid.xml");
        this.executeFilterInContainerSimulator(config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
    }

    public void testNullDelegateDoesNotCauseNullPointerException() throws Exception {
        MockFilterConfig config = new MockFilterConfig();
        config.setInitParmeter("targetBean", "aFilterThatDoesntExist");
        config.setInitParmeter("init", "lazy");
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockFilterToBeanProxy filter = new MockFilterToBeanProxy("org/springframework/security/util/filtertest-valid.xml");
        filter.destroy();
    }

    private class MockFilterToBeanProxy
    extends FilterToBeanProxy {
        private String appContextLocation;

        public MockFilterToBeanProxy(String appContextLocation) {
            this.appContextLocation = appContextLocation;
        }

        protected ApplicationContext getContext(FilterConfig filterConfig) {
            return new ClassPathXmlApplicationContext(this.appContextLocation);
        }
    }
}

