/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.webapp;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import junit.framework.TestCase;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.MockAuthenticationManager;
import org.springframework.security.ui.WebAuthenticationDetails;
import org.springframework.security.ui.webapp.AuthenticationProcessingFilter;

public class AuthenticationProcessingFilterTests
extends TestCase {
    public AuthenticationProcessingFilterTests() {
    }

    public AuthenticationProcessingFilterTests(String arg0) {
        super(arg0);
    }

    public void testGetters() {
        AuthenticationProcessingFilter filter = new AuthenticationProcessingFilter();
        AuthenticationProcessingFilterTests.assertEquals((String)"/j_spring_security_check", (String)filter.getDefaultFilterProcessesUrl());
    }

    public void testNormalOperation() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("j_username", "rod");
        request.addParameter("j_password", "koala");
        AuthenticationProcessingFilter filter = new AuthenticationProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager(true));
        filter.init(null);
        Authentication result = filter.attemptAuthentication((HttpServletRequest)request);
        AuthenticationProcessingFilterTests.assertTrue((result != null ? 1 : 0) != 0);
        AuthenticationProcessingFilterTests.assertEquals((Object)"rod", (Object)request.getSession().getAttribute("SPRING_SECURITY_LAST_USERNAME"));
        AuthenticationProcessingFilterTests.assertEquals((String)"127.0.0.1", (String)((WebAuthenticationDetails)result.getDetails()).getRemoteAddress());
    }

    public void testNullPasswordHandledGracefully() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("j_username", "rod");
        AuthenticationProcessingFilter filter = new AuthenticationProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager(true));
        Authentication result = filter.attemptAuthentication((HttpServletRequest)request);
        AuthenticationProcessingFilterTests.assertTrue((result != null ? 1 : 0) != 0);
    }

    public void testNullUsernameHandledGracefully() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("j_password", "koala");
        AuthenticationProcessingFilter filter = new AuthenticationProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager(true));
        Authentication result = filter.attemptAuthentication((HttpServletRequest)request);
        AuthenticationProcessingFilterTests.assertTrue((result != null ? 1 : 0) != 0);
    }

    public void testUsingDifferentParameterNamesWorksAsExpected() throws ServletException {
        AuthenticationProcessingFilter filter = new AuthenticationProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager(true));
        filter.setUsernameParameter("x");
        filter.setPasswordParameter("y");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("x", "rod");
        request.addParameter("y", "koala");
        Authentication result = filter.attemptAuthentication((HttpServletRequest)request);
        AuthenticationProcessingFilterTests.assertTrue((result != null ? 1 : 0) != 0);
        AuthenticationProcessingFilterTests.assertEquals((String)"127.0.0.1", (String)((WebAuthenticationDetails)result.getDetails()).getRemoteAddress());
    }

    public void testSpacesAreTrimmedCorrectlyFromUsername() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("j_username", " rod ");
        request.addParameter("j_password", "koala");
        AuthenticationProcessingFilter filter = new AuthenticationProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager(true));
        Authentication result = filter.attemptAuthentication((HttpServletRequest)request);
        AuthenticationProcessingFilterTests.assertEquals((String)"rod", (String)result.getName());
    }

    public void testFailedAuthenticationThrowsException() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("j_username", "rod");
        AuthenticationProcessingFilter filter = new AuthenticationProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager(false));
        try {
            filter.attemptAuthentication((HttpServletRequest)request);
            AuthenticationProcessingFilterTests.fail((String)"Expected AuthenticationException");
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
        AuthenticationProcessingFilterTests.assertEquals((Object)"rod", (Object)request.getSession().getAttribute("SPRING_SECURITY_LAST_USERNAME"));
    }

    public void testNoSessionIsCreatedIfAllowSessionCreationIsFalse() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        AuthenticationProcessingFilter filter = new AuthenticationProcessingFilter();
        filter.setAllowSessionCreation(false);
        filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager(true));
        filter.attemptAuthentication((HttpServletRequest)request);
        AuthenticationProcessingFilterTests.assertNull((Object)request.getSession(false));
    }
}

