/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.preauth;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import junit.framework.TestCase;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.ui.preauth.PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails;

public class PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetailsTests
extends TestCase {
    public final void testToString() {
        PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails details = new PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails(this.getRequest("testUser", new String[0]));
        GrantedAuthority[] gas = new GrantedAuthority[]{new GrantedAuthorityImpl("Role1"), new GrantedAuthorityImpl("Role2")};
        details.setGrantedAuthorities(gas);
        String toString = details.toString();
        PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetailsTests.assertTrue((String)"toString should contain Role1", (boolean)toString.contains("Role1"));
        PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetailsTests.assertTrue((String)"toString should contain Role2", (boolean)toString.contains("Role2"));
    }

    public final void testGetSetPreAuthenticatedGrantedAuthorities() {
        PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails details = new PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails(this.getRequest("testUser", new String[0]));
        GrantedAuthority[] gas = new GrantedAuthority[]{new GrantedAuthorityImpl("Role1"), new GrantedAuthorityImpl("Role2")};
        List<GrantedAuthority> expectedGas = Arrays.asList(gas);
        details.setGrantedAuthorities(gas);
        List<GrantedAuthority> returnedGas = Arrays.asList(details.getGrantedAuthorities());
        PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetailsTests.assertTrue((String)("Collections do not contain same elements; expected: " + expectedGas + ", returned: " + returnedGas), (expectedGas.containsAll(returnedGas) && returnedGas.containsAll(expectedGas) ? 1 : 0) != 0);
    }

    public final void testGetWithoutSetPreAuthenticatedGrantedAuthorities() {
        PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails details = new PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails(this.getRequest("testUser", new String[0]));
        try {
            GrantedAuthority[] gas = details.getGrantedAuthorities();
            PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetailsTests.fail((String)"Expected exception didn't occur");
        }
        catch (IllegalArgumentException expected) {
        }
        catch (Exception unexpected) {
            PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetailsTests.fail((String)("Unexpected exception: " + unexpected.toString()));
        }
    }

    private final HttpServletRequest getRequest(String userName, final String[] aRoles) {
        MockHttpServletRequest req = new MockHttpServletRequest(){
            private Set roles;
            {
                this.roles = new HashSet<String>(Arrays.asList(aRoles));
            }

            public boolean isUserInRole(String arg0) {
                return this.roles.contains(arg0);
            }
        };
        req.setRemoteUser(userName);
        return req;
    }
}

