/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.runas;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.security.Authentication;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.SecurityConfig;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.runas.RunAsManagerImpl;
import org.springframework.security.runas.RunAsUserToken;

public class RunAsManagerImplTests
extends TestCase {
    public RunAsManagerImplTests() {
    }

    public RunAsManagerImplTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run(RunAsManagerImplTests.class);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testAlwaysSupportsClass() {
        RunAsManagerImpl runAs = new RunAsManagerImpl();
        RunAsManagerImplTests.assertTrue((boolean)runAs.supports(String.class));
    }

    public void testDoesNotReturnAdditionalAuthoritiesIfCalledWithoutARunAsSetting() throws Exception {
        ConfigAttributeDefinition def = new ConfigAttributeDefinition("SOMETHING_WE_IGNORE");
        UsernamePasswordAuthenticationToken inputToken = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        RunAsManagerImpl runAs = new RunAsManagerImpl();
        runAs.setKey("my_password");
        Authentication resultingToken = runAs.buildRunAs((Authentication)inputToken, new Object(), def);
        RunAsManagerImplTests.assertEquals(null, (Object)resultingToken);
    }

    public void testRespectsRolePrefix() throws Exception {
        ConfigAttributeDefinition def = new ConfigAttributeDefinition("RUN_AS_SOMETHING");
        UsernamePasswordAuthenticationToken inputToken = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ONE"), new GrantedAuthorityImpl("TWO")});
        RunAsManagerImpl runAs = new RunAsManagerImpl();
        runAs.setKey("my_password");
        runAs.setRolePrefix("FOOBAR_");
        Authentication resultingToken = runAs.buildRunAs((Authentication)inputToken, new Object(), def);
        if (!(resultingToken instanceof RunAsUserToken)) {
            RunAsManagerImplTests.fail((String)"Should have returned a RunAsUserToken");
        }
        RunAsManagerImplTests.assertEquals((Object)inputToken.getPrincipal(), (Object)resultingToken.getPrincipal());
        RunAsManagerImplTests.assertEquals((Object)inputToken.getCredentials(), (Object)resultingToken.getCredentials());
        RunAsManagerImplTests.assertEquals((String)"FOOBAR_RUN_AS_SOMETHING", (String)resultingToken.getAuthorities()[0].getAuthority());
        RunAsManagerImplTests.assertEquals((String)"ONE", (String)resultingToken.getAuthorities()[1].getAuthority());
        RunAsManagerImplTests.assertEquals((String)"TWO", (String)resultingToken.getAuthorities()[2].getAuthority());
        RunAsUserToken resultCast = (RunAsUserToken)resultingToken;
        RunAsManagerImplTests.assertEquals((int)"my_password".hashCode(), (int)resultCast.getKeyHash());
    }

    public void testReturnsAdditionalGrantedAuthorities() throws Exception {
        ConfigAttributeDefinition def = new ConfigAttributeDefinition("RUN_AS_SOMETHING");
        UsernamePasswordAuthenticationToken inputToken = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        RunAsManagerImpl runAs = new RunAsManagerImpl();
        runAs.setKey("my_password");
        Authentication resultingToken = runAs.buildRunAs((Authentication)inputToken, new Object(), def);
        if (!(resultingToken instanceof RunAsUserToken)) {
            RunAsManagerImplTests.fail((String)"Should have returned a RunAsUserToken");
        }
        RunAsManagerImplTests.assertEquals((Object)inputToken.getPrincipal(), (Object)resultingToken.getPrincipal());
        RunAsManagerImplTests.assertEquals((Object)inputToken.getCredentials(), (Object)resultingToken.getCredentials());
        RunAsManagerImplTests.assertEquals((String)"ROLE_RUN_AS_SOMETHING", (String)resultingToken.getAuthorities()[0].getAuthority());
        RunAsManagerImplTests.assertEquals((String)"ROLE_ONE", (String)resultingToken.getAuthorities()[1].getAuthority());
        RunAsManagerImplTests.assertEquals((String)"ROLE_TWO", (String)resultingToken.getAuthorities()[2].getAuthority());
        RunAsUserToken resultCast = (RunAsUserToken)resultingToken;
        RunAsManagerImplTests.assertEquals((int)"my_password".hashCode(), (int)resultCast.getKeyHash());
    }

    public void testStartupDetectsMissingKey() throws Exception {
        RunAsManagerImpl runAs = new RunAsManagerImpl();
        try {
            runAs.afterPropertiesSet();
            RunAsManagerImplTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            RunAsManagerImplTests.assertTrue((boolean)true);
        }
    }

    public void testStartupSuccessfulWithKey() throws Exception {
        RunAsManagerImpl runAs = new RunAsManagerImpl();
        runAs.setKey("hello_world");
        runAs.afterPropertiesSet();
        RunAsManagerImplTests.assertEquals((String)"hello_world", (String)runAs.getKey());
    }

    public void testSupports() throws Exception {
        RunAsManagerImpl runAs = new RunAsManagerImpl();
        RunAsManagerImplTests.assertTrue((boolean)runAs.supports((ConfigAttribute)new SecurityConfig("RUN_AS_SOMETHING")));
        RunAsManagerImplTests.assertTrue((!runAs.supports((ConfigAttribute)new SecurityConfig("ROLE_WHICH_IS_IGNORED")) ? 1 : 0) != 0);
        RunAsManagerImplTests.assertTrue((!runAs.supports((ConfigAttribute)new SecurityConfig("role_LOWER_CASE_FAILS")) ? 1 : 0) != 0);
    }
}

