/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.x509.cache;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.providers.x509.X509TestUtils;
import org.springframework.security.providers.x509.cache.EhCacheBasedX509UserCache;
import org.springframework.security.userdetails.User;
import org.springframework.security.userdetails.UserDetails;

public class EhCacheBasedX509UserCacheTests {
    private static CacheManager cacheManager;

    @BeforeClass
    public static void initCacheManaer() {
        cacheManager = new CacheManager();
        cacheManager.addCache(new Cache("x509cachetests", 500, false, false, 30L, 30L));
    }

    @AfterClass
    public static void shutdownCacheManager() {
        cacheManager.removalAll();
        cacheManager.shutdown();
    }

    private Ehcache getCache() {
        Cache cache = cacheManager.getCache("x509cachetests");
        cache.removeAll();
        return cache;
    }

    private UserDetails getUser() {
        return new User("rod", "password", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
    }

    @Test
    public void cacheOperationsAreSucessful() throws Exception {
        EhCacheBasedX509UserCache cache = new EhCacheBasedX509UserCache();
        cache.setCache(this.getCache());
        cache.afterPropertiesSet();
        cache.putUserInCache(X509TestUtils.buildTestCertificate(), this.getUser());
        Assert.assertEquals((Object)this.getUser().getPassword(), (Object)cache.getUserFromCache(X509TestUtils.buildTestCertificate()).getPassword());
        cache.removeUserFromCache(X509TestUtils.buildTestCertificate());
        Assert.assertNull((Object)cache.getUserFromCache(X509TestUtils.buildTestCertificate()));
        Assert.assertNull((Object)cache.getUserFromCache(null));
    }
}

