/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.rememberme;

import junit.framework.TestCase;
import org.springframework.security.Authentication;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.providers.TestingAuthenticationToken;
import org.springframework.security.providers.rememberme.RememberMeAuthenticationProvider;
import org.springframework.security.providers.rememberme.RememberMeAuthenticationToken;

public class RememberMeAuthenticationProviderTests
extends TestCase {
    public RememberMeAuthenticationProviderTests() {
    }

    public RememberMeAuthenticationProviderTests(String arg0) {
        super(arg0);
    }

    public void testDetectsAnInvalidKey() throws Exception {
        RememberMeAuthenticationProvider aap = new RememberMeAuthenticationProvider();
        aap.setKey("qwerty");
        RememberMeAuthenticationToken token = new RememberMeAuthenticationToken("WRONG_KEY", (Object)"Test", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        try {
            Authentication result = aap.authenticate((Authentication)token);
            RememberMeAuthenticationProviderTests.fail((String)"Should have thrown BadCredentialsException");
        }
        catch (BadCredentialsException badCredentialsException) {
            // empty catch block
        }
    }

    public void testDetectsMissingKey() throws Exception {
        RememberMeAuthenticationProvider aap = new RememberMeAuthenticationProvider();
        try {
            aap.afterPropertiesSet();
            RememberMeAuthenticationProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            RememberMeAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testGettersSetters() throws Exception {
        RememberMeAuthenticationProvider aap = new RememberMeAuthenticationProvider();
        aap.setKey("qwerty");
        aap.afterPropertiesSet();
        RememberMeAuthenticationProviderTests.assertEquals((String)"qwerty", (String)aap.getKey());
    }

    public void testIgnoresClassesItDoesNotSupport() throws Exception {
        RememberMeAuthenticationProvider aap = new RememberMeAuthenticationProvider();
        aap.setKey("qwerty");
        TestingAuthenticationToken token = new TestingAuthenticationToken((Object)"user", (Object)"password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_A")});
        RememberMeAuthenticationProviderTests.assertFalse((boolean)aap.supports(TestingAuthenticationToken.class));
        RememberMeAuthenticationProviderTests.assertNull((Object)aap.authenticate((Authentication)token));
    }

    public void testNormalOperation() throws Exception {
        RememberMeAuthenticationProvider aap = new RememberMeAuthenticationProvider();
        aap.setKey("qwerty");
        RememberMeAuthenticationToken token = new RememberMeAuthenticationToken("qwerty", (Object)"Test", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        Authentication result = aap.authenticate((Authentication)token);
        RememberMeAuthenticationProviderTests.assertEquals((Object)result, (Object)token);
    }

    public void testSupports() {
        RememberMeAuthenticationProvider aap = new RememberMeAuthenticationProvider();
        RememberMeAuthenticationProviderTests.assertTrue((boolean)aap.supports(RememberMeAuthenticationToken.class));
        RememberMeAuthenticationProviderTests.assertFalse((boolean)aap.supports(TestingAuthenticationToken.class));
    }
}

