/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.validation.advices;

import java.io.PrintStream;
import java.lang.reflect.Method;
import org.apache.maven.doxia.validation.advices.AbstractSinkAdvice;

public class PrintAdvisor
extends AbstractSinkAdvice {
    private String indent = "";
    private PrintStream printStream;
    private static final String INDENT_STEP = "   ";
    private static final int INDENT_STEP_LEN = "   ".length();

    public PrintAdvisor(PrintStream printStream) {
        if (printStream == null) {
            throw new IllegalArgumentException("argument cant be null");
        }
        this.printStream = printStream;
    }

    public final void doLeaf(Method method, Object[] args, Object instance) {
        this.printStream.println(this.indent + method.getName());
    }

    public final void doStart(Method method, Object[] args, Object instance) {
        this.printStream.println(this.indent + method.getName());
        this.indent = this.indent + INDENT_STEP;
    }

    public final void doEnd(Method method, Object[] args, Object instance) {
        this.indent = this.indent.substring(INDENT_STEP_LEN);
        this.printStream.println(this.indent + method.getName());
    }
}

