/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.irplugin.gui.explorer;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.irplugin.IRPlugin;
import com.jaspersoft.jasperserver.irplugin.gui.RepositoryTreeCellRenderer;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JList;

public class ExplorerCellRenderer
extends DefaultListCellRenderer {
    static final ImageIcon longIcon = new ImageIcon("long.gif");
    static final ImageIcon shortIcon = new ImageIcon("short.gif");
    boolean comboboxMode = false;

    public ExplorerCellRenderer(boolean mode) {
        this.comboboxMode = mode;
    }

    public ExplorerCellRenderer() {
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean iss, boolean chf) {
        super.getListCellRendererComponent((JList<?>)list, value, index, iss, chf);
        if (value instanceof ResourceDescriptor) {
            ResourceDescriptor rd = (ResourceDescriptor)value;
            if (rd.getUriString().equals("/")) {
                this.setIcon(RepositoryTreeCellRenderer.getResourceIcon(null));
                this.setText(IRPlugin.getString("misc.labelRepositoryRoot", "Repository root (/)"));
            } else {
                ImageIcon iconImage = RepositoryTreeCellRenderer.getResourceIcon(rd);
                if (this.comboboxMode && index > 0) {
                    BufferedImage image = new BufferedImage(iconImage.getIconWidth() + 8 * index, iconImage.getIconHeight(), 1);
                    Graphics g = ((Image)image).getGraphics();
                    g.setColor(iss ? list.getSelectionBackground() : list.getBackground());
                    g.fillRect(0, 0, ((Image)image).getWidth(null), ((Image)image).getHeight(null));
                    g.drawImage(iconImage.getImage(), 8 * index, 0, null);
                    this.setIcon(new ImageIcon(image));
                } else {
                    this.setIcon(iconImage);
                }
                this.setText(rd.getName());
            }
        }
        return this;
    }
}

