/*
 * Decompiled with CFR 0.152.
 */
package org.unitils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.testng.IHookCallBack;
import org.testng.IHookable;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.unitils.core.TestListener;
import org.unitils.core.Unitils;

public abstract class UnitilsTestNG
implements IHookable {
    private boolean beforeTestSetUpCalled = false;

    @BeforeClass(alwaysRun=true)
    protected void unitilsBeforeClass() {
        this.getTestListener().beforeTestClass(this.getClass());
        this.getTestListener().afterCreateTestObject(this);
    }

    @BeforeMethod(alwaysRun=true)
    protected void unitilsBeforeTestSetUp(Method testMethod) {
        this.beforeTestSetUpCalled = true;
        this.getTestListener().beforeTestSetUp(this, testMethod);
    }

    @AfterMethod(alwaysRun=true)
    protected void unitilsAfterTestTearDown(Method testMethod) {
        if (this.beforeTestSetUpCalled) {
            this.beforeTestSetUpCalled = false;
            this.getTestListener().afterTestTearDown(this, testMethod);
        }
    }

    public void run(IHookCallBack callBack, ITestResult testResult) {
        Throwable beforeTestMethodException = null;
        try {
            this.getTestListener().beforeTestMethod(this, testResult.getMethod().getMethod());
        }
        catch (Throwable e) {
            beforeTestMethodException = e;
        }
        Throwable testMethodException = null;
        if (beforeTestMethodException == null) {
            callBack.runTestMethod(testResult);
            testMethodException = testResult.getThrowable();
            if (testMethodException != null && testMethodException instanceof InvocationTargetException) {
                testMethodException = ((InvocationTargetException)testMethodException).getTargetException();
            }
        }
        Throwable afterTestMethodException = null;
        try {
            this.getTestListener().afterTestMethod(this, testResult.getMethod().getMethod(), beforeTestMethodException != null ? beforeTestMethodException : testMethodException);
        }
        catch (Throwable e) {
            afterTestMethodException = e;
        }
        if (beforeTestMethodException != null) {
            this.throwException(beforeTestMethodException);
        } else if (testMethodException == null && afterTestMethodException != null) {
            this.throwException(afterTestMethodException);
        }
    }

    protected void throwException(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new RuntimeException(throwable);
    }

    protected TestListener getTestListener() {
        return this.getUnitils().getTestListener();
    }

    protected Unitils getUnitils() {
        return Unitils.getInstance();
    }
}

