/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.util;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.export.CommandHelpImpl;
import com.jaspersoft.jasperserver.export.CommandMetadataImpl;
import com.jaspersoft.jasperserver.export.Parameters;
import com.jaspersoft.jasperserver.export.util.CommandUtils;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.context.MessageSource;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;

public class EncryptionUtils {
    public static final String ARG_PASS = "pass";
    private static final String JS_ENCRYPTION_KEY = "JasperSoft";
    private static final String CRYPTOGRAPHIC_SERVICE = "Blowfish";
    private static final String MESSAGE_SOURCE_BUNDLE = "config/bundles/ji-export-messages";
    private static final String EXCEPTION_MESSAGE_SOURCE_BUNDLE = "config/bundles/jsexceptions_messages";

    public static void main(String[] args) throws Exception {
        Parameters exportParameters = CommandUtils.parse(args);
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
        messageSource.setUseCodeAsDefaultMessage(true);
        messageSource.setBasenames(new String[]{MESSAGE_SOURCE_BUNDLE, EXCEPTION_MESSAGE_SOURCE_BUNDLE});
        PrintStream out = System.out;
        try {
            if (exportParameters.hasParameter(ARG_PASS)) {
                String password = exportParameters.getParameterValue(ARG_PASS);
                if (password == null) {
                    throw new JSException("jsexception.parameter.has.no.value", new Object[]{ARG_PASS});
                }
                byte[] encrypted = EncryptionUtils.encrypt(password);
                String encPass = EncryptionUtils.bytes2String(encrypted);
                out.println(messageSource.getMessage("ji.export.encryption.enc-pass", (Object[])new String[]{password}, Locale.getDefault()));
                out.println(messageSource.getMessage("ji.export.encryption.add-string", null, Locale.getDefault()));
                out.println("metadata.jdbc.encryptedPassword=" + encPass);
                out.println();
            } else {
                ArrayList<String> commands = new ArrayList<String>();
                commands.add("help");
                commands.add(ARG_PASS);
                CommandMetadataImpl metadata = new CommandMetadataImpl();
                metadata.setArgumentNames(commands);
                CommandHelpImpl help = new CommandHelpImpl();
                help.setMessageSource((MessageSource)messageSource);
                help.setStartMessage("ji.export.help.header");
                help.setArgDescriptionMessagePrefix("ji.export.arg.description.");
                help.setArgLinePrefix("  ");
                help.setArgLineSeparator("  ");
                help.printHelp(args[0], metadata, out);
            }
        }
        catch (JSException e) {
            String message = messageSource.getMessage(e.getMessage(), e.getArgs(), Locale.getDefault());
            System.err.println(message);
        }
    }

    public static byte[] encrypt(String encString, byte[] raw) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(raw, CRYPTOGRAPHIC_SERVICE);
        Cipher cipher = Cipher.getInstance(CRYPTOGRAPHIC_SERVICE);
        cipher.init(1, skeySpec);
        return cipher.doFinal(encString.getBytes());
    }

    public static String decrypt(byte[] encRead, byte[] raw) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(raw, CRYPTOGRAPHIC_SERVICE);
        Cipher cipher = Cipher.getInstance(CRYPTOGRAPHIC_SERVICE);
        cipher.init(2, skeySpec);
        return new String(cipher.doFinal(encRead));
    }

    public static byte[] encrypt(String encString) throws Exception {
        return EncryptionUtils.encrypt(encString, JS_ENCRYPTION_KEY.getBytes());
    }

    public static String getEncryptedString(String encString, byte[] raw) throws Exception {
        return EncryptionUtils.bytes2String(EncryptionUtils.encrypt(encString, raw));
    }

    public static String getEncryptedString(String encString) throws Exception {
        return EncryptionUtils.bytes2String(EncryptionUtils.encrypt(encString, JS_ENCRYPTION_KEY.getBytes()));
    }

    public static String decrypt(byte[] encRead) throws Exception {
        return EncryptionUtils.decrypt(encRead, JS_ENCRYPTION_KEY.getBytes());
    }

    public static String decrypt(String encString) throws Exception {
        return EncryptionUtils.decrypt(EncryptionUtils.string2Bytes(encString));
    }

    private static String bytes2String(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String s;
            if (i > 0) {
                sb.append(",");
            }
            if ((s = Integer.toHexString(bytes[i])).length() > 2) {
                s = s.substring(s.length() - 2);
            }
            if (s.length() < 2) {
                s = "0" + s;
            }
            sb.append("0x").append(s);
        }
        return sb.toString();
    }

    private static byte[] string2Bytes(String str) {
        String[] sa = str.split(",");
        byte[] bytes = new byte[sa.length];
        for (int i = 0; i < sa.length; ++i) {
            bytes[i] = Short.decode(sa[i]).byteValue();
        }
        return bytes;
    }
}

