/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ResultStyle;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.NamedSet;
import mondrian.olap.Util;
import mondrian.olap.type.SetType;
import mondrian.rolap.RolapEvaluatorRoot;
import mondrian.rolap.RolapResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RolapNamedSetEvaluator
implements Evaluator.NamedSetEvaluator {
    private final RolapResult.RolapResultEvaluatorRoot rrer;
    private final NamedSet namedSet;
    private List list;
    private static final List DUMMY_LIST = Collections.unmodifiableList(Arrays.asList(new Object()));
    private int currentOrdinal;

    public RolapNamedSetEvaluator(RolapResult.RolapResultEvaluatorRoot rrer, NamedSet namedSet) {
        this.rrer = rrer;
        this.namedSet = namedSet;
    }

    @Override
    public Iterable<Member> evaluateMemberIterable() {
        this.ensureList();
        return new IterableCollection<Member>();
    }

    @Override
    public Iterable<Member[]> evaluateTupleIterable() {
        this.ensureList();
        return new IterableCollection<Member[]>();
    }

    private <T> void ensureList() {
        ArrayList rawList;
        if (this.list != null) {
            if (this.list == DUMMY_LIST) {
                throw this.rrer.slicerEvaluator.newEvalException(null, "Illegal attempt to reference value of named set '" + this.namedSet.getName() + "' while evaluating itself");
            }
            return;
        }
        if (RolapResult.LOGGER.isDebugEnabled()) {
            RolapResult.LOGGER.debug((Object)("Named set " + this.namedSet.getName() + ": starting evaluation"));
        }
        this.list = DUMMY_LIST;
        RolapEvaluatorRoot root = this.rrer.slicerEvaluator.root;
        Calc calc = root.getCompiled(this.namedSet.getExp(), false, ResultStyle.ITERABLE);
        Object o = this.rrer.result.evaluateExp(calc, this.rrer.slicerEvaluator.push());
        if (o instanceof List) {
            rawList = (ArrayList)o;
        } else {
            Iterable iter = Util.castToIterable(o);
            rawList = new ArrayList();
            for (Object e : iter) {
                rawList.add(e);
            }
        }
        if (RolapResult.LOGGER.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder();
            buf.append(this);
            buf.append(": ");
            buf.append("Named set ");
            buf.append(this.namedSet.getName());
            buf.append(" evaluated to:");
            buf.append(Util.nl);
            int arity = ((SetType)calc.getType()).getArity();
            int rowCount = 0;
            int maxRowCount = 100;
            if (arity == 1) {
                for (Member t : Util.cast(rawList)) {
                    if (rowCount++ > 100) {
                        buf.append("...");
                        buf.append(Util.nl);
                        break;
                    }
                    buf.append(t);
                    buf.append(Util.nl);
                }
            } else {
                for (Member[] t : Util.cast(rawList)) {
                    if (rowCount++ > 100) {
                        buf.append("...");
                        buf.append(Util.nl);
                        break;
                    }
                    int k = 0;
                    for (Member member : t) {
                        if (k++ > 0) {
                            buf.append(", ");
                        }
                        buf.append(member);
                    }
                    buf.append(Util.nl);
                }
            }
            RolapResult.LOGGER.debug((Object)buf);
        }
        this.list = new AbstractList<T>(){

            @Override
            public T get(int index) {
                RolapNamedSetEvaluator.this.currentOrdinal = index;
                return rawList.get(index);
            }

            @Override
            public int size() {
                return rawList.size();
            }
        };
    }

    @Override
    public int currentOrdinal() {
        return this.currentOrdinal;
    }

    @Override
    public Member[] currentTuple() {
        return (Member[])this.list.get(this.currentOrdinal);
    }

    @Override
    public Member currentMember() {
        return (Member)this.list.get(this.currentOrdinal);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IterableCollection<T>
    implements Collection<T>,
    Iterable<T> {
        private IterableCollection() {
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                int i = -1;

                @Override
                public boolean hasNext() {
                    return this.i < RolapNamedSetEvaluator.this.list.size() - 1;
                }

                @Override
                public T next() {
                    RolapNamedSetEvaluator.this.currentOrdinal = ++this.i;
                    return RolapNamedSetEvaluator.this.list.get(this.i);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean add(T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return RolapNamedSetEvaluator.this.list.isEmpty();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return RolapNamedSetEvaluator.this.list.size();
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException();
        }
    }
}

