/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.ValidationError;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrors;
import com.jaspersoft.jasperserver.api.common.domain.impl.ValidationErrorImpl;
import com.jaspersoft.jasperserver.api.common.domain.impl.ValidationErrorsImpl;
import com.jaspersoft.jasperserver.api.engine.scheduling.ReportJobValidator;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobCalendarTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobMailNotification;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobRepositoryDestination;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSimpleTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSource;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobTrigger;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.RepositorySecurityChecker;
import com.jaspersoft.jasperserver.api.metadata.common.util.ValidationUtil;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.quartz.TriggerUtils;
import org.springframework.security.context.SecurityContextHolder;

public class DefaultReportJobValidator
implements ReportJobValidator {
    public static final String DEFAULT_EMAIL_PATTERN = "^[^\\~\\`\\(\\)\\[\\]\\{\\}\\:\"\\;'/\\?\\<\\>\\+\\=\\\\|\\!\\@\\#\\$\\%\\^\\&\\*]+@([\\w+\\-]+\\.)+(\\w+)";
    private static final Pattern PATTERN_CRON_MINUTES;
    private static final Pattern PATTERN_CRON_HOURS;
    private static final Pattern PATTERN_CRON_MONTH_DAYS;
    private static final Pattern PATTERN_TIMESTAMP_FORMAT;
    private RepositoryService repository;
    private RepositorySecurityChecker repositoryServiceSecurityChecker;
    private Pattern emailPattern = Pattern.compile("^[^\\~\\`\\(\\)\\[\\]\\{\\}\\:\"\\;'/\\?\\<\\>\\+\\=\\\\|\\!\\@\\#\\$\\%\\^\\&\\*]+@([\\w+\\-]+\\.)+(\\w+)");

    public ValidationErrors validateJob(ExecutionContext context, ReportJob job) {
        ValidationErrorsImpl errors = new ValidationErrorsImpl();
        this.validateJobDetails((ValidationErrors)errors, job);
        this.validateSource((ValidationErrors)errors, job.getSource());
        this.validateJobTrigger((ValidationErrors)errors, job);
        this.validateJobOutput((ValidationErrors)errors, job);
        return errors;
    }

    protected void validateJobDetails(ValidationErrors errors, ReportJob job) {
        this.checkString(errors, "label", job.getLabel(), true, 100);
        this.checkString(errors, "description", job.getDescription(), false, 2000);
    }

    protected void validateSource(ValidationErrors errors, ReportJobSource source) {
        if (source == null) {
            errors.add((ValidationError)new ValidationErrorImpl("error.report.job.no.source", null, null, "source"));
        } else {
            String reportUnitURI = source.getReportUnitURI();
            if (this.checkString(errors, "source.reportUnitURI", reportUnitURI, true, 200)) {
                this.validateReportURI(errors, reportUnitURI);
            }
        }
    }

    protected void validateReportURI(ValidationErrors errors, String reportUnitURI) {
        if (!this.getRepository().resourceExists(null, reportUnitURI, ReportUnit.class)) {
            errors.add((ValidationError)new ValidationErrorImpl("error.report.job.report.inexistent", new Object[]{reportUnitURI}, null, "source.reportUnitURI"));
        }
    }

    protected void validateJobTrigger(ValidationErrors errors, ReportJob job) {
        ReportJobTrigger trigger = job.getTrigger();
        if (trigger == null) {
            errors.add((ValidationError)new ValidationErrorImpl("error.report.job.no.trigger", null, "No trigger is defined for the job.", "trigger"));
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date now = calendar.getTime();
        String tzId = trigger.getTimezone();
        if (tzId != null && tzId.length() > 0) {
            TimeZone tz = TimeZone.getTimeZone(tzId);
            now = TriggerUtils.translateTime((Date)now, (TimeZone)tz, (TimeZone)TimeZone.getDefault());
        }
        if (trigger.getStartType() == 2) {
            Date startDate = trigger.getStartDate();
            if (startDate == null) {
                this.addNotEmpty(errors, "trigger.startDate");
            } else if (job.getVersion() == -1 && startDate.before(now)) {
                errors.add((ValidationError)new ValidationErrorImpl("error.before.current.date", null, "Start date cannot be in the past.", "trigger.startDate"));
            }
        }
        if (trigger.getEndDate() != null) {
            switch (trigger.getStartType()) {
                case 1: {
                    if (!trigger.getEndDate().before(now)) break;
                    errors.add((ValidationError)new ValidationErrorImpl("error.before.current.date", null, "End date cannot be in the past.", "trigger.endDate"));
                    break;
                }
                case 2: {
                    if (trigger.getStartDate() == null || !trigger.getEndDate().before(trigger.getStartDate())) break;
                    errors.add((ValidationError)new ValidationErrorImpl("error.before.start.date", null, "End date cannot be before start date", "trigger.endDate"));
                }
            }
        }
        if (trigger instanceof ReportJobSimpleTrigger) {
            this.validateJobSimpleTrigger(errors, (ReportJobSimpleTrigger)trigger);
        } else if (trigger instanceof ReportJobCalendarTrigger) {
            this.validateJobCalendarTrigger(errors, (ReportJobCalendarTrigger)trigger);
        } else {
            String quotedTriggerType = "\"" + trigger.getClass().getName() + "\"";
            throw new JSException("jsexception.job.unknown.trigger.type", new Object[]{quotedTriggerType});
        }
    }

    protected void validateJobSimpleTrigger(ValidationErrors errors, ReportJobSimpleTrigger trigger) {
        int occurrenceCount = trigger.getOccurrenceCount();
        if (occurrenceCount != -1 && occurrenceCount < 1) {
            errors.add((ValidationError)new ValidationErrorImpl("error.invalid", null, null, "trigger.occurrenceCount"));
        } else if (occurrenceCount > 1 || occurrenceCount == -1) {
            if (trigger.getRecurrenceInterval() == null) {
                this.addNotEmpty(errors, "trigger.recurrenceInterval");
            } else if (trigger.getRecurrenceInterval() <= 0) {
                errors.add((ValidationError)new ValidationErrorImpl("error.positive", null, null, "trigger.recurrenceInterval"));
            }
            if (trigger.getRecurrenceIntervalUnit() == null) {
                this.addNotEmpty(errors, "trigger.recurrenceIntervalUnit");
            }
        }
    }

    protected void validateJobCalendarTrigger(ValidationErrors errors, ReportJobCalendarTrigger trigger) {
        if (this.checkString(errors, "trigger.minutes", trigger.getMinutes(), true, 200)) {
            this.validateCronMinutes(errors, trigger.getMinutes());
        }
        if (this.checkString(errors, "trigger.hours", trigger.getHours(), true, 80)) {
            this.validateCronHours(errors, trigger.getHours());
        }
        switch (trigger.getDaysType()) {
            case 1: {
                break;
            }
            case 2: {
                if (trigger.getWeekDays() != null && !trigger.getWeekDays().isEmpty()) break;
                errors.add((ValidationError)new ValidationErrorImpl("error.not.empty", null, "The value cannot be empty", "trigger.weekDays"));
                break;
            }
            case 3: {
                if (!this.checkString(errors, "trigger.monthDays", trigger.getMonthDays(), true, 100)) break;
                this.validateCronMonthDays(errors, trigger.getMonthDays());
                break;
            }
            default: {
                throw new JSException("jsexception.job.unknown.calendar.trigger.days.type", new Object[]{new Byte(trigger.getDaysType())});
            }
        }
        if (trigger.getMonths() == null || trigger.getMonths().isEmpty()) {
            errors.add((ValidationError)new ValidationErrorImpl("error.not.empty", null, "The value cannot be empty", "trigger.months"));
        }
    }

    protected void validateCronMinutes(ValidationErrors errors, String minutes) {
        if (!PATTERN_CRON_MINUTES.matcher(minutes).matches()) {
            errors.add((ValidationError)new ValidationErrorImpl("error.pattern", null, "The minutes are not valid", "trigger.minutes"));
        }
    }

    protected void validateCronHours(ValidationErrors errors, String hours) {
        if (!PATTERN_CRON_HOURS.matcher(hours).matches()) {
            errors.add((ValidationError)new ValidationErrorImpl("error.pattern", null, "The hours are not valid", "trigger.hours"));
        }
    }

    protected void validateCronMonthDays(ValidationErrors errors, String days) {
        if (!PATTERN_CRON_MONTH_DAYS.matcher(days).matches()) {
            errors.add((ValidationError)new ValidationErrorImpl("error.pattern", null, "The hours are not valid", "trigger.monthDays"));
        }
    }

    protected void validateJobOutput(ValidationErrors errors, ReportJob job) {
        Set outputFormats;
        String baseOutputFilename = job.getBaseOutputFilename();
        if (this.checkString(errors, "baseOutputFilename", baseOutputFilename, true, 100) && !ValidationUtil.regExValidateName((String)baseOutputFilename)) {
            errors.add((ValidationError)new ValidationErrorImpl("error.invalid.chars", null, null, "baseOutputFilename"));
        }
        if ((outputFormats = job.getOutputFormats()) == null || outputFormats.isEmpty()) {
            errors.add((ValidationError)new ValidationErrorImpl("error.report.job.no.output.formats", null, "No output formats are selected for the job.", "outputFormats"));
        }
        if (job.getContentRepositoryDestination() == null) {
            errors.add((ValidationError)new ValidationErrorImpl("error.report.job.no.repository.output", null, "Repository output is not defined for the job.", "contentRepositoryDestination"));
        } else {
            this.validateRepositoryDestination(errors, job.getContentRepositoryDestination());
        }
        ReportJobMailNotification mailNotification = job.getMailNotification();
        if (mailNotification != null && !mailNotification.isEmpty()) {
            this.validateMailNotification(errors, mailNotification);
        }
    }

    protected void validateRepositoryDestination(ValidationErrors errors, ReportJobRepositoryDestination repositoryDestination) {
        String folderURI = repositoryDestination.getFolderURI();
        if (this.checkString(errors, "contentRepositoryDestination.folderURI", folderURI, true, 200)) {
            this.validateFolderURI(errors, folderURI);
        }
        this.checkString(errors, "contentRepositoryDestination.outputDescription", repositoryDestination.getOutputDescription(), false, 250);
        this.validateTimestampPattern(errors, repositoryDestination);
    }

    protected void validateTimestampPattern(ValidationErrors errors, ReportJobRepositoryDestination repositoryDestination) {
        String pattern = repositoryDestination.getTimestampPattern();
        if (pattern != null && pattern.length() > 0) {
            boolean valid;
            try {
                new SimpleDateFormat(pattern);
                valid = PATTERN_TIMESTAMP_FORMAT.matcher(pattern).matches();
            }
            catch (IllegalArgumentException e) {
                valid = false;
            }
            if (!valid) {
                errors.add((ValidationError)new ValidationErrorImpl("error.pattern", null, "Specify a valid date pattern", "contentRepositoryDestination.timestampPattern"));
            }
        }
    }

    protected void validateFolderURI(ValidationErrors errors, String folderURI) {
        if (!this.getRepository().folderExists(null, folderURI)) {
            errors.add((ValidationError)new ValidationErrorImpl("error.report.job.output.folder.inexistent", new Object[]{folderURI}, null, "contentRepositoryDestination.folderURI"));
        } else if (SecurityContextHolder.getContext().getAuthentication() != null && !this.repositoryServiceSecurityChecker.isEditable((Resource)this.getRepository().getFolder(null, folderURI))) {
            errors.add((ValidationError)new ValidationErrorImpl("error.report.job.output.folder.notwriteable", new Object[]{folderURI}, null, "contentRepositoryDestination.folderURI"));
        }
    }

    protected void validateMailNotification(ValidationErrors errors, ReportJobMailNotification mailNotification) {
        this.checkString(errors, "mailNotification.subject", mailNotification.getSubject(), true, 100);
        this.checkString(errors, "mailNotification.messageText", mailNotification.getMessageText(), false, 2000);
        this.validateAddresses(errors, mailNotification);
    }

    protected void validateAddresses(ValidationErrors errors, ReportJobMailNotification mailNotification) {
        this.validateAddresses(errors, mailNotification.getToAddresses(), "mailNotification.toAddresses");
        this.validateAddresses(errors, mailNotification.getCcAddresses(), "mailNotification.ccAddresses");
        this.validateAddresses(errors, mailNotification.getBccAddresses(), "mailNotification.bccAddresses");
    }

    protected void validateAddresses(ValidationErrors errors, List addresses, String fieldName) {
        if (addresses != null && !addresses.isEmpty()) {
            for (String address : addresses) {
                if (this.emailPattern.matcher(address).matches()) continue;
                errors.add((ValidationError)new ValidationErrorImpl("error.invalid", new Object[]{address}, "Invalid email address " + address, fieldName));
            }
        }
    }

    protected boolean checkString(ValidationErrors errors, String field, String value, boolean mandatory, int maxLength) {
        boolean empty;
        boolean valid = true;
        boolean bl = empty = value == null || value.length() == 0;
        if (empty) {
            if (mandatory) {
                errors.add((ValidationError)new ValidationErrorImpl("error.not.empty", null, "The value cannot be empty", field));
                valid = false;
            }
        } else if (value.length() > maxLength) {
            errors.add((ValidationError)new ValidationErrorImpl("error.length", new Object[]{new Integer(maxLength)}, "Maximum length is {0,number,integer}.", field));
            valid = false;
        }
        return valid;
    }

    protected void addNotEmpty(ValidationErrors errors, String field) {
        errors.add((ValidationError)new ValidationErrorImpl("error.not.empty", null, "The value cannot be empty", field));
    }

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public Pattern getEmailPattern() {
        return this.emailPattern;
    }

    public void setEmailPattern(Pattern emailPattern) {
        this.emailPattern = emailPattern;
    }

    public RepositorySecurityChecker getRepositoryServiceSecurityChecker() {
        return this.repositoryServiceSecurityChecker;
    }

    public void setRepositoryServiceSecurityChecker(RepositorySecurityChecker repositoryServiceSecurityChecker) {
        this.repositoryServiceSecurityChecker = repositoryServiceSecurityChecker;
    }

    static {
        String allPattern = "(\\*)";
        String minPattern = "(\\d|[0-5]\\d)";
        String minRangePattern = "(" + minPattern + "(\\-" + minPattern + ")?)";
        String minuteIncrementPattern = "(" + minPattern + "\\/\\d+)";
        PATTERN_CRON_MINUTES = Pattern.compile("^(" + minRangePattern + "(," + minRangePattern + ")*)|" + minuteIncrementPattern + "|" + allPattern + "$");
        String hourPattern = "(\\d|[01]\\d|2[0-3])";
        String hourRangePattern = "(" + hourPattern + "(\\-" + hourPattern + ")?)";
        String hourIncrementPattern = "(" + hourPattern + "\\/\\d+)";
        PATTERN_CRON_HOURS = Pattern.compile("^(" + hourRangePattern + "(," + hourRangePattern + ")*)|" + hourIncrementPattern + "|" + allPattern + "$");
        String dayPattern = "([1-9]|[012]\\d|3[01])";
        String dayRangePattern = "(" + dayPattern + "(\\-" + dayPattern + ")?)";
        String dayIncrementPattern = "(" + dayPattern + "\\/\\d+)";
        PATTERN_CRON_MONTH_DAYS = Pattern.compile("^(" + dayRangePattern + "(," + dayRangePattern + ")*)|" + dayIncrementPattern + "|" + allPattern + "$");
        PATTERN_TIMESTAMP_FORMAT = Pattern.compile("(\\p{L}|\\p{N}|(\\_)|(\\.)|(\\-))+");
    }
}

