/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import com.jaspersoft.jasperserver.api.engine.jasperreports.util.JarFileEntry;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;

public class JarConnection
extends URLConnection {
    private static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss 'GMT'");
    private final JarFileEntry entry;

    public JarConnection(URL url, JarFileEntry entry) {
        super(url);
        this.entry = entry;
    }

    public void connect() throws IOException {
        this.connected = true;
    }

    public InputStream getInputStream() throws IOException {
        return this.entry.getInputStream();
    }

    public int getContentLength() {
        return (int)this.entry.getSize();
    }

    public long getLastModified() {
        return this.entry.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHeaderField(String field) {
        String header = null;
        if (field.equals("content-length")) {
            header = Long.toString(this.entry.getSize());
        } else if (field.equals("last-modified")) {
            SimpleDateFormat simpleDateFormat = DATE_FORMAT;
            synchronized (simpleDateFormat) {
                header = DATE_FORMAT.format(new Date(this.entry.getTime()));
            }
        }
        return header;
    }
}

