/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.CustomDataSourceDefinition;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.CustomReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceServiceFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class CustomReportDataSourceServiceFactory
implements ReportDataSourceServiceFactory,
ApplicationContextAware {
    public static final String PROPERTY_MAP = "propertyMap";
    ApplicationContext ctx;
    private List customDataSourceDefs = new ArrayList();

    public void setApplicationContext(ApplicationContext arg0) throws BeansException {
        this.ctx = arg0;
    }

    public ReportDataSourceService createService(ReportDataSource reportDataSource) {
        ReportDataSourceService service;
        if (!(reportDataSource instanceof CustomReportDataSource)) {
            throw new JSException("jsexception.invalid.custom.datasource", new Object[]{reportDataSource.getClass()});
        }
        CustomReportDataSource customDataSource = (CustomReportDataSource)reportDataSource;
        String serviceClassName = customDataSource.getServiceClass();
        try {
            Class<?> serviceClass = Class.forName(serviceClassName);
            service = (ReportDataSourceService)serviceClass.newInstance();
        }
        catch (Exception e) {
            JSException ex = new JSException("jsexception.creating.custom.datasource", (Throwable)e);
            ex.setArgs(new Object[]{serviceClassName});
            throw ex;
        }
        try {
            BeanWrapperImpl bw = new BeanWrapperImpl((Object)service);
            CustomDataSourceDefinition def = this.getDefinitionByServiceClass(serviceClassName);
            HashMap propMap = new HashMap();
            for (Map pd : def.getPropertyDefinitions()) {
                String name = (String)pd.get("name");
                Object deflt = pd.get("default");
                Object value = customDataSource.getPropertyMap().get(name);
                if (value == null && deflt != null) {
                    value = deflt;
                }
                if (value == null) continue;
                if (bw.isWritableProperty(name)) {
                    bw.setPropertyValue(name, value);
                }
                propMap.put(name, value);
            }
            if (bw.isWritableProperty(PROPERTY_MAP)) {
                bw.setPropertyValue(PROPERTY_MAP, propMap);
            }
        }
        catch (Exception e) {
            JSException ex = new JSException("jsexception.setting.custom.datasource.props", (Throwable)e);
            ex.setArgs(new Object[]{serviceClassName});
            throw ex;
        }
        return service;
    }

    public void addDefinition(CustomDataSourceDefinition def) {
        this.customDataSourceDefs.add(def);
    }

    public List getDefinitions() {
        return this.customDataSourceDefs;
    }

    public CustomDataSourceDefinition getDefinitionByServiceClass(String serviceClass) {
        for (CustomDataSourceDefinition cds : this.getDefinitions()) {
            if (!cds.getServiceClassName().equals(serviceClass)) continue;
            return cds;
        }
        return null;
    }

    public CustomDataSourceDefinition getDefinitionByName(String name) {
        for (CustomDataSourceDefinition cds : this.getDefinitions()) {
            if (!cds.getName().equals(name)) continue;
            return cds;
        }
        return null;
    }
}

