/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.ws.axis2.repository;

import com.jaspersoft.jasperserver.api.common.domain.ValidationErrorFilter;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrors;
import com.jaspersoft.jasperserver.api.common.domain.impl.UniversalValidationErrorFilter;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.OperationResult;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.ws.axis2.RepositoryServiceContext;
import com.jaspersoft.jasperserver.ws.axis2.ResourceActionResolver;
import com.jaspersoft.jasperserver.ws.axis2.ResourceHandler;
import com.jaspersoft.jasperserver.ws.axis2.ResourceResolverAdapter;
import com.jaspersoft.jasperserver.ws.axis2.ResultAttachments;
import com.jaspersoft.jasperserver.ws.axis2.ServiceRequest;
import com.jaspersoft.jasperserver.ws.axis2.WSException;
import com.jaspersoft.jasperserver.ws.axis2.WSValidationException;
import com.jaspersoft.jasperserver.ws.axis2.repository.SubResourceHandler;
import com.jaspersoft.jasperserver.ws.axis2.util.ResourceUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class RepositoryResourceHandler
implements ResourceHandler,
ResourceResolverAdapter {
    protected static final String OBJECT_NAME = "resource";
    private static final Log log = LogFactory.getLog(RepositoryResourceHandler.class);
    private ResourceActionResolver resourceActionResolver;

    public void setResourceActionHandler(ResourceActionResolver resourceActionResolver) {
        this.resourceActionResolver = resourceActionResolver;
    }

    public ResourceDescriptor describe(Resource resource, Map arguments, RepositoryServiceContext serviceContext) throws WSException {
        ResourceDescriptor descriptor = new ResourceDescriptor();
        this.setCommonAttributes(resource, descriptor);
        this.doDescribe(resource, descriptor, arguments, serviceContext);
        return descriptor;
    }

    protected void setCommonAttributes(Resource resource, ResourceDescriptor descriptor) {
        descriptor.setUriString(resource.getURIString());
        descriptor.setDescription(resource.getDescription());
        descriptor.setLabel(resource.getLabel());
        descriptor.setName(resource.getName());
        descriptor.setResourceType(resource.getResourceType());
        descriptor.setParentFolder(resource.getParentFolder());
        descriptor.setVersion(resource.getVersion());
        descriptor.setCreationDate(resource.getCreationDate());
    }

    protected abstract void doDescribe(Resource var1, ResourceDescriptor var2, Map var3, RepositoryServiceContext var4) throws WSException;

    protected void saveValidated(RepositoryService repository, Resource resource, RepositoryServiceContext serviceContext) throws WSException {
        Object filter = resource.isNew() ? UniversalValidationErrorFilter.getInstance() : null;
        ValidationErrors errors = repository.validateResource(null, resource, (ValidationErrorFilter)filter);
        if (errors.isError()) {
            throw new WSValidationException(this.getObjectName(), errors);
        }
        if (!this.resourceActionResolver.canCreateResource(resource.getParentFolder())) {
            throw new WSException(1, serviceContext.getMessage("webservices.error.cannotCreateResource", new String[]{resource.getParentFolder()}));
        }
        repository.saveResource(null, resource);
    }

    protected String getObjectName() {
        return OBJECT_NAME;
    }

    public void put(ServiceRequest request) throws WSException {
        ResourceDescriptor descriptor = request.getRequestDescriptor();
        RepositoryServiceContext context = request.getContext();
        RepositoryService repository = context.getRepository();
        OperationResult result = request.getResult();
        Resource parentResource = this.getModifyingParentResource(request);
        if (descriptor.getIsNew()) {
            if (parentResource == null) {
                Resource resource = this.toNewResource(descriptor, context);
                this.saveValidated(repository, resource, context);
                result.getResourceDescriptors().add(context.createResourceDescriptor(resource.getURIString()));
            } else {
                SubResourceHandler parentHandler = (SubResourceHandler)context.getHandlerRegistry().getHandler(parentResource);
                Resource subResource = parentHandler.setSubResource(parentResource, request);
                if (subResource != null) {
                    this.saveValidated(repository, parentResource, context);
                    result.getResourceDescriptors().add(context.createResourceDescriptor(subResource));
                }
            }
        } else if (parentResource == null) {
            log.debug((Object)("Put: modifying " + descriptor.getWsType()));
            Class resourceType = this.getResourceType();
            Resource resource = repository.getResource(null, descriptor.getUriString(), resourceType);
            if (resource == null) {
                result.setReturnCode(2);
                result.setMessage(context.getMessage("webservices.error.resourceNotFound", null));
            } else {
                this.copyToResource(resource, descriptor, context);
                this.saveValidated(repository, resource, context);
                result.getResourceDescriptors().add(context.createResourceDescriptor(resource));
            }
        } else {
            SubResourceHandler parentHandler = (SubResourceHandler)context.getHandlerRegistry().getHandler(parentResource);
            Resource subResource = parentHandler.setSubResource(parentResource, request);
            if (subResource != null) {
                this.saveValidated(repository, parentResource, context);
                HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                options.put("ReportUnitContents", Boolean.TRUE);
                result.getResourceDescriptors().add(context.createResourceDescriptor(parentResource, options));
            }
        }
    }

    protected Resource getModifyingParentResource(ServiceRequest request) throws WSException {
        ReportUnit resource = null;
        String reportUnitUrl = request.getRequestArgument("MODIFY_REPORTUNIT_URI");
        if (reportUnitUrl != null && reportUnitUrl.length() > 0) {
            log.debug((Object)("Put: adding/modifying resource in reportUnit " + reportUnitUrl));
            ReportUnit reportUnit = (ReportUnit)request.getContext().getRepository().getResource(null, reportUnitUrl);
            if (reportUnit == null) {
                throw new WSException(3, request.getContext().getMessage("webservices.error.reportUnitNotFound", null));
            }
            resource = reportUnit;
        }
        return resource;
    }

    protected Resource toNewResource(ResourceDescriptor descriptor, RepositoryServiceContext serviceContext) throws WSException {
        Class resourceType = this.getResourceType();
        Resource resource = serviceContext.getRepository().newResource(null, resourceType);
        resource.setParentFolder(descriptor.getParentFolder());
        resource.setVersion(-1);
        resource.setName(descriptor.getName());
        this.copyToResource(resource, descriptor, serviceContext);
        return resource;
    }

    public void copyToResource(Resource resource, ResourceDescriptor descriptor, RepositoryServiceContext serviceContext) throws WSException {
        resource.setLabel(descriptor.getLabel());
        resource.setDescription(descriptor.getDescription());
        this.updateResource(resource, descriptor, serviceContext);
    }

    protected abstract void updateResource(Resource var1, ResourceDescriptor var2, RepositoryServiceContext var3) throws WSException;

    protected Resource toChildResource(ResourceDescriptor descriptor, RepositoryServiceContext context) throws WSException {
        String childType = descriptor.getWsType();
        RepositoryResourceHandler childHandler = (RepositoryResourceHandler)context.getHandlerRegistry().getHandler(childType);
        return childHandler.toNewResource(descriptor, context);
    }

    public void getAttachments(Resource resource, Map arguments, ResourceDescriptor descriptor, ResultAttachments attachments, RepositoryServiceContext serviceContext) {
    }

    public void delete(ResourceDescriptor descriptor, RepositoryServiceContext serviceContext) throws WSException {
        if (!this.resourceActionResolver.isResourceDeletable(descriptor.getUriString())) {
            throw new WSException(1, serviceContext.getMessage("webservices.error.notDeletableResource", null));
        }
        serviceContext.getRepository().deleteResource(null, descriptor.getUriString());
    }

    public void move(Request request, RepositoryServiceContext serviceContext) throws WSException {
        String sourceURI = request.getResourceDescriptor().getUriString();
        String destinationURI = this.getDestinationURI(request, serviceContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Moving resource " + sourceURI + " to folder " + destinationURI));
        }
        if (!this.resourceActionResolver.canCreateResource(destinationURI)) {
            throw new WSException(1, serviceContext.getMessage("webservices.error.cannotCreateResource", new String[]{destinationURI}));
        }
        serviceContext.getRepository().moveResource(null, sourceURI, destinationURI);
    }

    public ResourceDescriptor copy(Request request, RepositoryServiceContext serviceContext) throws WSException {
        String sourceURI = request.getResourceDescriptor().getUriString();
        String destinationURI = this.getDestinationURI(request, serviceContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Copying resource " + sourceURI + " to URI " + destinationURI));
        }
        if (!this.resourceActionResolver.canCreateResource(ResourceUtils.getParentFolder(destinationURI))) {
            throw new WSException(1, serviceContext.getMessage("webservices.error.cannotCreateResource", new String[]{ResourceUtils.getParentFolder(destinationURI)}));
        }
        Resource copy = serviceContext.getRepository().copyResource(null, sourceURI, destinationURI);
        return this.describe(copy, this.getDefaultDescribeArguments(), serviceContext);
    }

    protected Map getDefaultDescribeArguments() {
        return null;
    }

    protected String getDestinationURI(Request request, RepositoryServiceContext serviceContext) throws WSException {
        String destinationURI = request.getArgumentValue("DESTINATION_URI");
        if (destinationURI == null) {
            throw new WSException(6, serviceContext.getMessage("webservices.error.request.no.destination.URI", null));
        }
        return destinationURI;
    }

    public List listResources(Request request, RepositoryServiceContext serviceContext) throws WSException {
        ArrayList<ResourceDescriptor> descriptors;
        List resources;
        Class resourceType = this.getResourceType();
        String parentFolder = request.getArgumentValue("PARENT_DIRECTORY");
        String ancestorFolder = request.getArgumentValue("START_FROM_DIRECTORY");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Listing resources of type " + resourceType + (parentFolder != null ? "from folder " + parentFolder : (ancestorFolder != null ? " starting from folder " + ancestorFolder : ""))));
        }
        FilterCriteria filter = FilterCriteria.createFilter((Class)resourceType);
        if (parentFolder != null) {
            filter.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)parentFolder));
        } else if (ancestorFolder != null && !"/".equals(ancestorFolder)) {
            filter.addFilterElement((FilterElement)FilterCriteria.createAncestorFolderFilter((String)ancestorFolder));
        }
        FilterElement additionalCriteria = this.additionalListResourcesFilterCriteria(request);
        if (additionalCriteria != null) {
            filter.addFilterElement(additionalCriteria);
        }
        if ((resources = serviceContext.getRepository().loadClientResources(filter)) == null || resources.isEmpty()) {
            descriptors = new ArrayList<ResourceDescriptor>(0);
        } else {
            descriptors = new ArrayList(resources.size());
            for (Resource resource : resources) {
                descriptors.add(serviceContext.createResourceDescriptor(resource));
            }
        }
        return descriptors;
    }

    protected FilterElement additionalListResourcesFilterCriteria(Request request) {
        return null;
    }
}

