/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.ws.axis2;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.util.LocaleHelper;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.common.PdfExportParametersBean;
import com.jaspersoft.jasperserver.ws.axis2.WSExporter;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;

public class PdfWSExporter
implements WSExporter {
    PdfExportParametersBean exportParams;

    public Map exportReport(JasperPrint jasperPrint, OutputStream output, EngineService engineService, HashMap exportParameters, ExecutionContext executionContext, String reportUnitURI) throws Exception {
        exportParameters.put(JRExporterParameter.JASPER_PRINT, jasperPrint);
        exportParameters.put(JRExporterParameter.OUTPUT_STREAM, output);
        if (this.exportParams != null) {
            String printLocaleCode = jasperPrint.getLocaleCode();
            Locale printLocale = LocaleHelper.getInstance().getLocale(printLocaleCode);
            Map fontMap = this.exportParams.getFontMap(printLocale);
            if (fontMap != null) {
                exportParameters.put(JRExporterParameter.FONT_MAP, fontMap);
            }
        }
        engineService.exportToPdf(executionContext, reportUnitURI, (Map)exportParameters);
        return exportParameters;
    }

    public PdfExportParametersBean getExportParams() {
        return this.exportParams;
    }

    public void setExportParams(PdfExportParametersBean exportParams) {
        this.exportParams = exportParams;
    }
}

