/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.util.test;

import com.jaspersoft.jasperserver.export.Parameters;
import com.jaspersoft.jasperserver.util.test.BaseExportTestCase;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SampleDataImportTest
extends BaseExportTestCase {
    protected static Log log = LogFactory.getLog(SampleDataImportTest.class);

    public SampleDataImportTest(String name) {
        super(name);
    }

    public void testDemoSampleImport() throws Exception {
        File importDirFile = new File("target" + FILE_SEPARATOR + "test-classes" + FILE_SEPARATOR + "exportedResources");
        File[] files = importDirFile.listFiles();
        if (files != null) {
            for (File f : files) {
                Parameters importParams = this.createParameters();
                try {
                    if (f.isDirectory()) {
                        importParams.addParameterValue("input-dir", f.toString());
                        log.info((Object)("processing directory: " + f));
                    } else if (f.getName().endsWith(".zip")) {
                        importParams.addParameterValue("input-zip", f.toString());
                        log.info((Object)("processing zip: " + f));
                    } else {
                        log.info((Object)("skipping file: " + f));
                    }
                    if (!importParams.getParameterNames().hasNext()) continue;
                    this.performImport(importParams);
                }
                catch (Exception e) {
                    log.error((Object)("Error importing file " + f), (Throwable)e);
                    throw e;
                }
            }
        } else {
            log.warn((Object)("no files in: " + importDirFile));
        }
    }
}

