/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.util.test;

import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianXMLADefinition;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapUnit;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.XMLAConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.service.OlapConnectionService;
import com.jaspersoft.jasperserver.export.Parameters;
import com.jaspersoft.jasperserver.util.test.BaseExportTestCase;
import java.io.InputStream;
import junit.textui.TestRunner;

public class ExportOlapTest
extends BaseExportTestCase {
    static final String PATH_SEP = "/";
    static final String LABEL = "_label";
    static final String DESC = "_description";
    static final String DESC_TEXT = " for export-import testing";
    protected final String foodMartSchemaURI = "/queries/Foodmart.xml";
    protected final String sugarCRMSchemaURI = "/reports/jasper/SugarCRMOpps.xml";
    final String OLAP_FOLDER = "test_olap_05";
    final String OLAP_REPORT_NAME = "OlapSugarMondrianView";
    private OlapConnectionService olapConnectionService;
    private String SAMPLE_SUGAR_CRM_MDX_QUERY = "select {[Measures].[Total Sale Amount], [Measures].[Number of Sales], [Measures].[Avg Sale Amount], [Measures].[Avg Time To Close (Days)], [Measures].[Avg Close Probablility]} ON COLUMNS,  NON EMPTY {([Account Categorization].[All Accounts], [Close Period].[All Periods])} ON ROWS  from [SalesAnalysis]  where [Sale State].[All Types].[Closed Won]";

    public ExportOlapTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(ExportOlapTest.class);
    }

    public void onSetUp() throws Exception {
        super.onSetUp();
    }

    public void onTearDown() throws Exception {
        super.onTearDown();
    }

    public void testOlapView() throws Exception {
        this.basicAuthSetup();
        this.createOlapConnectionSimpleResources();
        String exportDir = this.createExportDir();
        Parameters exportParams = this.createParameters().addParameterValue("output-dir", exportDir).addParameterValue("uris", "/test_olap_05/OlapSugarMondrianView");
        this.performExport(exportParams);
        this.deleteOlapConnectionSimpleResources();
        OlapUnit ou_null = (OlapUnit)this.getRepositoryService().getResource(null, "/test_olap_05/OlapSugarMondrianView");
        ExportOlapTest.assertNull((Object)ou_null);
        Parameters importParams = this.createParameters().addParameterValue("input-dir", exportDir);
        this.performImport(importParams);
        OlapUnit unit = (OlapUnit)this.getRepositoryService().getResource(null, "/test_olap_05/OlapSugarMondrianView");
        ExportOlapTest.assertNotNull((Object)unit);
        this.deleteOlapConnectionSimpleResources();
    }

    protected void createOlapConnectionSimpleResources() throws Exception {
        Folder folder = this.getRepositoryService().getFolder(null, "/test_olap_05");
        if (folder != null) {
            this.getRepositoryService().deleteFolder(null, "/test_olap_05");
        }
        folder = new FolderImpl();
        folder.setName("test_olap_05");
        folder.setLabel("test_olap_05_label");
        folder.setDescription("test_olap_05_description");
        folder.setParentFolder(PATH_SEP);
        this.getRepositoryService().saveFolder(null, folder);
        FileResource schema = (FileResource)this.getRepositoryService().newResource(null, FileResource.class);
        schema.setName("SugarCRMSchema");
        schema.setLabel("SugarCRM Opportunities DataMart");
        schema.setDescription("SugarCRM Opportunities Data Mart Schema");
        schema.setFileType("olapMondrianSchema");
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/SugarCRMOpps.xml");
        schema.readData(in);
        this.getOlapConnectionService().saveResource(null, "/test_olap_05/", (Resource)schema);
        JdbcReportDataSource ds = (JdbcReportDataSource)this.getRepositoryService().newResource(null, JdbcReportDataSource.class);
        ds.setName("SugarCRMDataSource");
        ds.setLabel("SugarCRM Data Source");
        ds.setDescription("SugarCRM Data Source");
        ds.setDriverClass(this.getJdbcProps().getProperty("test.jdbc.driverClassName"));
        ds.setConnectionUrl(this.getJdbcProps().getProperty("test.jdbc.url"));
        ds.setUsername(this.getJdbcProps().getProperty("test.jdbc.username"));
        ds.setPassword(this.getJdbcProps().getProperty("test.jdbc.password"));
        this.getOlapConnectionService().saveResource(null, "/test_olap_05/", (Resource)ds);
        MondrianConnection mondConn = (MondrianConnection)this.getRepositoryService().newResource(null, MondrianConnection.class);
        mondConn.setName("SugarCRM");
        mondConn.setLabel("SugarCRM OLAP Connection");
        mondConn.setDescription("SugarCRM OLAP Connection: only opportunities");
        mondConn.setSchemaReference("/test_olap_05/SugarCRMSchema");
        mondConn.setDataSourceReference("/test_olap_05/SugarCRMDataSource");
        this.getOlapConnectionService().saveResource(null, "/test_olap_05/", (Resource)mondConn);
        XMLAConnection xmlaConn = (XMLAConnection)this.getRepositoryService().newResource(null, XMLAConnection.class);
        xmlaConn.setName("SugarCRMXmlaConnection");
        xmlaConn.setLabel("SugarCRM XML/A Connection");
        xmlaConn.setDescription("SugarCRM XML/A Connection");
        xmlaConn.setCatalog("SugarCRM");
        xmlaConn.setDataSource("Provider=Mondrian;DataSource=SugarCRM;");
        xmlaConn.setURI("http://localhost:8080/jasperserver/xmla");
        xmlaConn.setUsername("jasperadmin");
        xmlaConn.setPassword("jasperadmin");
        this.getOlapConnectionService().saveResource(null, "/test_olap_05/", (Resource)xmlaConn);
        MondrianXMLADefinition def = (MondrianXMLADefinition)this.getRepositoryService().newResource(null, MondrianXMLADefinition.class);
        def.setName("SugarCRMXmlaDefinition");
        def.setLabel("SugarCRM XMLA Connection");
        def.setDescription("SugarCRM XMLA Connection");
        def.setCatalog("SugarCRM");
        def.setMondrianConnectionReference("/test_olap_05/SugarCRM");
        this.getOlapConnectionService().saveResource(null, "/test_olap_05/", (Resource)def);
        OlapUnit view = (OlapUnit)this.getRepositoryService().newResource(null, OlapUnit.class);
        view.setName("OlapSugarMondrianView");
        view.setLabel("SugarCRM sample unit 1");
        view.setDescription("SugarCRM Sample Olap Unit 1: Sales Performance by Industry/Account");
        view.setOlapClientConnectionReference("/test_olap_05/SugarCRM");
        view.setMdxQuery(this.SAMPLE_SUGAR_CRM_MDX_QUERY);
        this.getOlapConnectionService().saveResource(null, "/test_olap_05/", (Resource)view);
    }

    protected void deleteOlapConnectionSimpleResources() {
        this.getRepositoryService().deleteFolder(null, "/test_olap_05");
    }

    public OlapConnectionService getOlapConnectionService() {
        return this.olapConnectionService;
    }

    public void setOlapConnectionService(OlapConnectionService olapConnectionService) {
        this.olapConnectionService = olapConnectionService;
    }
}

