/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.view.service.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValues;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValuesItem;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Query;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.DataTypeImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.ListOfValuesItemImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.BeanReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.security.JasperServerAclEntry;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElementDisjunction;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElementOr;
import com.jaspersoft.jasperserver.api.search.TransformerFactory;
import com.jaspersoft.jasperserver.search.filter.FolderFilter;
import com.jaspersoft.jasperserver.search.transformer.BasicTransformerFactory;
import com.jaspersoft.jasperserver.util.test.BaseJasperServerTest;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.security.Authentication;

public class HibernateRepositoryTest
extends BaseJasperServerTest {
    User user;
    Role role;
    Authentication auth;

    public HibernateRepositoryTest(String name) {
        super(name);
        this.setAutowireMode(1);
    }

    public void testDeleteFolder() {
        RepositoryService repositoryService = this.getUnsecureRepositoryService();
        HibernateRepositoryTest.assertNotNull((String)"Repository service should not be null", (Object)repositoryService);
        FolderImpl tmpFolder = new FolderImpl();
        this.setCommon((Resource)tmpFolder, "tmp_foo");
        repositoryService.saveFolder(null, (Folder)tmpFolder);
        FolderImpl subtmpFolder = new FolderImpl();
        this.setCommon((Resource)subtmpFolder, "sub");
        subtmpFolder.setParentFolder((Folder)tmpFolder);
        repositoryService.saveFolder(null, (Folder)subtmpFolder);
        JndiJdbcReportDataSource ds = (JndiJdbcReportDataSource)repositoryService.newResource(null, JndiJdbcReportDataSource.class);
        this.setCommon((Resource)ds, "dummyDS");
        ds.setJndiName("foo");
        ds.setParentFolder((Folder)tmpFolder);
        repositoryService.saveResource(null, (Resource)ds);
        JndiJdbcReportDataSource subds = (JndiJdbcReportDataSource)repositoryService.newResource(null, JndiJdbcReportDataSource.class);
        this.setCommon((Resource)subds, "subDS");
        subds.setJndiName("subfoo");
        subds.setParentFolder((Folder)subtmpFolder);
        repositoryService.saveResource(null, (Resource)subds);
        Resource dsResource = repositoryService.getResource(null, "/tmp_foo/dummyDS");
        HibernateRepositoryTest.assertNotNull((Object)dsResource);
        HibernateRepositoryTest.assertTrue((boolean)(dsResource instanceof JndiJdbcReportDataSource));
        ds = (JndiJdbcReportDataSource)dsResource;
        HibernateRepositoryTest.assertEquals((String)"foo", (String)ds.getJndiName());
        Resource subdsResource = repositoryService.getResource(null, "/tmp_foo/sub/subDS");
        HibernateRepositoryTest.assertNotNull((Object)subdsResource);
        HibernateRepositoryTest.assertTrue((boolean)(subdsResource instanceof JndiJdbcReportDataSource));
        subds = (JndiJdbcReportDataSource)subdsResource;
        HibernateRepositoryTest.assertEquals((String)"subfoo", (String)subds.getJndiName());
        repositoryService.deleteFolder(null, "/tmp_foo");
        List folders = repositoryService.getSubFolders(null, "/");
        for (Folder folder : folders) {
            HibernateRepositoryTest.assertFalse((boolean)"tmp_foo".equals(folder.getName()));
        }
        dsResource = repositoryService.getResource(null, "/tmp_foo/dummyDS");
        HibernateRepositoryTest.assertNull((Object)dsResource);
        subdsResource = repositoryService.getResource(null, "/tmp_foo/dummyDS");
        HibernateRepositoryTest.assertNull((Object)subdsResource);
    }

    public void testDeleteRollback() {
        RepositoryService repositoryService = this.getUnsecureRepositoryService();
        HibernateRepositoryTest.assertNotNull((String)"Repository service should not be null", (Object)repositoryService);
        FolderImpl tmp1 = new FolderImpl();
        this.setCommon((Resource)tmp1, "tmp1");
        repositoryService.saveFolder(null, (Folder)tmp1);
        FolderImpl tmp2 = new FolderImpl();
        this.setCommon((Resource)tmp2, "tmp2");
        repositoryService.saveFolder(null, (Folder)tmp2);
        tmp1 = repositoryService.getFolder(null, "/tmp1");
        HibernateRepositoryTest.assertNotNull((Object)tmp1);
        HibernateRepositoryTest.assertEquals((String)"tmp1", (String)tmp1.getName());
        tmp2 = repositoryService.getFolder(null, "/tmp2");
        HibernateRepositoryTest.assertNotNull((Object)tmp2);
        HibernateRepositoryTest.assertEquals((String)"tmp2", (String)tmp2.getName());
        ExecutionContextImpl executionContext = new ExecutionContextImpl();
        repositoryService.deleteFolder((ExecutionContext)executionContext, "/tmp1");
        repositoryService.deleteFolder((ExecutionContext)executionContext, "/tmp2");
        tmp1 = repositoryService.getFolder(null, "/tmp1");
        HibernateRepositoryTest.assertNull((Object)tmp1);
        tmp2 = repositoryService.getFolder(null, "/tmp2");
        HibernateRepositoryTest.assertNull((Object)tmp2);
    }

    public void testFolderUpdate() {
        HibernateRepositoryTest.assertNotNull((String)"Repo not null", (Object)this.getUnsecureRepositoryService());
        this.user = this.findOrCreateUser("jasperadmin");
        this.auth = this.setAuthenticatedUser("jasperadmin");
        FolderImpl folder = new FolderImpl();
        this.setCommon((Resource)folder, "test_update");
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)folder);
        JndiJdbcReportDataSource ds = (JndiJdbcReportDataSource)this.getUnsecureRepositoryService().newResource(null, JndiJdbcReportDataSource.class);
        this.setCommon((Resource)ds, "fooDS");
        ds.setJndiName("foo");
        ds.setParentFolder((Folder)folder);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)ds);
        folder = this.getUnsecureRepositoryService().getFolder(null, "/test_update");
        HibernateRepositoryTest.assertNotNull((Object)folder);
        HibernateRepositoryTest.assertEquals((String)"test_update", (String)folder.getName());
        HibernateRepositoryTest.assertEquals((String)"test_update_label", (String)folder.getLabel());
        folder.setLabel("updated");
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)folder);
        folder = this.getUnsecureRepositoryService().getFolder(null, "/test_update");
        HibernateRepositoryTest.assertNotNull((Object)folder);
        HibernateRepositoryTest.assertEquals((String)"test_update", (String)folder.getName());
        HibernateRepositoryTest.assertEquals((String)"updated", (String)folder.getLabel());
        Resource resource = this.getUnsecureRepositoryService().getResource(null, "/test_update/fooDS");
        HibernateRepositoryTest.assertNotNull((Object)resource);
        HibernateRepositoryTest.assertTrue((boolean)(resource instanceof JndiJdbcReportDataSource));
        ds = (JndiJdbcReportDataSource)resource;
        HibernateRepositoryTest.assertEquals((String)"fooDS", (String)ds.getName());
        HibernateRepositoryTest.assertEquals((String)"foo", (String)ds.getJndiName());
        this.getUnsecureRepositoryService().deleteFolder(null, "/test_update");
        folder = this.getUnsecureRepositoryService().getFolder(null, "/test_update");
        HibernateRepositoryTest.assertNull((Object)folder);
    }

    public void testRepo() throws Exception {
        HibernateRepositoryTest.assertNotNull((String)"Repo not null", (Object)this.getUnsecureRepositoryService());
        this.write();
        this.read();
        this.readFolders();
        this.update();
        this.optimisticLocking();
        this.list();
        this.resources();
        this.setupExecuteOnlyPerms();
    }

    private void deleteRollback() {
        boolean exception = false;
        try {
            this.getUnsecureRepositoryService().delete(null, new String[]{"/datasources/JServerJdbcDS"}, null);
        }
        catch (Exception e) {
            exception = true;
        }
        HibernateRepositoryTest.assertTrue((boolean)exception);
        Resource resource = this.getUnsecureRepositoryService().getResource(null, "/datasources/JServerJdbcDS");
        HibernateRepositoryTest.assertNotNull((Object)resource);
        HibernateRepositoryTest.assertTrue((boolean)(resource instanceof JdbcReportDataSource));
    }

    private void write() throws Exception {
        FolderImpl dsFolder = new FolderImpl();
        dsFolder.setName("datasources");
        dsFolder.setLabel("Data Sources");
        dsFolder.setDescription("Data Sources used by reports");
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)dsFolder);
        this.createJndiDS();
        this.createRepoDS();
        this.createJdbcDS();
        this.createBeanDS();
        this.createTableModelDS();
        FolderImpl reportsFolder = new FolderImpl();
        reportsFolder.setName("reports");
        reportsFolder.setLabel("Reports");
        reportsFolder.setDescription("Reports");
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)reportsFolder);
        Role userRole = this.getOrCreateRole(userRoleName);
        this.createObjectPermission("/reports", (Object)userRole, JasperServerAclEntry.READ_WRITE_CREATE_DELETE);
        FolderImpl samplesFolder = new FolderImpl();
        samplesFolder.setName("samples");
        samplesFolder.setLabel("Samples");
        samplesFolder.setDescription("Samples");
        samplesFolder.setParentFolder((Folder)reportsFolder);
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)samplesFolder);
        this.createAllAccounts((Folder)samplesFolder);
        this.createSalesByMonth((Folder)samplesFolder);
        this.createCustomDSReportFileResource((Folder)samplesFolder);
        this.createCustomDSReport((Folder)samplesFolder);
        this.createTableModelDSReport((Folder)samplesFolder);
        this.createEmployeeAccounts((Folder)samplesFolder);
        this.createEmployees((Folder)samplesFolder);
        this.createParamMany((Folder)samplesFolder);
        this.createAllCharts((Folder)samplesFolder);
        this.createAllCascading((Folder)samplesFolder);
        this.createOFCReport((Folder)samplesFolder);
        this.createImage();
        FolderImpl olapFolder = new FolderImpl();
        olapFolder.setName("analysis");
        olapFolder.setLabel("Analysis Components");
        olapFolder.setDescription("Analysis Components");
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)olapFolder);
        FolderImpl connectionsFolder = new FolderImpl();
        connectionsFolder.setName("connections");
        connectionsFolder.setLabel("Analysis Connections");
        connectionsFolder.setDescription("Connections used by Analysis");
        connectionsFolder.setParentFolder((Folder)olapFolder);
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)connectionsFolder);
        FolderImpl schemasFolder = new FolderImpl();
        schemasFolder.setName("schemas");
        schemasFolder.setLabel("Analysis Schemas");
        schemasFolder.setDescription("Schemas used by Analysis");
        schemasFolder.setParentFolder((Folder)olapFolder);
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)schemasFolder);
        FolderImpl olapDsFolder = new FolderImpl();
        olapDsFolder.setName("datasources");
        olapDsFolder.setLabel("Analysis Data Sources");
        olapDsFolder.setDescription("Data sources used by Analysis");
        olapDsFolder.setParentFolder((Folder)olapFolder);
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)olapDsFolder);
        FolderImpl olapViewsFolder = new FolderImpl();
        olapViewsFolder.setName("views");
        olapViewsFolder.setLabel("Analysis Views");
        olapViewsFolder.setDescription("Analysis Views");
        olapViewsFolder.setParentFolder((Folder)olapFolder);
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)olapViewsFolder);
    }

    private void createImage() {
        FolderImpl folder = new FolderImpl();
        folder.setName("images");
        folder.setLabel("Images");
        folder.setDescription("Folder containing reusable images");
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)folder);
        FileResource image = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        image.setFileType("img");
        image.readData(((Object)((Object)this)).getClass().getResourceAsStream("/images/jasperreports.png"));
        image.setName("JRLogo");
        image.setLabel("JR logo");
        image.setDescription("JR logo");
        image.setParentFolder((Folder)folder);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)image);
    }

    private void createJndiDS() throws Exception {
        JndiJdbcReportDataSource datasource = (JndiJdbcReportDataSource)this.getUnsecureRepositoryService().newResource(null, JndiJdbcReportDataSource.class);
        datasource.setName("JServerJNDIDS");
        datasource.setLabel("JServer JNDI Data Source");
        datasource.setDescription("JServer JNDI Data Source");
        datasource.setJndiName(this.getJdbcProps().getProperty("test.jndi"));
        datasource.setParentFolder("/datasources");
        this.getUnsecureRepositoryService().saveResource(null, (Resource)datasource);
    }

    private void createRepoDS() throws Exception {
        JndiJdbcReportDataSource datasource = (JndiJdbcReportDataSource)this.getUnsecureRepositoryService().newResource(null, JndiJdbcReportDataSource.class);
        datasource.setName("repositoryDS");
        datasource.setLabel("Jasperserver Repository SQL data source");
        datasource.setDescription("Jasperserver Repository SQL data source for reporting");
        datasource.setJndiName(this.getJdbcProps().getProperty("metadata.jndi"));
        datasource.setParentFolder("/datasources");
        this.getUnsecureRepositoryService().saveResource(null, (Resource)datasource);
    }

    private void createJdbcDS() throws Exception {
        JdbcReportDataSource datasource = (JdbcReportDataSource)this.getUnsecureRepositoryService().newResource(null, JdbcReportDataSource.class);
        datasource.setName("JServerJdbcDS");
        datasource.setLabel("JServer Jdbc Data Source");
        datasource.setDescription("JServer Jdbc Data Source");
        datasource.setParentFolder("/datasources");
        datasource.setDriverClass(this.getJdbcProps().getProperty("test.jdbc.driverClassName"));
        datasource.setConnectionUrl(this.getJdbcProps().getProperty("test.jdbc.url"));
        datasource.setUsername(this.getJdbcProps().getProperty("test.jdbc.username"));
        datasource.setPassword(this.getJdbcProps().getProperty("test.jdbc.password"));
        this.getUnsecureRepositoryService().saveResource(null, (Resource)datasource);
    }

    private void createBeanDS() {
        BeanReportDataSource datasource = (BeanReportDataSource)this.getUnsecureRepositoryService().newResource(null, BeanReportDataSource.class);
        datasource.setName("CustomDSFromBean");
        datasource.setLabel("Custom data source from a bean");
        datasource.setDescription("A custom data source through a bean");
        datasource.setParentFolder("/datasources");
        datasource.setBeanName("customTestDataSourceService");
        this.getUnsecureRepositoryService().saveResource(null, (Resource)datasource);
    }

    private void createTableModelDS() {
        BeanReportDataSource datasource = (BeanReportDataSource)this.getUnsecureRepositoryService().newResource(null, BeanReportDataSource.class);
        datasource.setName("CustomTableModelDS");
        datasource.setLabel("Custom data source from a table model");
        datasource.setDescription("A custom data source through a table model");
        datasource.setParentFolder("/datasources");
        datasource.setBeanName("customTestDataSourceServiceFactory");
        datasource.setBeanMethod("tableModelDataSource");
        this.getUnsecureRepositoryService().saveResource(null, (Resource)datasource);
    }

    private void createSalesByMonth(Folder folder) {
        FileResource reportRes = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        reportRes.setName("SalesByMonthReport");
        reportRes.setLabel("Sales By Month Jasper Report");
        reportRes.setDescription("Sales By Month Jasper Report");
        InputStream jrxml = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/SalesByMonth.jrxml");
        reportRes.readData(jrxml);
        ReportUnit unit = (ReportUnit)this.getUnsecureRepositoryService().newResource(null, ReportUnit.class);
        unit.setName("SalesByMonth");
        unit.setLabel("Sales By Month Report");
        unit.setDescription("Sales By Month Report");
        unit.setParentFolder(folder);
        unit.setDataSourceReference("/datasources/JServerJNDIDS");
        unit.setMainReport(reportRes);
        FileResource jar = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        jar.setFileType("jar");
        jar.readData(((Object)((Object)this)).getClass().getResourceAsStream("/jars/scriptlet.jar"));
        this.setCommon((Resource)jar, "Scriptlet");
        unit.addResource(jar);
        FileResource img = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        img.setFileType("img");
        img.readData(((Object)((Object)this)).getClass().getResourceAsStream("/images/jasperreports.png"));
        this.setCommon((Resource)img, "Logo");
        unit.addResource(img);
        FileResource subrep = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        subrep.setFileType("jrxml");
        subrep.readData(((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/SalesByMonthDetail.jrxml"));
        this.setCommon((Resource)subrep, "SalesByMonthDetail");
        unit.addResource(subrep);
        FileResource resBdl = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        resBdl.setFileType("prop");
        resBdl.readData(((Object)((Object)this)).getClass().getResourceAsStream("/resource_bundles/sales.properties"));
        this.setCommon((Resource)resBdl, "sales.properties");
        unit.addResource(resBdl);
        FileResource resBdl_ro = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        resBdl_ro.setFileType("prop");
        resBdl_ro.readData(((Object)((Object)this)).getClass().getResourceAsStream("/resource_bundles/sales_ro.properties"));
        this.setCommon((Resource)resBdl_ro, "sales_ro.properties");
        unit.addResource(resBdl_ro);
        InputControl textInputCtrl = (InputControl)this.getUnsecureRepositoryService().newResource(null, InputControl.class);
        this.setCommon((Resource)textInputCtrl, "TextInputControl");
        textInputCtrl.setType((byte)2);
        textInputCtrl.setMandatory(false);
        textInputCtrl.setReadOnly(false);
        textInputCtrl.setVisible(true);
        textInputCtrl.setLabel("Text Input Control");
        textInputCtrl.setName("TextInput");
        DataTypeImpl dataType = new DataTypeImpl();
        dataType.setName("test");
        dataType.setLabel("test");
        dataType.setType((byte)2);
        textInputCtrl.setDataType((DataType)dataType);
        unit.addInputControl(textInputCtrl);
        InputControl checkboxInputControl = (InputControl)this.getUnsecureRepositoryService().newResource(null, InputControl.class);
        this.setCommon((Resource)checkboxInputControl, "CheckboxInputControl");
        checkboxInputControl.setType((byte)1);
        checkboxInputControl.setMandatory(true);
        checkboxInputControl.setReadOnly(false);
        checkboxInputControl.setVisible(true);
        checkboxInputControl.setLabel("Checkbox Input Control");
        checkboxInputControl.setName("CheckboxInput");
        unit.addInputControl(checkboxInputControl);
        InputControl listInputControl = (InputControl)this.getUnsecureRepositoryService().newResource(null, InputControl.class);
        this.setCommon((Resource)listInputControl, "ListInputControl");
        listInputControl.setType((byte)3);
        listInputControl.setMandatory(true);
        listInputControl.setReadOnly(false);
        listInputControl.setVisible(true);
        listInputControl.setLabel("List Input Control");
        listInputControl.setName("ListInput");
        ListOfValues values = (ListOfValues)this.getUnsecureRepositoryService().newResource(null, ListOfValues.class);
        values.setName("List_of_values");
        values.setLabel("List of values label");
        values.setDescription("List of values description");
        ListOfValuesItemImpl item = new ListOfValuesItemImpl();
        item.setLabel("An item");
        item.setValue((Object)"1");
        values.addValue((ListOfValuesItem)item);
        item = new ListOfValuesItemImpl();
        item.setLabel("Another item");
        item.setValue((Object)"2");
        values.addValue((ListOfValuesItem)item);
        item = new ListOfValuesItemImpl();
        item.setLabel("Yet another item");
        item.setValue((Object)"3");
        values.addValue((ListOfValuesItem)item);
        listInputControl.setListOfValues(values);
        dataType = new DataTypeImpl();
        dataType.setName("test");
        dataType.setLabel("test");
        dataType.setType((byte)1);
        listInputControl.setDataType((DataType)dataType);
        unit.addInputControl(listInputControl);
        this.createDateDatatype();
        InputControl dateInputCtrl = (InputControl)this.getUnsecureRepositoryService().newResource(null, InputControl.class);
        this.setCommon((Resource)dateInputCtrl, "DateInput");
        dateInputCtrl.setType((byte)2);
        dateInputCtrl.setMandatory(false);
        dateInputCtrl.setReadOnly(false);
        dateInputCtrl.setVisible(true);
        dateInputCtrl.setDataTypeReference("/datatypes/date");
        unit.addInputControl(dateInputCtrl);
        InputControl queryInputCtrl = (InputControl)this.getUnsecureRepositoryService().newResource(null, InputControl.class);
        this.setCommon((Resource)queryInputCtrl, "QueryInput");
        queryInputCtrl.setType((byte)4);
        queryInputCtrl.setMandatory(false);
        queryInputCtrl.setReadOnly(false);
        queryInputCtrl.setVisible(true);
        queryInputCtrl.setQueryValueColumn("user_name");
        queryInputCtrl.addQueryVisibleColumn("first_name");
        queryInputCtrl.addQueryVisibleColumn("last_name");
        Query query = (Query)this.getUnsecureRepositoryService().newResource(null, Query.class);
        this.setCommon((Resource)query, "testQuery");
        query.setLanguage("sql");
        query.setSql("select user_name, first_name, last_name from users");
        queryInputCtrl.setQuery(query);
        unit.addInputControl(queryInputCtrl);
        unit.setAlwaysPromptControls(false);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)unit);
    }

    private void createEmployees(Folder folder) {
        FileResource reportRes = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        this.setCommon((Resource)reportRes, "EmployeesJRXML");
        InputStream jrxml = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/Employees.jrxml");
        reportRes.readData(jrxml);
        ReportUnit unit = (ReportUnit)this.getUnsecureRepositoryService().newResource(null, ReportUnit.class);
        unit.setName("Employees");
        unit.setLabel("Employee List");
        unit.setDescription("Employee List");
        unit.setParentFolder(folder);
        unit.setDataSourceReference("/datasources/JServerJNDIDS");
        unit.setMainReport(reportRes);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)unit);
    }

    private void createEmployeeAccounts(Folder folder) {
        FileResource reportRes = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        this.setCommon((Resource)reportRes, "EmployeeAccountsJRXML");
        InputStream jrxml = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/EmployeeAccounts.jrxml");
        reportRes.readData(jrxml);
        ReportUnit unit = (ReportUnit)this.getUnsecureRepositoryService().newResource(null, ReportUnit.class);
        unit.setName("EmployeeAccounts");
        unit.setLabel("Employee Accounts");
        unit.setDescription("List of Accounts per Employee");
        unit.setParentFolder(folder);
        unit.setDataSourceReference("/datasources/JServerJNDIDS");
        unit.setMainReport(reportRes);
        InputControl empIC = (InputControl)this.getUnsecureRepositoryService().newResource(null, InputControl.class);
        empIC.setName("EmployeeID");
        empIC.setLabel("Employee");
        empIC.setMandatory(true);
        Query empQuery = (Query)this.getUnsecureRepositoryService().newResource(null, Query.class);
        empQuery.setName("EmployeeQuery");
        empQuery.setLabel("Employee Query");
        empQuery.setLanguage("sql");
        empQuery.setSql("SELECT id, user_name FROM users WHERE employee_status = 'Active'");
        empIC.setType((byte)4);
        empIC.setQuery(empQuery);
        empIC.setQueryValueColumn("id");
        empIC.addQueryVisibleColumn("user_name");
        unit.addInputControl(empIC);
        unit.setAlwaysPromptControls(false);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)unit);
    }

    private void createParamMany(Folder folder) {
        FileResource reportRes = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        this.setCommon((Resource)reportRes, "ParametersJRXML");
        InputStream jrxml = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/ParamMany.jrxml");
        reportRes.readData(jrxml);
        ReportUnit unit = (ReportUnit)this.getUnsecureRepositoryService().newResource(null, ReportUnit.class);
        unit.setName("Freight");
        unit.setLabel("Freight Report");
        unit.setDescription("Freight Report with Saved Parameters");
        unit.setParentFolder(folder);
        unit.setDataSourceReference("/datasources/JServerJNDIDS");
        unit.setMainReport(reportRes);
        InputControl countryIC = (InputControl)this.getUnsecureRepositoryService().newResource(null, InputControl.class);
        countryIC.setName("Country");
        countryIC.setLabel("Country");
        countryIC.setDescription("Country");
        countryIC.setMandatory(true);
        countryIC.setType((byte)4);
        Query countryQ = (Query)this.getUnsecureRepositoryService().newResource(null, Query.class);
        countryQ.setName("CountryQuery");
        countryQ.setLabel("CountryQuery");
        countryQ.setLanguage("sql");
        countryQ.setDataSourceReference("/datasources/JServerJNDIDS");
        countryQ.setSql("select distinct SHIPCOUNTRY from ORDERS");
        countryIC.setQuery(countryQ);
        countryIC.setQueryValueColumn("SHIPCOUNTRY");
        countryIC.addQueryVisibleColumn("SHIPCOUNTRY");
        unit.addInputControl(countryIC);
        InputControl requestDateIC = (InputControl)this.getUnsecureRepositoryService().newResource(null, InputControl.class);
        requestDateIC.setName("RequestDate");
        requestDateIC.setLabel("RequestDate");
        requestDateIC.setDescription("RequestDate");
        requestDateIC.setMandatory(false);
        requestDateIC.setType((byte)2);
        DataType dateDT = (DataType)this.getUnsecureRepositoryService().newResource(null, DataType.class);
        this.setCommon((Resource)dateDT, "Date");
        dateDT.setType((byte)3);
        requestDateIC.setDataType(dateDT);
        unit.addInputControl(requestDateIC);
        InputControl orderIdIC = (InputControl)this.getUnsecureRepositoryService().newResource(null, InputControl.class);
        orderIdIC.setName("OrderId");
        orderIdIC.setLabel("OrderId");
        orderIdIC.setDescription("OrderId");
        orderIdIC.setMandatory(false);
        orderIdIC.setType((byte)2);
        DataType numberDT = (DataType)this.getUnsecureRepositoryService().newResource(null, DataType.class);
        this.setCommon((Resource)numberDT, "Number");
        numberDT.setType((byte)2);
        orderIdIC.setDataType(numberDT);
        unit.addInputControl(orderIdIC);
        unit.setAlwaysPromptControls(false);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)unit);
    }

    protected void createDateDatatype() {
        FolderImpl folder = new FolderImpl();
        folder.setName("datatypes");
        folder.setLabel("Input data types");
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)folder);
        DataTypeImpl dateDataType = new DataTypeImpl();
        this.setCommon((Resource)dateDataType, "date");
        dateDataType.setType((byte)3);
        dateDataType.setParentFolder((Folder)folder);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)dateDataType);
    }

    private void setCommon(Resource res, String id) {
        res.setName(id);
        res.setLabel(id + "_label");
        res.setDescription(id + " description");
    }

    private void createAllAccounts(Folder folder) {
        FileResource reportRes = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        reportRes.setName("AllAccountsReport");
        reportRes.setLabel("All Accounts Jasper Report");
        reportRes.setDescription("All Accounts Jasper Report");
        reportRes.setParentFolder(folder);
        InputStream jrxml = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/AllAccounts.jrxml");
        reportRes.readData(jrxml);
        ReportUnit unit = (ReportUnit)this.getUnsecureRepositoryService().newResource(null, ReportUnit.class);
        unit.setName("AllAccounts");
        unit.setLabel("All Accounts Report");
        unit.setDescription("All Accounts Report");
        unit.setParentFolder(folder);
        unit.setDataSourceReference("/datasources/JServerJNDIDS");
        unit.setMainReport(reportRes);
        FileResource res1 = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        res1.setFileType("img");
        res1.readData(((Object)((Object)this)).getClass().getResourceAsStream("/images/jasperreports.png"));
        res1.setName("AllAccounts_Res1");
        res1.setLabel("AllAccounts_Res1");
        res1.setDescription("AllAccounts_Res1");
        unit.addResource(res1);
        FileResource res2 = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        res2.setFileType("img");
        res2.readData(((Object)((Object)this)).getClass().getResourceAsStream("/images/logo.jpg"));
        res2.setName("AllAccounts_Res2");
        res2.setLabel("AllAccounts_Res2");
        res2.setDescription("AllAccounts_Res2");
        unit.addResource(res2);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)unit);
    }

    private void createAllCharts(Folder folder) {
        FileResource reportRes = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        reportRes.setName("StandardChartsReport");
        reportRes.setLabel("Standard Charts Report");
        reportRes.setDescription("Standard Charts Report");
        reportRes.setParentFolder(folder);
        InputStream jrxml = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/StandardChartsReport.jrxml");
        reportRes.readData(jrxml);
        ReportUnit unit = (ReportUnit)this.getUnsecureRepositoryService().newResource(null, ReportUnit.class);
        unit.setName("StandardChartsReport");
        unit.setLabel("Standard Charts Report");
        unit.setDescription("Standard Charts Report");
        unit.setParentFolder(folder);
        unit.setDataSourceReference("/datasources/JServerJNDIDS");
        unit.setMainReport(reportRes);
        FileResource resBdl = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        resBdl.setFileType("prop");
        resBdl.readData(((Object)((Object)this)).getClass().getResourceAsStream("/resource_bundles/standardCharts.properties"));
        this.setCommon((Resource)resBdl, "standardCharts.properties");
        unit.addResource(resBdl);
        FileResource resBdl_ro = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        resBdl_ro.setFileType("prop");
        resBdl_ro.readData(((Object)((Object)this)).getClass().getResourceAsStream("/resource_bundles/standardCharts_ro.properties"));
        this.setCommon((Resource)resBdl_ro, "standardCharts_ro.properties");
        unit.addResource(resBdl_ro);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)unit);
        reportRes = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        reportRes.setName("StandardChartsAegeanReport");
        reportRes.setLabel("Standard Charts Aegean Report");
        reportRes.setDescription("Standard Charts Aegean Report");
        reportRes.setParentFolder(folder);
        jrxml = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/StandardChartsAegeanReport.jrxml");
        reportRes.readData(jrxml);
        unit = (ReportUnit)this.getUnsecureRepositoryService().newResource(null, ReportUnit.class);
        unit.setName("StandardChartsAegeanReport");
        unit.setLabel("Standard Charts Aegean Report");
        unit.setDescription("Standard Charts Aegean Report");
        unit.setParentFolder(folder);
        unit.setDataSourceReference("/datasources/JServerJNDIDS");
        unit.setMainReport(reportRes);
        resBdl = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        resBdl.setFileType("prop");
        resBdl.readData(((Object)((Object)this)).getClass().getResourceAsStream("/resource_bundles/standardCharts.properties"));
        this.setCommon((Resource)resBdl, "standardCharts.properties");
        unit.addResource(resBdl);
        resBdl_ro = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        resBdl_ro.setFileType("prop");
        resBdl_ro.readData(((Object)((Object)this)).getClass().getResourceAsStream("/resource_bundles/standardCharts_ro.properties"));
        this.setCommon((Resource)resBdl_ro, "standardCharts_ro.properties");
        unit.addResource(resBdl_ro);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)unit);
        reportRes = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        reportRes.setName("StandardChartsEyeCandyReport");
        reportRes.setLabel("Standard Charts Eye Candy Report");
        reportRes.setDescription("Standard Charts Eye Candy Report");
        reportRes.setParentFolder(folder);
        jrxml = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/StandardChartsEyeCandyReport.jrxml");
        reportRes.readData(jrxml);
        unit = (ReportUnit)this.getUnsecureRepositoryService().newResource(null, ReportUnit.class);
        unit.setName("StandardChartsEyeCandyReport");
        unit.setLabel("Standard Charts Eye Candy Report");
        unit.setDescription("Standard Charts Eye Candy Report");
        unit.setParentFolder(folder);
        unit.setDataSourceReference("/datasources/JServerJNDIDS");
        unit.setMainReport(reportRes);
        resBdl = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        resBdl.setFileType("prop");
        resBdl.readData(((Object)((Object)this)).getClass().getResourceAsStream("/resource_bundles/standardCharts.properties"));
        this.setCommon((Resource)resBdl, "standardCharts.properties");
        unit.addResource(resBdl);
        resBdl_ro = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        resBdl_ro.setFileType("prop");
        resBdl_ro.readData(((Object)((Object)this)).getClass().getResourceAsStream("/resource_bundles/standardCharts_ro.properties"));
        this.setCommon((Resource)resBdl_ro, "standardCharts_ro.properties");
        unit.addResource(resBdl_ro);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)unit);
    }

    private void createAllCascading(Folder folder) throws Exception {
        FileResource reportRes = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        reportRes.setName("Cascading_multi_select_report");
        reportRes.setLabel("Cascading multi select example report");
        reportRes.setDescription("Shows cascading input controls. Multi-select and single select queries");
        reportRes.setParentFolder(folder);
        InputStream jrxml = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/CascadingMultiSelectReport.jrxml");
        reportRes.readData(jrxml);
        ReportUnit unit = (ReportUnit)this.getUnsecureRepositoryService().newResource(null, ReportUnit.class);
        unit.setName("Cascading_multi_select_report");
        unit.setLabel("Cascading multi select example report");
        unit.setDescription("Example report with Cascading multi select input controls");
        unit.setParentFolder(folder);
        unit.setDataSourceReference("/datasources/JServerJNDIDS");
        unit.setMainReport(reportRes);
        InputControl countryIC = (InputControl)this.getUnsecureRepositoryService().newResource(null, InputControl.class);
        countryIC.setName("Country_multi_select");
        countryIC.setLabel("Country multi select");
        countryIC.setDescription("Country multi select");
        countryIC.setMandatory(true);
        countryIC.setType((byte)7);
        Query countryQ = (Query)this.getUnsecureRepositoryService().newResource(null, Query.class);
        countryQ.setName("country_query");
        countryQ.setLabel("Country Query");
        countryQ.setLanguage("sql");
        countryQ.setDataSourceReference("/datasources/JServerJNDIDS");
        countryQ.setSql("select distinct billing_address_country from accounts order by billing_address_country");
        countryIC.setQuery(countryQ);
        countryIC.setQueryValueColumn("billing_address_country");
        countryIC.addQueryVisibleColumn("billing_address_country");
        unit.addInputControl(countryIC);
        InputControl stateIC = (InputControl)this.getUnsecureRepositoryService().newResource(null, InputControl.class);
        stateIC.setName("Cascading_state_multi_select");
        stateIC.setLabel("Cascading state multi select control");
        stateIC.setDescription("Cascading state multi select control");
        stateIC.setMandatory(true);
        stateIC.setType((byte)7);
        Query stateQ = (Query)this.getUnsecureRepositoryService().newResource(null, Query.class);
        stateQ.setName("Cascading_state_query");
        stateQ.setLabel("Cascading state query");
        stateQ.setLanguage("sql");
        stateQ.setDataSourceReference("/datasources/JServerJNDIDS");
        stateQ.setSql("select distinct billing_address_state, billing_address_country from accounts where $X{IN, billing_address_country, Country_multi_select} order by billing_address_country, billing_address_state");
        stateIC.setQuery(stateQ);
        stateIC.setQueryValueColumn("billing_address_state");
        stateIC.addQueryVisibleColumn("billing_address_country");
        stateIC.addQueryVisibleColumn("billing_address_state");
        unit.addInputControl(stateIC);
        InputControl nameIC = (InputControl)this.getUnsecureRepositoryService().newResource(null, InputControl.class);
        nameIC.setName("Cascading_name_single_select");
        nameIC.setLabel("Cascading name single select");
        nameIC.setDescription("Cascading name single select");
        nameIC.setMandatory(true);
        nameIC.setType((byte)4);
        Query nameQ = (Query)this.getUnsecureRepositoryService().newResource(null, Query.class);
        nameQ.setName("country_state_to_name");
        nameQ.setLabel("Country State to Name");
        nameQ.setLanguage("sql");
        nameQ.setDataSourceReference("/datasources/JServerJNDIDS");
        nameQ.setSql("select name from accounts where $X{IN, billing_address_country, Country_multi_select} and $X{IN, billing_address_state, Cascading_state_multi_select} order by name");
        nameIC.setQuery(nameQ);
        nameIC.setQueryValueColumn("name");
        nameIC.addQueryVisibleColumn("name");
        unit.addInputControl(nameIC);
        unit.setAlwaysPromptControls(true);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)unit);
        reportRes = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        reportRes.setName("PermissionsOfUsersWithARoleSharedByLoggedIn");
        reportRes.setLabel("Permissions Of Users with a role shared by LoggedIn");
        reportRes.setDescription("Input control controlled by user profile");
        reportRes.setParentFolder(folder);
        String dbName = this.getJdbcProps().getProperty("test.databaseFlavor");
        jrxml = dbName != null && dbName.startsWith("postgre") ? ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/PermissionsOfUsersWithARoleSharedByLoggedIn_postgres.jrxml") : (dbName != null && dbName.startsWith("db2") ? ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/PermissionsOfUsersWithARoleSharedByLoggedIn_db2.jrxml") : (dbName != null && dbName.startsWith("sqlserver") ? ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/PermissionsOfUsersWithARoleSharedByLoggedIn_mssql.jrxml") : ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/PermissionsOfUsersWithARoleSharedByLoggedIn.jrxml")));
        reportRes.readData(jrxml);
        ReportUnit unit2 = (ReportUnit)this.getUnsecureRepositoryService().newResource(null, ReportUnit.class);
        unit2.setName("PermissionsOfUsersWithARoleSharedByLoggedIn");
        unit2.setLabel("Permissions Of Users with a role shared by LoggedIn");
        unit2.setDescription("Input control controlled by user profile");
        unit2.setParentFolder(folder);
        unit2.setDataSourceReference("/datasources/repositoryDS");
        unit2.setMainReport(reportRes);
        InputControl rolesIC = (InputControl)this.getUnsecureRepositoryService().newResource(null, InputControl.class);
        rolesIC.setName("RolesOfLoggedInUser");
        rolesIC.setLabel("Roles of LoggedIn User");
        rolesIC.setDescription("Roles of LoggedIn User");
        rolesIC.setMandatory(true);
        rolesIC.setType((byte)7);
        Query rolesQ = (Query)this.getUnsecureRepositoryService().newResource(null, Query.class);
        rolesQ.setName("RolesOfUserQuery");
        rolesQ.setLabel("RolesOfUserQuery");
        rolesQ.setLanguage("sql");
        rolesQ.setDataSourceReference("/datasources/repositoryDS");
        rolesQ.setSql("select rolename from JIRole where $X{IN, rolename, LoggedInUserRoles}");
        rolesIC.setQuery(rolesQ);
        rolesIC.setQueryValueColumn("rolename");
        rolesIC.addQueryVisibleColumn("rolename");
        unit2.addInputControl(rolesIC);
        unit2.setAlwaysPromptControls(true);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)unit2);
    }

    private void createOFCReport(Folder folder) {
        FileResource reportRes = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        reportRes.setName("OpenFlashChartsJRXML");
        reportRes.setLabel("Open Flash Charts JRXML");
        reportRes.setDescription("JRXML that contains Open Flash Chart components.\nThis report uses Open Flash Chart V2 Beta 1, (C) 2007 John Glazebrook and released under the LGPL License.\nhttp://teethgrinder.co.uk/open-flash-chart-2/");
        reportRes.readData(((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/OpenFlashChartsReport.jrxml"));
        ReportUnit unit = (ReportUnit)this.getUnsecureRepositoryService().newResource(null, ReportUnit.class);
        unit.setName("OpenFlashChartsReport");
        unit.setLabel("Open Flash Charts Report");
        unit.setDescription("A report that displays Open Flash Charts");
        unit.setParentFolder(folder);
        unit.setDataSourceReference("/datasources/JServerJNDIDS");
        unit.setMainReport(reportRes);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)unit);
    }

    private void createCustomDSReportFileResource(Folder folder) {
        FileResource reportRes = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        reportRes.setName("DataSourceReportTemplate");
        reportRes.setLabel("Report showing Custom Data Source");
        reportRes.setDescription("Report showing use of Custom Data Source via a bean");
        reportRes.setParentFolder(folder);
        InputStream jrxml = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/DataSourceReport.jrxml");
        reportRes.readData(jrxml);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)reportRes);
    }

    private void createCustomDSReport(Folder folder) {
        ReportUnit unit = (ReportUnit)this.getUnsecureRepositoryService().newResource(null, ReportUnit.class);
        unit.setName("DataSourceReport");
        unit.setLabel("Report showing Custom Data Source");
        unit.setDescription("Report showing use of Custom Data Source via a bean");
        unit.setParentFolder(folder);
        unit.setMainReportReference("/reports/samples/DataSourceReportTemplate");
        unit.setDataSourceReference("/datasources/CustomDSFromBean");
        this.getUnsecureRepositoryService().saveResource(null, (Resource)unit);
    }

    private void createTableModelDSReport(Folder folder) {
        ReportUnit unit = (ReportUnit)this.getUnsecureRepositoryService().newResource(null, ReportUnit.class);
        unit.setName("DataSourceTableModel");
        unit.setLabel("Table Model Data Source");
        unit.setDescription("Report showing use of Custom Data Source via table model");
        unit.setParentFolder(folder);
        unit.setMainReportReference("/reports/samples/DataSourceReportTemplate");
        unit.setDataSourceReference("/datasources/CustomTableModelDS");
        unit.setMainReportReference("/reports/samples/DataSourceReportTemplate");
        this.getUnsecureRepositoryService().saveResource(null, (Resource)unit);
    }

    private void update() {
        ReportUnit unit = (ReportUnit)this.getUnsecureRepositoryService().getResource(null, "/reports/samples/AllAccounts");
        HibernateRepositoryTest.assertEquals((String)"AllAccounts", (String)unit.getName());
        HibernateRepositoryTest.assertEquals((String)"/reports/samples/AllAccounts", (String)unit.getURIString());
        unit.setLabel("Accounts Report");
        FileResource removed = unit.removeResourceLocal("AllAccounts_Res1");
        HibernateRepositoryTest.assertNotNull((Object)removed);
        FileResource res3 = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        res3.setFileType("img");
        res3.readData(((Object)((Object)this)).getClass().getResourceAsStream("/images/jasperreports.png"));
        res3.setName("AllAccounts_Res3");
        res3.setLabel("AllAccounts_Res3");
        res3.setDescription("AllAccounts_Res3");
        unit.addResource(res3);
        FileResource res4 = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        res4.setFileType("img");
        res4.setReferenceURI("/images/JRLogo");
        this.setCommon((Resource)res4, "LogoLink");
        unit.addResource(res4);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)unit);
        unit = (ReportUnit)this.getUnsecureRepositoryService().getResource(null, "/reports/samples/AllAccounts");
        HibernateRepositoryTest.assertTrue((boolean)unit.getLabel().startsWith("Accounts "));
        List resources = unit.getResources();
        HibernateRepositoryTest.assertNotNull((Object)resources);
        HibernateRepositoryTest.assertEquals((int)3, (int)resources.size());
    }

    private void read() {
        ReportUnit unit = (ReportUnit)this.getUnsecureRepositoryService().getResource(null, "/reports/samples/AllAccounts");
        HibernateRepositoryTest.assertNotNull((Object)unit);
        HibernateRepositoryTest.assertEquals((String)ReportUnit.class.getName(), (String)unit.getResourceType());
        HibernateRepositoryTest.assertEquals((String)"AllAccounts", (String)unit.getName());
        ResourceReference dsRef = unit.getDataSource();
        HibernateRepositoryTest.assertNotNull((Object)dsRef);
        HibernateRepositoryTest.assertFalse((boolean)dsRef.isLocal());
        HibernateRepositoryTest.assertEquals((String)"/datasources/JServerJNDIDS", (String)dsRef.getReferenceURI());
        ResourceReference mainReportRef = unit.getMainReport();
        HibernateRepositoryTest.assertNotNull((Object)mainReportRef);
        HibernateRepositoryTest.assertTrue((boolean)mainReportRef.isLocal());
        Resource mainReport = mainReportRef.getLocalResource();
        HibernateRepositoryTest.assertTrue((boolean)(mainReport instanceof FileResource));
        HibernateRepositoryTest.assertEquals((String)"AllAccountsReport", (String)mainReport.getName());
        List resources = unit.getResources();
        HibernateRepositoryTest.assertNotNull((Object)resources);
        HibernateRepositoryTest.assertEquals((int)2, (int)resources.size());
        FileResource img = (FileResource)this.getUnsecureRepositoryService().getResource(null, "/images/JRLogo");
        HibernateRepositoryTest.assertNotNull((Object)img);
        HibernateRepositoryTest.assertEquals((String)"JRLogo", (String)img.getName());
        this.datasources();
        this.parentFolder();
        this.propertyFilter();
        this.disjunctionFilter();
        this.orFilter();
    }

    private void datasources() {
        FilterCriteria criteria = FilterCriteria.createFilter(ReportDataSource.class);
        ResourceLookup[] lookups = this.getUnsecureRepositoryService().findResource(null, criteria);
        HibernateRepositoryTest.assertNotNull((Object)lookups);
        HibernateRepositoryTest.assertTrue((2 <= lookups.length ? 1 : 0) != 0);
        for (int i = 0; i < lookups.length; ++i) {
            Resource res = this.getUnsecureRepositoryService().getResource(null, lookups[i].getURIString());
            HibernateRepositoryTest.assertTrue((boolean)(res instanceof ReportDataSource));
        }
    }

    private void parentFolder() {
        FilterCriteria criteria = FilterCriteria.createFilter();
        criteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)"/datasources"));
        ResourceLookup[] folderResources = this.getUnsecureRepositoryService().findResource(null, criteria);
        HibernateRepositoryTest.assertNotNull((Object)folderResources);
        HibernateRepositoryTest.assertTrue((folderResources.length > 0 ? 1 : 0) != 0);
        for (int i = 0; i < folderResources.length; ++i) {
            ResourceLookup lookup = folderResources[i];
            HibernateRepositoryTest.assertEquals((String)"/datasources", (String)lookup.getParentFolder());
            if (lookup.getName().equals("JServerJdbcDS")) {
                HibernateRepositoryTest.assertEquals((String)JdbcReportDataSource.class.getName(), (String)lookup.getResourceType());
                continue;
            }
            if (!lookup.getName().equals("JServerJNDIDS")) continue;
            HibernateRepositoryTest.assertEquals((String)JndiJdbcReportDataSource.class.getName(), (String)lookup.getResourceType());
        }
    }

    private void propertyFilter() {
        FilterCriteria criteria = FilterCriteria.createFilter(FileResource.class);
        criteria.addFilterElement((FilterElement)FilterCriteria.createPropertyEqualsFilter((String)"fileType", (Object)"img"));
        ResourceLookup[] resources = this.getUnsecureRepositoryService().findResource(null, criteria);
        HibernateRepositoryTest.assertNotNull((Object)resources);
        HibernateRepositoryTest.assertTrue((resources.length > 0 ? 1 : 0) != 0);
        for (int i = 0; i < resources.length; ++i) {
            Resource res = this.getUnsecureRepositoryService().getResource(null, resources[i].getURIString());
            HibernateRepositoryTest.assertTrue((boolean)(res instanceof FileResource));
            FileResource fileRes = (FileResource)res;
            HibernateRepositoryTest.assertEquals((String)FileResource.class.getName(), (String)fileRes.getResourceType());
            HibernateRepositoryTest.assertEquals((String)"img", (String)fileRes.getFileType());
        }
    }

    private void disjunctionFilter() {
        FilterCriteria criteria = FilterCriteria.createFilter();
        FilterElementDisjunction disjunction = criteria.addDisjunction();
        disjunction.addFilterElement((FilterElement)FilterCriteria.createPropertyLikeFilter((String)"name", (Object)"%JdbcDS"));
        disjunction.addNegatedFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)"/datasources"));
        ResourceLookup[] resources = this.getUnsecureRepositoryService().findResource(null, criteria);
        HibernateRepositoryTest.assertNotNull((Object)resources);
        HibernateRepositoryTest.assertTrue((resources.length > 0 ? 1 : 0) != 0);
        for (int i = 0; i < resources.length; ++i) {
            ResourceLookup lookup = resources[i];
            HibernateRepositoryTest.assertTrue((lookup.getName().endsWith("JdbcDS") || !lookup.getParentFolder().equals("/datasources") ? 1 : 0) != 0);
        }
    }

    private void orFilter() {
        FilterCriteria criteria = FilterCriteria.createFilter();
        FilterElementOr or = criteria.addOr();
        or.setLeftHandSide((FilterElement)FilterCriteria.createParentFolderFilter((String)"/images"));
        or.setRightHandSide((FilterElement)FilterCriteria.createParentFolderFilter((String)"/datasources"));
        ResourceLookup[] resources = this.getUnsecureRepositoryService().findResource(null, criteria);
        HibernateRepositoryTest.assertNotNull((String)"Null resources found for or filter", (Object)resources);
        HibernateRepositoryTest.assertTrue((String)"No resources found for or filter", (resources.length > 0 ? 1 : 0) != 0);
        boolean imagesFound = false;
        boolean dataSourcesFound = false;
        for (int i = 0; !(i >= resources.length || imagesFound && dataSourcesFound); ++i) {
            ResourceLookup lookup = resources[i];
            if (lookup.getParentFolder().equals("/images")) {
                imagesFound = true;
                continue;
            }
            if (!lookup.getParentFolder().equals("/datasources")) continue;
            dataSourcesFound = true;
        }
        HibernateRepositoryTest.assertTrue((String)"No images found for or filter", (boolean)imagesFound);
        HibernateRepositoryTest.assertTrue((String)"No data sources found for or filter", (boolean)dataSourcesFound);
    }

    private void readFolders() {
        List folders = this.getUnsecureRepositoryService().getAllFolders(null);
        HibernateRepositoryTest.assertNotNull((Object)folders);
        HibernateRepositoryTest.assertTrue((5 <= folders.size() ? 1 : 0) != 0);
        Iterator it = folders.iterator();
        Folder folder = (Folder)it.next();
        HibernateRepositoryTest.assertEquals((String)"/", (String)folder.getURIString());
        HashSet<String> folderURIs = new HashSet<String>();
        while (it.hasNext()) {
            folder = (Folder)it.next();
            folderURIs.add(folder.getURIString());
        }
        HibernateRepositoryTest.assertTrue((boolean)folderURIs.contains("/datasources"));
        HibernateRepositoryTest.assertTrue((boolean)folderURIs.contains("/images"));
        HibernateRepositoryTest.assertTrue((boolean)folderURIs.contains("/reports"));
        HibernateRepositoryTest.assertTrue((boolean)folderURIs.contains("/reports/samples"));
        List subFolders = this.getUnsecureRepositoryService().getSubFolders(null, "/reports");
        HibernateRepositoryTest.assertNotNull((Object)subFolders);
        HibernateRepositoryTest.assertEquals((int)1, (int)subFolders.size());
        folder = (Folder)subFolders.get(0);
        HibernateRepositoryTest.assertEquals((String)"/reports/samples", (String)folder.getURIString());
    }

    private void list() {
        ResourceLookup[] units = this.getUnsecureRepositoryService().findResource(null, FilterCriteria.createFilter(ReportUnit.class));
        HibernateRepositoryTest.assertNotNull((Object)units);
        HibernateRepositoryTest.assertTrue((units.length >= 2 ? 1 : 0) != 0);
    }

    private void resources() {
        ResourceLookup[] resources = this.getUnsecureRepositoryService().findResource(null, null);
        HibernateRepositoryTest.assertNotNull((Object)resources);
        HibernateRepositoryTest.assertTrue((resources.length >= 2 ? 1 : 0) != 0);
    }

    private void setupExecuteOnlyPerms() {
        Role userRole = this.getOrCreateRole(userRoleName);
        this.createObjectPermission("/datasources", (Object)userRole, JasperServerAclEntry.EXECUTE);
        this.createObjectPermission("/images", (Object)userRole, JasperServerAclEntry.EXECUTE);
        this.createObjectPermission("/themes", (Object)userRole, JasperServerAclEntry.EXECUTE);
    }

    private void optimisticLocking() {
        JndiJdbcReportDataSource ds1 = (JndiJdbcReportDataSource)this.getUnsecureRepositoryService().getResource(null, "/datasources/JServerJNDIDS");
        ds1.setLabel(ds1.getLabel() + " Updated 1");
        JndiJdbcReportDataSource ds2 = (JndiJdbcReportDataSource)this.getUnsecureRepositoryService().getResource(null, "/datasources/JServerJNDIDS");
        ds2.setLabel(ds1.getLabel() + " Updated 2");
        this.getUnsecureRepositoryService().saveResource(null, (Resource)ds1);
        boolean failed = false;
        try {
            this.getUnsecureRepositoryService().saveResource(null, (Resource)ds2);
        }
        catch (Exception e) {
            failed = true;
        }
        HibernateRepositoryTest.assertTrue((boolean)failed);
        ds1 = (JndiJdbcReportDataSource)this.getUnsecureRepositoryService().getResource(null, "/datasources/JServerJNDIDS");
        ds1.setLabel("JServer JNDI Data Source");
        this.getUnsecureRepositoryService().saveResource(null, (Resource)ds1);
    }

    public void testLocalResourceReplace() {
        HibernateRepositoryTest.assertNotNull((String)"Repo not null", (Object)this.getUnsecureRepositoryService());
        FolderImpl folder = new FolderImpl();
        this.setCommon((Resource)folder, "testLocalResourceReplace");
        folder.setParentFolder("/");
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)folder);
        ReportUnit unit = (ReportUnit)this.getUnsecureRepositoryService().newResource(null, ReportUnit.class);
        this.setCommon((Resource)unit, "unit");
        unit.setParentFolder((Folder)folder);
        FileResource rep = (FileResource)this.getUnsecureRepositoryService().newResource(null, FileResource.class);
        this.setCommon((Resource)rep, "report");
        rep.readData(((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/SalesByMonth.jrxml"));
        unit.setMainReport(rep);
        JdbcReportDataSource jdbcDS = (JdbcReportDataSource)this.getUnsecureRepositoryService().newResource(null, JdbcReportDataSource.class);
        this.setCommon((Resource)jdbcDS, "ds");
        jdbcDS.setConnectionUrl("jdbc:mysql://localhost:3306/jasperserver");
        jdbcDS.setDriverClass("com.mysql.jdbc.Driver");
        jdbcDS.setUsername("user");
        jdbcDS.setPassword("passwd");
        unit.setDataSource((ReportDataSource)jdbcDS);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)unit);
        Resource res = this.getUnsecureRepositoryService().getResource(null, "/testLocalResourceReplace/unit");
        HibernateRepositoryTest.assertNotNull((Object)unit);
        HibernateRepositoryTest.assertTrue((boolean)(res instanceof ReportUnit));
        unit = (ReportUnit)res;
        ResourceReference dsRef = unit.getDataSource();
        HibernateRepositoryTest.assertNotNull((Object)dsRef);
        HibernateRepositoryTest.assertTrue((boolean)dsRef.isLocal());
        Resource ds = dsRef.getLocalResource();
        HibernateRepositoryTest.assertTrue((boolean)(ds instanceof JdbcReportDataSource));
        HibernateRepositoryTest.assertEquals((String)"ds", (String)ds.getName());
        JndiJdbcReportDataSource jndiDS = (JndiJdbcReportDataSource)this.getUnsecureRepositoryService().newResource(null, JndiJdbcReportDataSource.class);
        this.setCommon((Resource)jndiDS, "ds");
        jndiDS.setJndiName("jdbc/jserver");
        unit.setDataSource((ReportDataSource)jndiDS);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)unit);
        res = this.getUnsecureRepositoryService().getResource(null, "/testLocalResourceReplace/unit");
        HibernateRepositoryTest.assertNotNull((Object)unit);
        HibernateRepositoryTest.assertTrue((boolean)(res instanceof ReportUnit));
        unit = (ReportUnit)res;
        dsRef = unit.getDataSource();
        HibernateRepositoryTest.assertNotNull((Object)dsRef);
        HibernateRepositoryTest.assertTrue((boolean)dsRef.isLocal());
        Resource dsLocal = dsRef.getLocalResource();
        HibernateRepositoryTest.assertEquals((String)"ds", (String)dsLocal.getName());
        HibernateRepositoryTest.assertTrue((boolean)(dsLocal instanceof JndiJdbcReportDataSource));
        jndiDS = (JndiJdbcReportDataSource)dsLocal;
        HibernateRepositoryTest.assertEquals((String)"jdbc/jserver", (String)jndiDS.getJndiName());
        this.getUnsecureRepositoryService().deleteFolder(null, "/testLocalResourceReplace");
    }

    public void testLoadResourcesList() {
        RepositoryService repositoryService = this.getRepositoryService();
        HibernateRepositoryTest.assertNotNull((String)"Repository service should not be null", (Object)repositoryService);
        BasicTransformerFactory transformerFactory = new BasicTransformerFactory();
        Map resourcesCountMap = repositoryService.loadResourcesMapCount(null, "", null, null, null, null, (TransformerFactory)transformerFactory);
        HibernateRepositoryTest.assertEquals((int)1, (int)resourcesCountMap.size());
        resourcesCountMap = repositoryService.loadResourcesMapCount(null, "all", null, null, null, null, (TransformerFactory)transformerFactory);
        HibernateRepositoryTest.assertEquals((int)1, (int)resourcesCountMap.size());
        HibernateRepositoryTest.assertEquals((int)1, (int)((Integer)resourcesCountMap.get(null)));
        ExecutionContextImpl executionContext = new ExecutionContextImpl();
        ArrayList<FolderFilter> filters = new ArrayList<FolderFilter>();
        filters.add(new FolderFilter());
        ArrayList<Class> types = new ArrayList<Class>();
        types.add(ReportDataSource.class);
        types.add(ReportUnit.class);
        resourcesCountMap = repositoryService.loadResourcesMapCount((ExecutionContext)executionContext, "", types, filters, null, null, (TransformerFactory)transformerFactory);
        HibernateRepositoryTest.assertEquals((int)2, (int)resourcesCountMap.size());
        HibernateRepositoryTest.assertEquals((int)5, (int)((Integer)resourcesCountMap.get(ReportDataSource.class)));
        HibernateRepositoryTest.assertEquals((int)13, (int)((Integer)resourcesCountMap.get(ReportUnit.class)));
    }
}

