/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.view.service.impl;

import com.jaspersoft.jasperserver.api.metadata.common.domain.ContentResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileBufferedDataContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.util.test.BaseJasperServerTest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class ContentRepositoryTest
extends BaseJasperServerTest {
    public ContentRepositoryTest(String name) {
        super(name);
        this.setAutowireMode(1);
    }

    public void testFolder() {
        FolderImpl dsFolder = new FolderImpl();
        dsFolder.setName("ContentFiles");
        dsFolder.setLabel("Content files");
        dsFolder.setDescription("Content files generated by reports");
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)dsFolder);
        FolderImpl newFolder = new FolderImpl();
        newFolder.setParentFolder((Folder)dsFolder);
        newFolder.setName("html");
        newFolder.setLabel("html");
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)newFolder);
        newFolder = new FolderImpl();
        newFolder.setParentFolder((Folder)dsFolder);
        newFolder.setName("pdf");
        newFolder.setLabel("pdf");
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)newFolder);
        newFolder = new FolderImpl();
        newFolder.setParentFolder((Folder)dsFolder);
        newFolder.setName("xls");
        newFolder.setLabel("xls");
        this.getUnsecureRepositoryService().saveFolder(null, (Folder)newFolder);
    }

    public void testFiles() throws Exception {
        ContentResource fileResource = (ContentResource)this.getUnsecureRepositoryService().newResource(null, ContentResource.class);
        fileResource.setName("PdfTestFile");
        fileResource.setLabel("Pdf test file");
        fileResource.setParentFolder("/ContentFiles/pdf");
        InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("/FontsReport.pdf");
        fileResource.setDataContainer(this.createFileDataContainer(file));
        fileResource.setFileType("pdf");
        this.getUnsecureRepositoryService().saveResource(null, (Resource)fileResource);
        ContentResource htmlFile = (ContentResource)this.getUnsecureRepositoryService().newResource(null, ContentResource.class);
        htmlFile.setName("HtmlTestFile");
        htmlFile.setLabel("HTML test file with images");
        htmlFile.setParentFolder("/ContentFiles/html");
        file = ((Object)((Object)this)).getClass().getResourceAsStream("/FirstJasper.html");
        htmlFile.setDataContainer(this.createFileDataContainer(file));
        htmlFile.setFileType("html");
        ArrayList<ContentResource> images = new ArrayList<ContentResource>();
        ContentResource image = (ContentResource)this.getUnsecureRepositoryService().newResource(null, ContentResource.class);
        image.setName("img_0_0_1");
        image.setLabel("img_0_0_1");
        file = ((Object)((Object)this)).getClass().getResourceAsStream("/FirstJasper.html_files/img_0_0_1");
        image.readData(file);
        image.setFileType("html");
        images.add(image);
        image = (ContentResource)this.getUnsecureRepositoryService().newResource(null, ContentResource.class);
        image.setName("img_0_7_125");
        image.setLabel("img_0_7_125");
        file = ((Object)((Object)this)).getClass().getResourceAsStream("/FirstJasper.html_files/img_0_7_125");
        image.readData(file);
        image.setFileType("html");
        images.add(image);
        image = (ContentResource)this.getUnsecureRepositoryService().newResource(null, ContentResource.class);
        image.setName("px");
        image.setLabel("px");
        file = ((Object)((Object)this)).getClass().getResourceAsStream("/FirstJasper.html_files/px");
        image.readData(file);
        image.setFileType("html");
        images.add(image);
        htmlFile.setResources(images);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)htmlFile);
        htmlFile = (ContentResource)this.getUnsecureRepositoryService().newResource(null, ContentResource.class);
        htmlFile.setName("Test");
        htmlFile.setLabel("HTML test file with one image");
        htmlFile.setParentFolder("/ContentFiles/html");
        file = ((Object)((Object)this)).getClass().getResourceAsStream("/Test.html");
        htmlFile.readData(file);
        htmlFile.setFileType("html");
        image = (ContentResource)this.getUnsecureRepositoryService().newResource(null, ContentResource.class);
        image.setName("image0");
        image.setLabel("image0");
        file = ((Object)((Object)this)).getClass().getResourceAsStream("/Test.html_files/image0");
        image.readData(file);
        image.setFileType("html");
        images = new ArrayList();
        images.add(image);
        htmlFile.setResources(images);
        this.getUnsecureRepositoryService().saveResource(null, (Resource)htmlFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataContainer createFileDataContainer(InputStream file) throws Exception {
        FileBufferedDataContainer dataContainer = new FileBufferedDataContainer();
        OutputStream os = dataContainer.getOutputStream();
        byte[] buf = new byte[4000];
        try {
            int dataSize;
            while ((dataSize = file.read(buf)) != -1) {
                os.write(buf, 0, dataSize);
            }
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                    os.close();
                }
                catch (IOException ex) {}
            }
        }
        return dataContainer;
    }
}

