/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata;

import com.jaspersoft.jasperserver.api.metadata.OlapConnectionTest;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianXMLADefinition;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapClientConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapUnit;
import com.jaspersoft.jasperserver.api.metadata.olap.service.OlapConnectionService;
import com.jaspersoft.jasperserver.api.metadata.olap.service.impl.OlapConnectionServiceImpl;
import com.jaspersoft.jasperserver.util.test.BaseJasperServerTest;
import mondrian.olap.Connection;
import mondrian.olap.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OlapClientTest
extends BaseJasperServerTest {
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected final String OLAP_SCHEMAS = "/analysis/schemas/";
    protected final String OLAP_DATASOURCES = "/analysis/datasources/";
    protected final String OLAP_CONNECTIONS = "/analysis/connections/";
    protected final String OLAP_DEFINITIONS = "/analysis/xmla/definitions/";
    protected final String OLAP_VIEWS = "/analysis/views/";
    protected final String MDX_QUERY = "SELECT {[Measures].[Unit Sales]} ON COLUMNS, {[Time].[1997].[Q1]} ON ROWS FROM [Sales]";
    protected final String XML_SCHEMA = "/analysis/schemas/Foodmart";
    private static final String strSchemaFoodmart = "FoodmartSchema";
    private static final String strSchemaSugarCrm = "SugarCRMSchema";
    private static final String strDatasourceFoodmart = "FoodmartDataSourceJNDI";
    private static final String strDatasourceSugarCrm = "SugarCRMDataSource";
    static String strConnection = "Foodmart";
    private OlapClientConnection connectionOriginal;
    private OlapConnectionService connectionService;
    static FileResource schemaFoodmart;
    static FileResource schemaSugarCrm;
    static ReportDataSource datasourceFoodmart;
    static ReportDataSource datasourceSugarCrm;

    protected void onTearDown() {
        if (this.connectionOriginal != null) {
            this.connectionOriginal = (OlapClientConnection)this.getRepositoryService().getResource(null, "/analysis/connections/" + strConnection);
            ((MondrianConnection)this.connectionOriginal).setSchemaReference("/analysis/schemas/FoodmartSchema");
            ((MondrianConnection)this.connectionOriginal).setDataSourceReference("/analysis/datasources/FoodmartDataSourceJNDI");
            this.getRepositoryService().saveResource(null, (Resource)this.connectionOriginal);
        }
    }

    public void testSchemasExist() {
        schemaFoodmart = (FileResource)this.getRepositoryService().getResource(null, "/analysis/schemas/FoodmartSchema");
        OlapClientTest.assertNotNull((String)"Foodmart schema does not exist", (Object)schemaFoodmart);
        OlapClientTest.assertNotNull((String)"no data in Foodmart schema", (Object)schemaFoodmart.getDataStream());
        schemaSugarCrm = (FileResource)this.getRepositoryService().getResource(null, "/analysis/schemas/SugarCRMSchema");
        OlapClientTest.assertNotNull((String)"SugarCRM schema does not exist", (Object)schemaSugarCrm);
        OlapClientTest.assertNotNull((String)"no data in SugarCRM schema", (Object)schemaSugarCrm.getDataStream());
    }

    public void testDatasourcesExist() {
        datasourceFoodmart = (ReportDataSource)this.getRepositoryService().getResource(null, "/analysis/datasources/FoodmartDataSourceJNDI");
        OlapClientTest.assertNotNull((String)"Foodmart data source does not exist", (Object)datasourceFoodmart);
        datasourceSugarCrm = (ReportDataSource)this.getRepositoryService().getResource(null, "/analysis/datasources/SugarCRMDataSource");
        OlapClientTest.assertNotNull((String)"SugarCRM data source does not exist", (Object)datasourceSugarCrm);
    }

    private void setupTestMondrianConnection() {
        this.connectionOriginal = (OlapClientConnection)this.getRepositoryService().getResource(null, "/analysis/connections/" + strConnection);
        OlapClientTest.assertNotNull((Object)this.connectionOriginal);
        OlapClientTest.assertTrue((boolean)(this.connectionOriginal instanceof MondrianConnection));
        OlapClientTest.assertTrue((boolean)((MondrianConnection)this.connectionOriginal).getSchema().getReferenceLookup().getName().equals(strSchemaFoodmart));
        OlapClientTest.assertTrue((boolean)((MondrianConnection)this.connectionOriginal).getSchema().getReferenceURI().equals("/analysis/schemas/FoodmartSchema"));
    }

    public void testUpdateMondrianConnectionSchema() {
        this.setupTestMondrianConnection();
        ((MondrianConnection)this.connectionOriginal).setSchemaReference("/analysis/schemas/SugarCRMSchema");
        this.getRepositoryService().saveResource(null, (Resource)this.connectionOriginal);
        OlapClientConnection connectionNew = (OlapClientConnection)this.getRepositoryService().getResource(null, "/analysis/connections/" + strConnection);
        OlapClientTest.assertNotNull((Object)connectionNew);
        OlapClientTest.assertTrue((boolean)(connectionNew instanceof MondrianConnection));
        OlapClientTest.assertTrue((boolean)((MondrianConnection)connectionNew).getSchema().getReferenceLookup().getName().equals(strSchemaSugarCrm));
        OlapClientTest.assertTrue((boolean)((MondrianConnection)connectionNew).getSchema().getReferenceURI().equals("/analysis/schemas/SugarCRMSchema"));
    }

    public void testUpdateMondrianConnectionDatasource() {
        this.setupTestMondrianConnection();
        ((MondrianConnection)this.connectionOriginal).setDataSourceReference("/analysis/datasources/SugarCRMDataSource");
        this.getRepositoryService().saveResource(null, (Resource)this.connectionOriginal);
        OlapClientConnection connectionNew = (OlapClientConnection)this.getRepositoryService().getResource(null, "/analysis/connections/" + strConnection);
        OlapClientTest.assertNotNull((Object)connectionNew);
        OlapClientTest.assertTrue((boolean)(connectionNew instanceof MondrianConnection));
        OlapClientTest.assertTrue((boolean)((MondrianConnection)connectionNew).getDataSource().getReferenceLookup().getName().equals(strDatasourceSugarCrm));
        OlapClientTest.assertTrue((boolean)((MondrianConnection)connectionNew).getDataSource().getReferenceURI().equals("/analysis/datasources/SugarCRMDataSource"));
    }

    public void testXmlaDefinitionExists() {
        String strDefinition = "FoodmartXmlaDefinition";
        MondrianXMLADefinition definition = (MondrianXMLADefinition)this.getRepositoryService().getResource(null, "/analysis/xmla/definitions/" + strDefinition);
        OlapClientTest.assertNotNull((Object)definition.getURIString());
    }

    public void testXmlaConnectionExists() {
        String strXMLAConnection = "FoodmartXmlaConnection";
        OlapClientConnection connection = (OlapClientConnection)this.getRepositoryService().getResource(null, "/analysis/connections/" + strXMLAConnection);
        OlapClientTest.assertNotNull((Object)connection);
    }

    public void testOlapConnectionlParsesQuery() {
        String olapViewRef = "/analysis/connections/Foodmart";
        String olapQuery = "SELECT {[Measures].[Unit Sales]} ON COLUMNS, {[Time].[1997].[Q1]} ON ROWS FROM [Sales]";
        Connection mondrianConnection = ((OlapConnectionServiceImpl)this.getConnectionService()).getMondrianConnection(null, olapViewRef);
        Query mondrianQuery = mondrianConnection.parseQuery(olapQuery);
        OlapClientTest.assertNotNull((Object)mondrianQuery);
        OlapClientTest.assertTrue((boolean)mondrianQuery.getCube().toString().equals("Sales"));
    }

    public void testOlapViewQuery() {
        String strOlapView = "Foodmart_sample";
        OlapUnit olapView = (OlapUnit)this.getRepositoryService().getResource(null, "/analysis/views/" + strOlapView);
        OlapClientTest.assertNotNull((Object)olapView.getOlapClientConnection());
        OlapClientTest.assertTrue((boolean)olapView.getMdxQuery().equals(OlapConnectionTest.SAMPLE_FOODMART_MDX_QUERY));
    }

    public OlapConnectionService getConnectionService() {
        return this.connectionService;
    }

    public void setConnectionService(OlapConnectionService connection) {
        this.connectionService = connection;
    }
}

