/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.battery.assertion;

import junit.framework.TestCase;
import org.apache.maven.surefire.Surefire;
import org.apache.maven.surefire.battery.assertion.BatteryComparisonFailure;
import org.apache.maven.surefire.battery.assertion.BatteryTestFailedException;

public class BatteryAssert
extends TestCase {
    public static void verify(boolean condition) {
        String detailMsg = Surefire.getResources().getString("conditionFalse");
        BatteryAssert.verify(condition, detailMsg);
    }

    public static void verify(boolean condition, String message) {
        if (message == null) {
            throw new NullPointerException("message is null");
        }
        if (!condition) {
            throw new BatteryTestFailedException(message);
        }
    }

    public static void fail() {
        throw new BatteryTestFailedException();
    }

    public static void fail(String message) {
        if (message == null) {
            throw new NullPointerException("message is null");
        }
        throw new BatteryTestFailedException(message);
    }

    public static void fail(String message, Throwable cause) {
        if (message == null) {
            throw new NullPointerException("message is null");
        }
        if (cause == null) {
            throw new NullPointerException("cause is null");
        }
        throw new BatteryTestFailedException(message, cause);
    }

    public static void fail(Throwable cause) {
        if (cause == null) {
            throw new NullPointerException("cause is null");
        }
        throw new BatteryTestFailedException(cause.toString(), cause);
    }

    public static void assertTrue(String message, boolean condition) {
        if (!condition) {
            BatteryAssert.fail(message);
        }
    }

    public static void assertTrue(boolean condition) {
        BatteryAssert.assertTrue(null, condition);
    }

    public static void assertFalse(String message, boolean condition) {
        BatteryAssert.assertTrue(message, !condition);
    }

    public static void assertFalse(boolean condition) {
        BatteryAssert.assertFalse(null, condition);
    }

    public static void assertEquals(String message, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        BatteryAssert.failNotEquals(message, expected, actual);
    }

    public static void assertEquals(Object expected, Object actual) {
        BatteryAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, String expected, String actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        throw new BatteryComparisonFailure(message, expected, actual);
    }

    public static void assertEquals(String expected, String actual) {
        BatteryAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, double expected, double actual, double delta) {
        if (Double.isInfinite(expected)) {
            if (expected != actual) {
                BatteryAssert.failNotEquals(message, new Double(expected), new Double(actual));
            }
        } else if (!(Math.abs(expected - actual) <= delta)) {
            BatteryAssert.failNotEquals(message, new Double(expected), new Double(actual));
        }
    }

    public static void assertEquals(double expected, double actual, double delta) {
        BatteryAssert.assertEquals(null, expected, actual, delta);
    }

    public static void assertEquals(String message, float expected, float actual, float delta) {
        if (Float.isInfinite(expected)) {
            if (expected != actual) {
                BatteryAssert.failNotEquals(message, new Float(expected), new Float(actual));
            }
        } else if (!(Math.abs(expected - actual) <= delta)) {
            BatteryAssert.failNotEquals(message, new Float(expected), new Float(actual));
        }
    }

    public static void assertEquals(float expected, float actual, float delta) {
        BatteryAssert.assertEquals(null, expected, actual, delta);
    }

    public static void assertEquals(String message, long expected, long actual) {
        BatteryAssert.assertEquals(message, new Long(expected), new Long(actual));
    }

    public static void assertEquals(long expected, long actual) {
        BatteryAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, boolean expected, boolean actual) {
        BatteryAssert.assertEquals(message, new Boolean(expected), new Boolean(actual));
    }

    public static void assertEquals(boolean expected, boolean actual) {
        BatteryAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, byte expected, byte actual) {
        BatteryAssert.assertEquals(message, new Byte(expected), new Byte(actual));
    }

    public static void assertEquals(byte expected, byte actual) {
        BatteryAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, char expected, char actual) {
        BatteryAssert.assertEquals(message, new Character(expected), new Character(actual));
    }

    public static void assertEquals(char expected, char actual) {
        BatteryAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, short expected, short actual) {
        BatteryAssert.assertEquals(message, new Short(expected), new Short(actual));
    }

    public static void assertEquals(short expected, short actual) {
        BatteryAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, int expected, int actual) {
        BatteryAssert.assertEquals(message, new Integer(expected), new Integer(actual));
    }

    public static void assertEquals(int expected, int actual) {
        BatteryAssert.assertEquals(null, expected, actual);
    }

    public static void assertNotNull(Object object) {
        BatteryAssert.assertNotNull(null, object);
    }

    public static void assertNotNull(String message, Object object) {
        BatteryAssert.assertTrue(message, object != null);
    }

    public static void assertNull(Object object) {
        BatteryAssert.assertNull(null, object);
    }

    public static void assertNull(String message, Object object) {
        BatteryAssert.assertTrue(message, object == null);
    }

    public static void assertSame(String message, Object expected, Object actual) {
        if (expected == actual) {
            return;
        }
        BatteryAssert.failNotSame(message, expected, actual);
    }

    public static void assertSame(Object expected, Object actual) {
        BatteryAssert.assertSame(null, expected, actual);
    }

    public static void assertNotSame(String message, Object expected, Object actual) {
        if (expected == actual) {
            BatteryAssert.failSame(message);
        }
    }

    public static void assertNotSame(Object expected, Object actual) {
        BatteryAssert.assertNotSame(null, expected, actual);
    }

    private static void failSame(String message) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        BatteryAssert.fail(formatted + "expected not same");
    }

    private static void failNotSame(String message, Object expected, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        BatteryAssert.fail(formatted + "expected same:<" + expected + "> was not:<" + actual + ">");
    }

    private static void failNotEquals(String message, Object expected, Object actual) {
        BatteryAssert.fail(BatteryAssert.formatMismatch(message, expected, actual));
    }

    static String formatMismatch(String message, Object expected, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        return formatted + "expected:<" + expected + "> but was:<" + actual + ">";
    }
}

