/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.battery;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.surefire.battery.AbstractBattery;
import org.apache.maven.surefire.util.DirectoryScanner;
import org.apache.maven.surefire.util.StringUtils;

public class DirectoryBattery
extends AbstractBattery {
    private static final String FS = System.getProperty("file.separator");
    private File basedir;
    private List includes;
    private List excludes;

    public DirectoryBattery(File basedir, ArrayList includes, ArrayList excludes) throws Exception {
        this.basedir = basedir;
        this.includes = includes;
        this.excludes = excludes;
        this.discoverBatteryClassNames();
    }

    public void discoverBatteryClassNames() throws Exception {
        String[] tests = this.collectTests(this.basedir, this.includes, this.excludes);
        if (tests == null) {
            return;
        }
        for (int i = 0; i < tests.length; ++i) {
            String s = tests[i];
            s = s.substring(0, s.indexOf("."));
            s = s.replace(FS.charAt(0), ".".charAt(0));
            this.addSubBatteryClassName(s);
        }
    }

    public String[] collectTests(File basedir, List includes, List excludes) throws Exception {
        int i;
        if (!basedir.exists()) {
            return null;
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(basedir);
        if (includes != null) {
            String[] incs = new String[includes.size()];
            for (i = 0; i < incs.length; ++i) {
                incs[i] = StringUtils.replace((String)includes.get(i), "java", "class");
            }
            scanner.setIncludes(incs);
        }
        if (excludes != null) {
            String[] excls = new String[excludes.size()];
            for (i = 0; i < excls.length; ++i) {
                excls[i] = StringUtils.replace((String)excludes.get(i), "java", "class");
            }
            scanner.setExcludes(excls);
        }
        scanner.scan();
        return scanner.getIncludedFiles();
    }
}

