/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.awt.Image;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.engine.print.JRPrinterAWT;
import net.sf.jasperreports.engine.util.JRLoader;

public class JasperPrintManager {
    protected static final boolean unixSunJDK;

    public static String printReportToPdfFile(String sourceFileName) throws JRException {
        return JasperExportManager.exportReportToPdfFile((String)sourceFileName);
    }

    public static void printReportToPdfFile(String sourceFileName, String destFileName) throws JRException {
        JasperExportManager.exportReportToPdfFile((String)sourceFileName, (String)destFileName);
    }

    public static void printReportToPdfFile(JasperPrint jasperPrint, String destFileName) throws JRException {
        JasperExportManager.exportReportToPdfFile((JasperPrint)jasperPrint, (String)destFileName);
    }

    public static void printReportToPdfStream(InputStream inputStream, OutputStream outputStream) throws JRException {
        JasperExportManager.exportReportToPdfStream((InputStream)inputStream, (OutputStream)outputStream);
    }

    public static void printReportToPdfStream(JasperPrint jasperPrint, OutputStream outputStream) throws JRException {
        JasperExportManager.exportReportToPdfStream((JasperPrint)jasperPrint, (OutputStream)outputStream);
    }

    public static byte[] printReportToPdf(JasperPrint jasperPrint) throws JRException {
        return JasperExportManager.exportReportToPdf((JasperPrint)jasperPrint);
    }

    public static String printReportToXmlFile(String sourceFileName, boolean isEmbeddingImages) throws JRException {
        return JasperExportManager.exportReportToXmlFile((String)sourceFileName, (boolean)isEmbeddingImages);
    }

    public static void printReportToXmlFile(String sourceFileName, String destFileName, boolean isEmbeddingImages) throws JRException {
        JasperExportManager.exportReportToXmlFile((String)sourceFileName, (String)destFileName, (boolean)isEmbeddingImages);
    }

    public static void printReportToXmlFile(JasperPrint jasperPrint, String destFileName, boolean isEmbeddingImages) throws JRException {
        JasperExportManager.exportReportToXmlFile((JasperPrint)jasperPrint, (String)destFileName, (boolean)isEmbeddingImages);
    }

    public static void printReportToXmlStream(InputStream inputStream, OutputStream outputStream) throws JRException {
        JasperExportManager.exportReportToXmlStream((InputStream)inputStream, (OutputStream)outputStream);
    }

    public static void printReportToXmlStream(JasperPrint jasperPrint, OutputStream outputStream) throws JRException {
        JasperExportManager.exportReportToXmlStream((JasperPrint)jasperPrint, (OutputStream)outputStream);
    }

    public static String printReportToXml(JasperPrint jasperPrint) throws JRException {
        return JasperExportManager.exportReportToXml((JasperPrint)jasperPrint);
    }

    public static boolean printReport(String sourceFileName, boolean withPrintDialog) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(sourceFileName);
        return JasperPrintManager.printReport(jasperPrint, withPrintDialog);
    }

    public static boolean printReport(InputStream inputStream, boolean withPrintDialog) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(inputStream);
        return JasperPrintManager.printReport(jasperPrint, withPrintDialog);
    }

    public static boolean printReport(JasperPrint jasperPrint, boolean withPrintDialog) throws JRException {
        if (!JasperPrintManager.checkAvailablePrinters()) {
            throw new JRException("No printer available.");
        }
        return JasperPrintManager.printPages(jasperPrint, 0, jasperPrint.getPages().size() - 1, withPrintDialog);
    }

    public static boolean printPage(String sourceFileName, int pageIndex, boolean withPrintDialog) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(sourceFileName);
        return JasperPrintManager.printPage(jasperPrint, pageIndex, withPrintDialog);
    }

    public static boolean printPage(InputStream inputStream, int pageIndex, boolean withPrintDialog) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(inputStream);
        return JasperPrintManager.printPage(jasperPrint, pageIndex, withPrintDialog);
    }

    public static boolean printPage(JasperPrint jasperPrint, int pageIndex, boolean withPrintDialog) throws JRException {
        return JasperPrintManager.printPages(jasperPrint, pageIndex, pageIndex, withPrintDialog);
    }

    public static boolean printPages(String sourceFileName, int firstPageIndex, int lastPageIndex, boolean withPrintDialog) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(sourceFileName);
        return JasperPrintManager.printPages(jasperPrint, firstPageIndex, lastPageIndex, withPrintDialog);
    }

    public static boolean printPages(InputStream inputStream, int firstPageIndex, int lastPageIndex, boolean withPrintDialog) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(inputStream);
        return JasperPrintManager.printPages(jasperPrint, firstPageIndex, lastPageIndex, withPrintDialog);
    }

    public static boolean printPages(JasperPrint jasperPrint, int firstPageIndex, int lastPageIndex, boolean withPrintDialog) throws JRException {
        return JRPrinterAWT.printPages(jasperPrint, firstPageIndex, lastPageIndex, withPrintDialog);
    }

    public static Image printPageToImage(String sourceFileName, int pageIndex, float zoom) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(sourceFileName);
        return JasperPrintManager.printPageToImage(jasperPrint, pageIndex, zoom);
    }

    public static Image printPageToImage(InputStream inputStream, int pageIndex, float zoom) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(inputStream);
        return JasperPrintManager.printPageToImage(jasperPrint, pageIndex, zoom);
    }

    public static Image printPageToImage(JasperPrint jasperPrint, int pageIndex, float zoom) throws JRException {
        return JRPrinterAWT.printPageToImage(jasperPrint, pageIndex, zoom);
    }

    private static boolean checkAvailablePrinters() {
        return unixSunJDK ? true : JRPrintServiceExporter.checkAvailablePrinters();
    }

    static {
        boolean found = false;
        try {
            Class.forName("sun.print.UnixPrintServiceLookup");
            found = true;
        }
        catch (Throwable e) {
            found = false;
        }
        unixSunJDK = found;
    }
}

