/*
 * Decompiled with CFR 0.152.
 */
package jas;

import jas.Annotation;
import jas.AsciiCP;
import jas.CP;
import jas.ClassEnv;
import jas.jasError;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class AnnotParamAttr {
    CP attr;
    Vector anns;

    public AnnotParamAttr(boolean visible) {
        this.attr = new AsciiCP(visible ? "RuntimeVisibleParameterAnnotations" : "RuntimeInvisibleParameterAnnotations");
        this.anns = new Vector();
    }

    public void add(Annotation annotation, int paramnum) {
        Vector<Annotation> ap = null;
        int top = this.anns.size();
        if (paramnum < top) {
            ap = (Vector)this.anns.elementAt(paramnum);
        }
        if (ap == null) {
            if (paramnum >= top) {
                this.anns.setSize(paramnum + 1);
            }
            ap = new Vector<Annotation>();
            this.anns.set(paramnum, ap);
        }
        ap.add(annotation);
    }

    void resolve(ClassEnv e) {
        e.addCPItem(this.attr);
        int top = this.anns.size();
        for (int i = 0; i < top; ++i) {
            Vector ap = (Vector)this.anns.elementAt(i);
            if (ap == null) continue;
            Enumeration en = ap.elements();
            while (en.hasMoreElements()) {
                ((Annotation)en.nextElement()).resolve(e);
            }
        }
    }

    void write(ClassEnv e, DataOutputStream out) throws IOException, jasError {
        Enumeration en;
        Vector ap;
        int i;
        out.writeShort(e.getCPIndex(this.attr));
        int top = this.anns.size();
        int len = 1 + 2 * top;
        for (i = 0; i < top; ++i) {
            ap = (Vector)this.anns.elementAt(i);
            if (ap == null) continue;
            en = ap.elements();
            while (en.hasMoreElements()) {
                len += ((Annotation)en.nextElement()).size();
            }
        }
        out.writeInt(len);
        out.writeByte((byte)top);
        for (i = 0; i < top; ++i) {
            ap = (Vector)this.anns.elementAt(i);
            if (ap == null) {
                out.writeShort(0);
                continue;
            }
            out.writeShort((short)ap.size());
            en = ap.elements();
            while (en.hasMoreElements()) {
                ((Annotation)en.nextElement()).write(e, out);
            }
        }
    }
}

