/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.pkcs;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class RC2CBCParameter
implements DEREncodable {
    DERInteger version;
    ASN1OctetString iv;

    public static RC2CBCParameter getInstance(Object object) {
        if (object instanceof ASN1Sequence) {
            return new RC2CBCParameter((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in RC2CBCParameter factory");
    }

    public RC2CBCParameter(byte[] byArray) {
        this.version = null;
        this.iv = new DEROctetString(byArray);
    }

    public RC2CBCParameter(int n, byte[] byArray) {
        this.version = new DERInteger(n);
        this.iv = new DEROctetString(byArray);
    }

    public RC2CBCParameter(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() == 1) {
            this.version = null;
            this.iv = (ASN1OctetString)aSN1Sequence.getObjectAt(0);
        } else {
            this.version = (DERInteger)aSN1Sequence.getObjectAt(0);
            this.iv = (ASN1OctetString)aSN1Sequence.getObjectAt(1);
        }
    }

    public BigInteger getRC2ParameterVersion() {
        if (this.version == null) {
            return null;
        }
        return this.version.getValue();
    }

    public byte[] getIV() {
        return this.iv.getOctets();
    }

    public DERObject getDERObject() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.version != null) {
            aSN1EncodableVector.add(this.version);
        }
        aSN1EncodableVector.add(this.iv);
        return new DERSequence(aSN1EncodableVector);
    }
}

