/*
 * JaLingo, http://jalingo.sourceforge.net/
 *
 * Copyright (c) 2002-2006 Oleksandr Shyshko
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package ja.lingo.readers.mova;

import junit.framework.TestCase;
import ja.lingo.engine.dictionaryindex.builder.MockDictionaryIndexBuilder;
import ja.lingo.engine.dictionaryindex.Token;
import ja.lingo.engine.dictionaryindex.reader.IIndexSource;
import ja.centre.util.io.ByteArray;

public class MovaParserTest extends TestCase {
    public void testAppendArticle_noBody() throws Exception {
        MovaParser parser = new MovaParser();
        MockDictionaryIndexBuilder builder = new MockDictionaryIndexBuilder();

        String line = "title ";
        parser.appendArticle( line, new ByteArray( line.getBytes( "ISO-8859-1" ) ), 0, builder );

        IIndexSource indexSource = builder.getIndexSource();

        assertEquals( new Token( 0, line.length() ), indexSource.getTitlesTokenReader().getToken( 0 ) );
        assertEquals( new Token( line.length(), 0 ), indexSource.getBodiesTokenReader().getToken( 0 ) );
    }
}