/*
 * JaLingo, http://jalingo.sourceforge.net/
 *
 * Copyright (c) 2002-2006 Oleksandr Shyshko
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package ja.lingo.engine.util.comparators;

import ja.JaTestCase;

import java.util.*;

public class CollatingStringComparatorTest extends JaTestCase {
    private CollatingStringComparator comparator = new CollatingStringComparator();

    public void test() {
        assertEquals( -1, comparator.compare( "a", "b" ) );

        assertEquals( 0, comparator.compare( "a", "a" ) );

        assertEquals( 1, comparator.compare( "A", "a" ) );
        assertEquals( 1, comparator.compare( "aero", "A" ) );
    }

    public void testAccentedEqualsRegular() {
        assertEquals( 0, comparator.compareIgnoreAccents( "\u00E4", "a" ) );
    }

    public void testAsciiSortMatchesNatural() {
        List<String> natural = new ArrayList<String>();
        for ( char i = CollatingStringComparator.SEGMENT_1_START; i < CollatingStringComparator.SEGMENT_1_END; i++ ) {
            natural.add( i + "a" );
        }
        for ( char i = CollatingStringComparator.SEGMENT_2_START; i < CollatingStringComparator.SEGMENT_2_END; i++ ) {
            natural.add( i + "a" );
        }

        List<String> collated = new ArrayList<String>( natural );

        Collections.sort( natural );
        Collections.sort( collated, comparator );

        assertEquals( natural.toString(), collated.toString() );
    }

    public void testIsInBoostRange() throws Exception {
        assertTrue( CollatingStringComparator.isInBoostRange( "abc" ) );
        assertTrue( CollatingStringComparator.isInBoostRange( "!'sf" ) );
        assertFalse( CollatingStringComparator.isInBoostRange( "aA" ) );
        assertFalse( CollatingStringComparator.isInBoostRange( "\u00b8" ) );
    }

    public void testEngWithCyrillic() {
        List<String> expected = Arrays.asList(
                "a", "A",
                "b", "B",
                "c", "C",
                "d", "D",
                "y", "Y",
                "z", "Z",
                "\u0430", "\u0410", // a,  a
                "\u0431", "\u0411", // be, Be
                "\u0432", "\u0412", // ve, Ve
                "\u0433", "\u0413", // ge, Ge
                "\u0434", "\u0414", // de, de
                "\u044b", "\u042b"  // bl, bl
        );
        List <String> collated = new ArrayList<String>( expected );

        Collections.sort( collated, comparator );

        assertEquals( expected.toString(), collated.toString() );
    }
}