/*
 * JaLingo, http://jalingo.sourceforge.net/
 *
 * Copyright (c) 2002-2006 Oleksandr Shyshko
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package ja.lingo.engine.mergedindex;

import ja.lingo.engine.beans.IArticle;
import ja.lingo.engine.dictionaryindex.reader.IDictionaryIndex;
import ja.centre.util.assertions.Arguments;
import ja.centre.util.assertions.States;

import java.io.IOException;
import java.util.List;
import java.util.ArrayList;

public class MockBuchIndexBuilder implements IMergedIndexBuilder {
    private List<IArticle> articles = new ArrayList<IArticle>();

    private boolean closed;
    private boolean readersWritten;

    public void write( IArticle article ) throws IOException {
        Arguments.assertNotNull( "article", article );

        articles.add( article );
    }

    public void close() throws IOException {
        closed = true;
    }

    public void writeReaders( List<IDictionaryIndex> readers ) throws IOException {
        Arguments.assertNotNull( "readers", readers );
        readersWritten = true;
    }

    public void verify() {
        States.assertTrue( readersWritten, "Readers were not written" );
        States.assertTrue( closed, "Wasn't closed" );
    }

    public IMergedIndex getMergedIndex() {
        return new MockMergedIndex( articles );
    }
}
