/*
 * JaLingo, http://jalingo.sourceforge.net/
 *
 * Copyright (c) 2002-2006 Oleksandr Shyshko
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package ja.lingo.engine;

import ja.JaTestCase;

import java.io.IOException;

public class EngineModelManagerTest extends JaTestCase {
    private EngineModelManager manager;
    private MockVersioner versioner;

    protected void setUp() throws Exception {
        super.setUp();
        versioner = new MockVersioner();
        manager = new EngineModelManager( versioner );
    }

    public void testGreater() throws UnknownCacheVersionException, IOException {
        manager.checkCacheVersion( "0.9" );
        assertTrue( versioner.isThrowUnknownVersionInvoker() );
        assertFalse( versioner.isUpdateVersion_0_5Invoked() );
    }
    public void test052() throws UnknownCacheVersionException, IOException {
        manager.checkCacheVersion( "0.5.2" );
        assertFalse( versioner.isThrowUnknownVersionInvoker() );
        assertFalse( versioner.isUpdateVersion_0_5Invoked() );
    }
    public void test051() throws UnknownCacheVersionException, IOException {
        manager.checkCacheVersion( "0.5.1" );
        assertFalse( versioner.isThrowUnknownVersionInvoker() );
        assertTrue( versioner.isUpdateVersion_0_5Invoked() );
    }
    public void test050() throws UnknownCacheVersionException, IOException {
        manager.checkCacheVersion( "0.5.0" );
        assertFalse( versioner.isThrowUnknownVersionInvoker() );
        assertTrue( versioner.isUpdateVersion_0_5Invoked() );
    }

    private static class MockVersioner implements EngineModelManager.IVersioner {
        private boolean throwUnknownVersionInvoker;
        private boolean updateVersion_0_5Invoked;

        public void throwUnknownVersion( String existingVersion, String currentVersion ) throws UnknownCacheVersionException {
            throwUnknownVersionInvoker = true;
        }
        public void updateVersion_0_5( String existingVersion, String currentVersion ) throws IOException {
            updateVersion_0_5Invoked = true;
        }

        public boolean isThrowUnknownVersionInvoker() {
            return throwUnknownVersionInvoker;
        }
        public boolean isUpdateVersion_0_5Invoked() {
            return updateVersion_0_5Invoked;
        }
    }
}