/*
 * JaLingo, http://jalingo.sourceforge.net/
 *
 * Copyright (c) 2002-2006 Oleksandr Shyshko
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package ja.lingo.application.util.progress.engine;

import junit.framework.TestCase;

public class PhazesMonitorTest extends TestCase {
    private static final int P0_START = 100;
    private static final int P0_MIDDLE = 150;
    private static final int P0_END = 200;

    private static final int P0_START_VALUE = 0;
    private static final int P0_MIDDLE_VALUE = 250;
    private static final int P0_END_VALUE = 500;

    private static final int P1_START = 50;
    private static final int P1_MIDDLE = 175;
    private static final int P1_END = 300;

    private static final int P1_START_VALUE = 500;
    private static final int P1_MIDDLE_VALUE = 750;
    private static final int P1_END_VALUE = 1000;

    public void test() {
        MockTitledMonitor monitor = new MockTitledMonitor();
        PhazesMonitor adapter = new PhazesMonitor( monitor, 2 );

        // phaze 0
        adapter.start( P0_START, P0_END );

        assertEquals( 0, monitor.getMinimum() );
        assertEquals( 1000, monitor.getMaximum() );

        adapter.update( P0_START );
        assertEquals( P0_START_VALUE, monitor.getValue() );

        adapter.update( P0_MIDDLE );
        assertEquals( P0_MIDDLE_VALUE, monitor.getValue() );

        adapter.update( P0_END );
        assertEquals( P0_END_VALUE, monitor.getValue() );

        adapter.finish();
        assertEquals( P0_END_VALUE, monitor.getValue() );

        // phaze 1
        adapter.start( P1_START, P1_END );

        assertEquals( 0, monitor.getMinimum() );
        assertEquals( 1000, monitor.getMaximum() );

        adapter.update( P1_START );
        assertEquals( P1_START_VALUE, monitor.getValue() );

        adapter.update( P1_MIDDLE );
        assertEquals( P1_MIDDLE_VALUE, monitor.getValue() );

        adapter.update( P1_END );
        assertEquals( P1_END_VALUE, monitor.getValue() );

        adapter.finish();
        assertEquals( P1_END_VALUE, monitor.getValue() );
    }
}